% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construction.R
\name{Rd}
\alias{Rd}
\title{Construct an Rd container}
\usage{
Rd(..., content = list(...), .check = NA,
  verbose = getOption("Rd::verbose", getOption("verbose", FALSE)))
}
\arguments{
\item{..., content}{Content specified in individual or list form.
Either may be used but only one.
All elements should be unnamed.}

\item{.check}{Should the content be checked for valid Rd and if options are valid?
A value of FALSE indicates no checking,
TRUE strict checking and
NA convert where possible, with messages and warnings.}

\item{verbose}{Print informational messages.}
}
\value{
Will always return valid Rd in canonical form.
}
\description{
An Rd container is a list which contains other Rd objects.
}
\details{
An empty Rd vector can be created with a \code{Rd()} call.
A call to Rd with only one argument will not create a double nested list,
but will encapsulate tags and strings.  For example,
calling \code{Rd(Rd('test'))} has the same effect as \code{Rd('test')}

A character vector may be passed to Rd where it is
collapsed  and normalized to a \code{Rd} container of Rd string.
}
\examples{
## Recreating the first few lines of the `example` help file.
R <- Rd_tag("\\\\R")
Rd( Rd_name('example'), '\\n'
  , Rd_alias('example'), '\\n'
  , Rd_title("Run an Examples Section from the Online Help"), '\\n'
  , Rd_description( "Run all ", R, " code from the "
                  , Rd_tag("\\\\bold", "Examples"), " part of \\n"
                  , R, "'s online help topic ", Rd_code("topic")
                  , " with possible exceptions \\n"
                  , Rd_code("dontrun"), ", "
                  , Rd_code("dontshow"), ", and "
                  , Rd_code("donttest"), ",\\n see "
                  , Rd_tag("\\\\sQuote", "Details"), " below."
                  )
  )
}
\seealso{
Other construction: \code{\link{Rd_string_creation}},
  \code{\link{Rd_tag}}
}
\concept{construction}
