% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_extensions.R
\name{Rd-extraction}
\alias{Rd-extraction}
\alias{Rd_get_element}
\alias{[[.Rd_tag}
\alias{[[.Rd}
\alias{Rd_subset}
\alias{[.Rd}
\alias{[.Rd_tag}
\title{Extract elements from Rd containers

These functions can be used to extract or subset elements of
Rd lists, either bare \code{Rd} containers or \code{Rd_tag} objects.
The \code{[[} operator performs classification of output.
\code{Rd_get_element} acts as \code{[[} but will also accept tags to
search for.  The \code{[} operator wraps
\code{Rd_subset}, respectively.}
\usage{
Rd_get_element(x, ..., drop = TRUE)

\method{[[}{Rd_tag}(x, ...)

\method{[[}{Rd}(x, ...)

Rd_subset(x, i, ..., drop = FALSE)

\method{[}{Rd}(x, ...)

\method{[}{Rd_tag}(x, ...)
}
\arguments{
\item{x}{Either an \code{Rd} or \code{Rd_tag} object.}

\item{...}{Must be empty.}

\item{drop}{For matrices and arrays.  If \code{TRUE} the result is
    coerced to the lowest possible dimension (see the examples).  This
    only works for extracting elements, not for the replacement.  See
    \code{\link{drop}} for further details.
  }

\item{i}{
    indices specifying elements to extract or replace.  Indices are
    \code{numeric} or \code{character} vectors or empty (missing) or
    \code{NULL}.  Numeric values are coerced to integer as by
    \code{\link{as.integer}} (and hence truncated towards zero).
    Character vectors will be matched to the \code{\link{names}} of the
    object (or for matrices/arrays, the \code{\link{dimnames}}):
    see \sQuote{Character indices} below for further details.

    For \code{[}-indexing only: \code{i}, \code{j}, \code{\dots} can be
    logical vectors, indicating elements/slices to select.  Such vectors
    are recycled if necessary to match the corresponding extent.
    \code{i}, \code{j}, \code{\dots} can also be negative integers,
    indicating elements/slices to leave out of the selection.

    When indexing arrays by \code{[} a single argument \code{i} can be a
    matrix with as many columns as there are dimensions of \code{x}; the
    result is then a vector with elements corresponding to the sets of
    indices in each row of \code{i}.

    An index value of \code{NULL} is treated as if it were \code{integer(0)}.
  }
}
\value{
\itemize{
\item \strong{\code{Rd_get_element} and \code{\link[base:Extract]{[[}}:}
the return value is not necessarily an Rd.
The class of the element returned will
inferred if it does not have a class.
Lists will be classed as \code{Rd} unless the \code{Rd_tag} attribute
is set in which case a \code{Rd_tag} will be returned
\item \strong{\code{Rd_subset} and \code{\link[base:Extract]{[}}:}
will always return a value of the same class as is given.
Even if what is returned is an empty list, an empty list with
the \code{Rd_tag} attribute set is valid, and denotes a tag without
any content such as the "\\item" tag.
}
}
\description{
Extract elements from Rd containers

These functions can be used to extract or subset elements of
Rd lists, either bare \code{Rd} containers or \code{Rd_tag} objects.
The \code{[[} operator performs classification of output.
\code{Rd_get_element} acts as \code{[[} but will also accept tags to
search for.  The \code{[} operator wraps
\code{Rd_subset}, respectively.
}
\seealso{
\link[base:Extract]{base::Extract}
}
