% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cqp.R
\name{cqp_query}
\alias{cqp_query}
\alias{cqp_dump_subcorpus}
\alias{cqp_subcorpus_size}
\alias{cqp_list_subcorpora}
\title{Execute CQP Query and Retrieve Results.}
\usage{
cqp_query(corpus, query, subcorpus = "QUERY")

cqp_dump_subcorpus(corpus, subcorpus = "QUERY")

cqp_subcorpus_size(corpus, subcorpus = "QUERY")

cqp_list_subcorpora(corpus)
}
\arguments{
\item{corpus}{a CWB corpus}

\item{query}{a CQP query}

\item{subcorpus}{subcorpus name}
}
\description{
Using CQP queries requires a two-step procedure: At first, you execute a
query using \code{cqp_query}. Then, \code{cqp_dump_subcorpus} will return a
matrix with the regions of the matches for the query.
}
\details{
The \code{cqp_query} function executes a CQP query. The
\code{cqp_subcorpus_size} function returns the number of matches for the CQP
query. The \code{cqp_dump_subcorpus} function will return a two-column matrix
with the left and right corpus positions of the matches for the CQP query.
}
\examples{
registry <- if (!check_pkg_registry_files()) use_tmp_registry() else get_pkg_registry()

if (!cqp_is_initialized()){
  cqp_initialize(registry = registry)
} else {
  if (cqp_get_registry() != registry) cqp_reset_registry(registry)
}
cqp_query(corpus = "REUTERS", query = '"oil";')
cqp_subcorpus_size("REUTERS")
cqp_dump_subcorpus("REUTERS")

cqp_query(corpus = "REUTERS", query = '"crude" "oil";')
cqp_subcorpus_size("REUTERS", subcorpus = "QUERY")
cqp_dump_subcorpus("REUTERS")
}
\references{
Evert, S. 2005. The CQP Query Language Tutorial. Available online at
\url{http://cwb.sourceforge.net/files/CWB_Encoding_Tutorial.pdf}
}
\author{
Andreas Blaette, Bernard Desgraupes, Sylvain Loiseau
}
