% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_unnest.R
\name{cdb_unnest}
\alias{cdb_unnest}
\title{Unnest a COM(P)ADRE database by spreading the components of CompadreMat into
separate list-columns}
\usage{
cdb_unnest(
  cdb,
  components = c("matA", "matU", "matF", "matC", "MatrixClassAuthor",
    "MatrixClassOrganized", "MatrixClassNumber")
)
}
\arguments{
\item{cdb}{A CompadreDB object}

\item{components}{Character vector specifying which components to extract.

  Defaults to all, i.e. \code{c("matA", "matU", "matF", "matC",
  "MatrixClassAuthor", "MatrixClassOrganized", "MatrixClassNumber")}}
}
\value{
\code{cdb} with additional list-columns for each element of argument
  \code{components}
}
\description{
Unnests a CompadreDB object by spreading the components of CompadreMat into
separate list-columns. Components that may be extracted include:
\itemize{
  \item \code{matA} (matrix)
  \item \code{matU} (matrix)
  \item \code{matF} (matrix)
  \item \code{matC} (matrix)
  \item \code{MatrixClassAuthor} (character vector)
  \item \code{MatrixClassOrganized} (character vector)
  \item \code{MatrixClassNumber} (integer vector)
}
}
\examples{
# unnest all components
CompadreUnnest <- cdb_unnest(Compadre)

# unnest select components (matU and MatrixClassAuthor)
CompadreUnnest <- cdb_unnest(Compadre, c("matU", "MatrixClassAuthor"))

}
\seealso{
Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_stages}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{mpm_mean}()},
\code{\link{mpm_median}()},
\code{\link{mpm_sd}()},
\code{\link{string_representation}}
}
\author{
Patrick M. Barks <patrick.barks@gmail.com>
}
\concept{data management}
