% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdb_id_stages.R
\name{cdb_id_stages}
\alias{cdb_id_stages}
\title{Create integer identifiers for a COM(P)ADRE database corresponding to unique
combinations of species and matrix stage class definitions}
\usage{
cdb_id_stages(cdb, stage_def = "MatrixClassAuthor")
}
\arguments{
\item{cdb}{A CompadreDB object}

\item{stage_def}{Whether to define matrix stage class based on
"MatrixClassAuthor" or "MatrixClassOrganized" (see \emph{Details}).
Defaults to "MatrixClassAuthor".}
}
\value{
Vector of integer identifiers corresponding to the rows of
  \code{cdb}.
}
\description{
Creates a vector of integer identifiers corresponding to the rows of a
CompadreDB object, based on unique combinations of the column
'SpeciesAccepted' and a list of matrix stage class definitions (either
'MatrixClassAuthor' or 'MatrixClassOrganized').
}
\details{
The vector 'MatrixClassOrganized' reflects standardized stage classes
('prop', 'active', or 'dorm'), whereas 'MatrixClassAuthor' reflects a
description of the stage classes as defined by the original author (e.g.
\code{c('Seedling', 'Medium rosette', 'Large (2 rosettes)', 'Flowering')}).

Because the 'MatrixClassAuthor' definitions are less standardized, they are
more prone to typos that could lead to slight differences between stage
descriptions of matrices that really do have the same stage classes (e.g. a
set of matrices from a single study/species/population). Therefore, using
'MatrixClassAuthor' to define stage classes is potentially prone to
mistakenly 'splitting' identifiers that should really be the same.

'MatrixClassOrganized' has the opposite problem. It's possible for two
matrices from a given study to have the same stage definitions based on
'MatrixClassOrganized', but legitimately differ in stage definitions as
defined by the author. Therefore, using 'MatrixClassAuthor' to define stage
classes is potentially prone to mistakenly 'lumping' identifiers that should
actually differ.

Because the majority of studies in COM(P)ADRE use a single set of stage
definitions for all matrices, and typos are rare, results for the different
stage definitions will usually be similar. Note, however, that the actual
integers returned for the different stage definitions are likely to be very
different (because they are based on alphabetical order).
}
\examples{
cdb_id_stages(Compadre, stage_def = "MatrixClassOrganized")

}
\seealso{
\link{cdb_id}

Other data management: 
\code{\link{cdb_flatten}()},
\code{\link{cdb_id_studies}()},
\code{\link{cdb_id}()},
\code{\link{cdb_mean_matF}()},
\code{\link{cdb_rbind}()},
\code{\link{cdb_unflatten}()},
\code{\link{cdb_unnest}()},
\code{\link{mpm_mean}()},
\code{\link{mpm_median}()},
\code{\link{mpm_sd}()},
\code{\link{string_representation}}
}
\author{
Patrick Barks <patrick.barks@gmail.com>
}
\concept{data management}
