% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_groups.R
\name{get_groups}
\alias{get_groups}
\title{get_groups}
\usage{
get_groups(dataset = NULL, vintage = NULL)
}
\arguments{
\item{dataset}{A required string that sets the acronym name of the data set
of interest (e.g. "acs/acs5")}

\item{vintage}{An required numeric that sets the year of interest.}
}
\value{
A \code{data.table}
}
\description{
Get the names of Census Bureau variable groups and their
descriptive parameters

Function produces a \code{data.table} of variable groups/tables and their
descriptions.
}
\examples{
library(jsonlite)
library(data.table)
library(httr)
library(RcensusPkg)

acs5_groups_dt <- RcensusPkg::get_groups(
  dataset = "acs/acs5",
  vintage = 2019)

}
