% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RblQuery.R
\name{RblQuery}
\alias{RblQuery}
\title{Query Bloomberg and Fetch Data}
\usage{
RblQuery(identifiers, fields, from = NULL, to = Sys.Date(),
  overrides = NULL, auto.assign = FALSE, env = parent.frame(),
  split = 100, pollFrequency = 60, timeout = 3600, verbose = TRUE)
}
\arguments{
\item{identifiers}{vector of Bloomberg identifiers. Ex c('SXXE Index', 'SX5E Index')}

\item{fields}{vector of Bloomberg fields. Ex. c('PX_LAST', 'PX_CLOSE', 'PX_OPEN', 'PX_HIGH', 'PX_LOW')}

\item{from}{date or string (format YYYY-MM-DD). The start time of the period of interest}

\item{to}{date or string (format YYYY-MM-DD). The end time of the period of interest. Ignored if \emph{from} is not provided}

\item{overrides}{named list of Bloomberg overrides. Ex list('END_DT' = '20100101')}

\item{auto.assign}{logical. Should results be loaded to env? Ignored if \emph{from} is not provided}

\item{env}{where to create objects if auto.assign = TRUE}

\item{split}{maximum number of identifiers to process at once. Split requests to avoid memory leaks}

\item{pollFrequency}{the polling frequency to check if the response file is available at Bloomberg}

\item{timeout}{the timeout in seconds}

\item{verbose}{logical. Should R report extra information on progress?}
}
\value{
A list with components
\describe{
 \item{req}{
  List of characters representing each of the request files uploaded to Bloomberg
 }
 \item{out}{
  List of characters representing each of the response file downloaded from Bloomberg
 }
 \item{data}{
  Return of \code{\link{RblParse}}
 }
}
}
\description{
The function provides a high level interface to Bloomberg Datalicense 'getdata' and 'gethistory' programs.
}
\details{
The following routine to query Bloomberg is implemented:
\describe{
 \item{Build the request file}{see \code{\link{RblRequestBuilder}}}
 \item{Upload the request file}{see \code{\link{RblUpload}}}
 \item{Download the response file}{see \code{\link{RblDownload}}}
 \item{Parse the response file}{see \code{\link{RblParse}}}
}
}
\examples{
\dontrun{
# Run RblConnect first
x <- RblQuery(fields = c('PX_LAST', 'PX_OPEN', 'PX_HIGH', 'PX_LOW'), 
              identifiers = c('SXXE Index', "SX5E Index"), 
              from = '2005-01-01')
str(x)
}

}
