\docType{data}
\name{api.dict}
\alias{api.dict}
\title{API dictionary}
\usage{
data(api.dict)
}
\description{
This data set contains dictionary (\code{\link{data.table}}
object) for \code{\link{market.api.process}} function which
perform pre-process API call request, post-process API call
results and catch market level errors. Still there is
function \code{\link{market.api.query}} that do not require
any dictionary and can operate on any currency pairs. Run
\code{data(api.dict); api.dict} to print built-in
dictionary. Granularity of data is \code{c(market, base,
quote, action)}. This dictionary can be edited/extended by
user for new currency pairs.\cr Currently supported
currency pairs: \itemize{ \item \code{bitstamp: BTCUSD}
\item \code{btce: BTCUSD, LTCUSD, LTCBTC, NMCBTC} \item
\code{kraken: BTCEUR, LTCEUR, BTCLTC} \item
\code{bitmarket: BTCPLN, LTCPLN} \item \code{mtgox: BTCUSD}
}
}
\note{
Do not use \code{api.dict} from untrusted source or read
whole it's code to ensure it is safe! The api dictionary
was not fully tested, please follow the examples, if you
find any bugs please report.
}
\author{
Jan Gorecki, 2014-04-17
}
\keyword{datasets}

