% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_watershedmeb_read.R
\name{rvn_watershedmeb_read}
\alias{rvn_watershedmeb_read}
\title{Read in Raven WatershedMassEnergyBalance file}
\usage{
rvn_watershedmeb_read(ff = NA, tzone = NULL)
}
\arguments{
\item{ff}{full file path to the WatershedMassEnergyBalance.csv file}

\item{tzone}{string indicating the timezone of the data in ff}
}
\value{
\item{watershedmeb}{data frame from the file with standardized names}
 \item{units}{vector corresponding to units of each column}
 \item{from}{vector of the 'from' compartments in file}
 \item{to}{vector of the 'to' compartments in file}
}
\description{
rvn_watershedmeb_read is used to read in the WatershedMassEnergyBalance.csv file
produced by the modelling Framework Raven.
}
\details{
This function expects a full file path to the WatershedMassEnergyBalance.csv
file, then reads in the file using read.csv. The main advantage of this
functon is renaming the columns to nicer names and extracting the units into
something much easier to read. The from and to rows are also properly
handled, which is not as straightforward as some of the other Raven files.

ff is the full file path of the WatershedMassEnergyBalance.csv file. If the
file is located in the current working directory, then simply the name of
the file is sufficient.
}
\examples{
# locate RavenR Watershed Mass Energy Balance storage file
ff <- system.file("extdata","run1_WatershedMassEnergyBalance.csv", package="RavenR")

# read in file
mywshdmeb <- rvn_watershedmeb_read(ff)

# view mass energy balance time series
head(mywshdmeb$watershedmeb)

# view 'from' dataframe
mywshdmeb$from

}
\seealso{
\code{\link{rvn_watershed_read}} for reading in the
WatershedStorage.csv file
}
