% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RagGrid.R
\name{aggrid}
\alias{aggrid}
\title{Create a HTML widget using the ag-grid library}
\usage{
aggrid(data, options = list(), colOpts = list(),
  formattingOptions = list(), theme = "ag-theme-balham",
  filterOnSelect = TRUE, licenseKey = NULL, width = NULL, height = NULL,
  elementId = NULL)
}
\arguments{
\item{data}{a dataobject (either a matrix or a dataframe)}

\item{options}{a list of ag-grid grid options (see
\url{https://www.ag-grid.com/javascript-grid-properties/});}

\item{colOpts}{a list of ag-grid column options (see
\url{https://www.ag-grid.com/javascript-grid-column-definitions/});}

\item{formattingOptions}{a list of ag-grid column formatting options (see
\url{http://numeraljs.com/#format}) Also see \code{\link{formatColumns}()};}

\item{theme}{a theme class name that need to be applied for grid (see
\url{https://www.ag-grid.com/javascript-grid-styling//});}

\item{filterOnSelect}{specify whether filter is need to be perfromed on selecting a row item}

\item{licenseKey}{if you wish to use the enterprise version of ag-grid}

\item{width, height}{Width/Height in pixels (optional, defaults to automatic
sizing)}

\item{elementId}{An id for the widget (a random string by default).}
}
\description{
This function creates a HTML widget to display matrix or a dataframe using ag-grid.
}
\examples{

aggrid(iris)

}
