% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StemID.R
\name{plotgraph}
\alias{plotgraph}
\title{StemID2 Lineage Graph}
\usage{
plotgraph(object, showCells = FALSE, showTsne = TRUE, tp = 0.5,
  scthr = 0)
}
\arguments{
\item{object}{\code{Ltree} class object.}

\item{showCells}{logical. If \code{TRUE}, then projections of cells are shown in the plot. Default is \code{FALSE}.}

\item{showTsne}{logical. Tf \code{TRUE}, then show transparent t-SNE map (with transparency \code{tp}) of cells in the background. Default is \code{TRUE}.}

\item{tp}{Real number between zero and one. Level of transparency of the t-SNE map. Deafault is 0.5. See \code{showTsne}.}

\item{scthr}{Real number between zero and one. Score threshold for links to be shown in the graph. For \code{scthr=0} all significant links are shown. The
maximum score is one.}
}
\value{
None.
}
\description{
This function plots a graph of lineage trajectories connecting RaceID3 cluster medoids as inferred by StemID2 to approximate the lineage tree. The plot
highlights significant links, where colour indicates the level of significance and width indicates the link score. The node colour reflects the level
of transcriptome entropy.
}
