% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_inun.R
\name{p_inun}
\alias{p_inun}
\alias{p_inun_cran}
\title{List of Installed, Uninstalled and Non-Existing Packages}
\usage{
p_inun(..., char = NULL)

p_inun_cran(..., char = NULL, crandb = get("crandb", envir =
  .GlobalEnv))
}
\arguments{
\item{...}{any format recognized by \code{\link{cnsc}}, including list.
A vector or a list of packages.}

\item{char}{(name to) a character vector or a list. Use this argument if 
\code{...} fails or if you call the function from another function. 
If used, argument \code{...} is ignored.}

\item{crandb}{data.frame \code{crandb}.}
}
\description{
\code{p_inun} returns a list of packages installed or not installed in the computer.

In addition, \code{p_inun_cran} checks if the packages exist or do not exist in 
\code{crandb}. This latest information reminds you about all your private unpublished 
packages.
}
\examples{
## In real life, download crandb from CRAN or load it from your directory 
## with functions crandb_down() or crandb_load(). 
## In this example, we use a small file.
crandb_load(system.file("data", "zcrandb.rda", package = "RWsearch"))

## Check if packages are installed or not, and exist or not in crandb
p_inun(RWsearch, NotAPkg1, pacman, NotAPkg2, sos) 
p_inun_cran(RWsearch, NotAPkg1, pacman, NotAPkg2, sos)  

}
