/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class KernelEvaluation
implements RevisionHandler {
    protected StringBuffer m_Result = new StringBuffer();
    protected double[][] m_Evaluations = new double[0][0];
    protected int m_NumEvals = 0;
    protected int m_NumCacheHits = 0;
    protected String[] m_Options = new String[0];

    public void setUserOptions(String[] options) {
        this.m_Options = (String[])options.clone();
    }

    public String[] getUserOptions() {
        return (String[])this.m_Options.clone();
    }

    protected static String makeOptionString(Kernel Kernel2) {
        StringBuffer text = new StringBuffer();
        text.append("\nGeneral options:\n\n");
        text.append("-t <training file>\n");
        text.append("\tThe name of the training file.\n");
        text.append("-c <class index>\n");
        text.append("\tSets index of class attribute (default: last).\n");
        if (Kernel2 instanceof OptionHandler) {
            text.append("\nOptions specific to " + Kernel2.getClass().getName().replaceAll(".*\\.", "") + ":\n\n");
            Enumeration<Option> enm = Kernel2.listOptions();
            while (enm.hasMoreElements()) {
                Option option = enm.nextElement();
                text.append(option.synopsis() + "\n");
                text.append(option.description() + "\n");
            }
        }
        return text.toString();
    }

    public static String evaluate(Kernel Kernel2, String[] options) throws Exception {
        String[] userOptions;
        BufferedReader reader;
        String trainFileString = "";
        int classIndex = -1;
        if (Utils.getFlag('h', options)) {
            throw new Exception("\nHelp requested.\n" + KernelEvaluation.makeOptionString(Kernel2));
        }
        try {
            trainFileString = Utils.getOption('t', options);
            if (trainFileString.length() == 0) {
                throw new Exception("No training file given!");
            }
            reader = new BufferedReader(new FileReader(trainFileString));
            String classIndexString = Utils.getOption('c', options);
            if (classIndexString.length() != 0) {
                classIndex = classIndexString.equals("first") ? 1 : (classIndexString.equals("last") ? -1 : Integer.parseInt(classIndexString));
            }
            userOptions = (String[])options.clone();
            if (Kernel2 instanceof OptionHandler) {
                Kernel2.setOptions(options);
            }
            Utils.checkForRemainingOptions(options);
        }
        catch (Exception e) {
            throw new Exception("\nWeka exception: " + e.getMessage() + "\n" + KernelEvaluation.makeOptionString(Kernel2));
        }
        KernelEvaluation eval = new KernelEvaluation();
        eval.setUserOptions(userOptions);
        Instances train = new Instances(reader);
        if (classIndex == -1) {
            train.setClassIndex(train.numAttributes() - 1);
        } else {
            train.setClassIndex(classIndex);
        }
        return eval.evaluate(Kernel2, train);
    }

    public static String evaluate(String kernelString, String[] options) throws Exception {
        Kernel kernel;
        try {
            kernel = (Kernel)Class.forName(kernelString).newInstance();
        }
        catch (Exception e) {
            throw new Exception("Can't find class with name " + kernelString + '.');
        }
        return KernelEvaluation.evaluate(kernel, options);
    }

    public String evaluate(Kernel kernel, Instances data) throws Exception {
        int i;
        int n;
        this.m_Result = new StringBuffer();
        long startTime = System.currentTimeMillis();
        kernel.getCapabilities().testWithFail(data);
        kernel.buildKernel(data);
        long endTime = System.currentTimeMillis();
        this.m_Result.append("\n=== Model ===\n\n");
        if (Utils.joinOptions(this.getUserOptions()).trim().length() != 0) {
            this.m_Result.append("Options: " + Utils.joinOptions(this.getUserOptions()) + "\n\n");
        }
        this.m_Result.append(kernel.toString() + "\n");
        this.m_Evaluations = new double[data.numInstances()][data.numInstances()];
        for (n = 0; n < data.numInstances(); ++n) {
            for (i = n; i < data.numInstances(); ++i) {
                this.m_Evaluations[n][i] = kernel.eval(n, i, data.instance(n));
            }
        }
        if (kernel instanceof CachedKernel) {
            for (n = 0; n < data.numInstances(); ++n) {
                for (i = n; i < data.numInstances(); ++i) {
                    this.m_Evaluations[n][i] = kernel.eval(n, i, data.instance(n));
                }
            }
        }
        this.m_NumEvals = kernel.numEvals();
        this.m_NumCacheHits = kernel.numCacheHits();
        this.m_Result.append("\n=== Evaluation ===\n\n");
        if (kernel instanceof CachedKernel) {
            this.m_Result.append("Cache size   : " + ((CachedKernel)kernel).getCacheSize() + "\n");
        }
        this.m_Result.append("# Evaluations: " + this.m_NumEvals + "\n");
        this.m_Result.append("# Cache hits : " + this.m_NumCacheHits + "\n");
        this.m_Result.append("Elapsed time : " + (double)(endTime - startTime) / 1000.0 + "s\n");
        return this.m_Result.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        KernelEvaluation cmp = (KernelEvaluation)obj;
        if (this.m_NumEvals != cmp.m_NumEvals) {
            return false;
        }
        if (this.m_NumCacheHits != cmp.m_NumCacheHits) {
            return false;
        }
        if (this.m_Evaluations.length != cmp.m_Evaluations.length) {
            return false;
        }
        for (int n = 0; n < this.m_Evaluations.length; ++n) {
            for (int i = 0; i < this.m_Evaluations[n].length; ++i) {
                if (Double.isNaN(this.m_Evaluations[n][i]) && Double.isNaN(cmp.m_Evaluations[n][i]) || this.m_Evaluations[n][i] == cmp.m_Evaluations[n][i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toSummaryString() {
        return this.toSummaryString("");
    }

    public String toSummaryString(String title) {
        StringBuffer result = new StringBuffer(title);
        if (title.length() != 0) {
            result.append("\n");
        }
        result.append(this.m_Result);
        return result.toString();
    }

    public String toString() {
        return this.toSummaryString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14516 $");
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("The first argument must be the class name of a kernel");
            }
            String kernel = args[0];
            args[0] = "";
            System.out.println(KernelEvaluation.evaluate(kernel, args));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

