/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.IterativeClassifier;
import weka.classifiers.RandomizableIteratedSingleClassifierEnhancer;
import weka.classifiers.Sourcable;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.DecisionStump;
import weka.core.Attribute;
import weka.core.BatchPredictor;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.UnassignedClassException;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class LogitBoost
extends RandomizableIteratedSingleClassifierEnhancer
implements Sourcable,
WeightedInstancesHandler,
TechnicalInformationHandler,
IterativeClassifier,
BatchPredictor {
    static final long serialVersionUID = -1105660358715833753L;
    protected ArrayList<Classifier[]> m_Classifiers;
    protected int m_NumClasses;
    protected int m_NumGenerated;
    protected int m_WeightThreshold = 100;
    protected static final double DEFAULT_Z_MAX = 3.0;
    protected Instances m_NumericClassData;
    protected Attribute m_ClassAttribute;
    protected boolean m_UseResampling;
    protected double m_Precision = -1.7976931348623157E308;
    protected double m_Shrinkage = 1.0;
    protected Random m_RandomInstance = null;
    protected double m_Offset = 0.0;
    protected Classifier m_ZeroR;
    protected double m_zMax = 3.0;
    protected double[][] m_trainYs;
    protected double[][] m_trainFs;
    protected double[][] m_probs;
    protected double m_logLikelihood;
    protected double m_sumOfWeights;
    protected Instances m_data;
    protected int m_numThreads = 1;
    protected int m_poolSize = 1;

    public String globalInfo() {
        return "Class for performing additive logistic regression. \nThis class performs classification using a regression scheme as the base learner, and can handle multi-class problems.  For more information, see\n\n" + this.getTechnicalInformation().toString() + "\n\nCan do efficient internal cross-validation to determine appropriate number of iterations.";
    }

    public LogitBoost() {
        this.m_Classifier = new DecisionStump();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.TECHREPORT);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J. Friedman and T. Hastie and R. Tibshirani");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Additive Logistic Regression: a Statistical View of Boosting");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Stanford University");
        result.setValue(TechnicalInformation.Field.PS, "http://www-stat.stanford.edu/~jhf/ftp/boost.ps");
        return result;
    }

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.DecisionStump";
    }

    protected Instances selectWeightQuantile(Instances data, double quantile) {
        int numInstances = data.numInstances();
        Instances trainData = new Instances(data, numInstances);
        double[] weights = new double[numInstances];
        double sumOfWeights = 0.0;
        for (int i = 0; i < numInstances; ++i) {
            weights[i] = data.instance(i).weight();
            sumOfWeights += weights[i];
        }
        double weightMassToSelect = sumOfWeights * quantile;
        int[] sortedIndices = Utils.sort(weights);
        sumOfWeights = 0.0;
        for (int i = numInstances - 1; i >= 0; --i) {
            Instance instance = (Instance)data.instance(sortedIndices[i]).copy();
            trainData.add(instance);
            if ((sumOfWeights += weights[sortedIndices[i]]) > weightMassToSelect && i > 0 && weights[sortedIndices[i]] != weights[sortedIndices[i - 1]]) break;
        }
        if (this.m_Debug) {
            System.err.println("Selected " + trainData.numInstances() + " out of " + numInstances);
        }
        return trainData;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>(5);
        newVector.addElement(new Option("\tUse resampling instead of reweighting for boosting.", "Q", 0, "-Q"));
        newVector.addElement(new Option("\tPercentage of weight mass to base training on.\n\t(default 100, reduce to around 90 speed up)", "P", 1, "-P <percent>"));
        newVector.addElement(new Option("\tThreshold on the improvement of the likelihood.\n\t(default -Double.MAX_VALUE)", "L", 1, "-L <num>"));
        newVector.addElement(new Option("\tShrinkage parameter.\n\t(default 1)", "H", 1, "-H <num>"));
        newVector.addElement(new Option("\tZ max threshold for responses.\n\t(default 3)", "Z", 1, "-Z <num>"));
        newVector.addElement(new Option("\t" + this.poolSizeTipText() + " (default 1)", "O", 1, "-O <int>"));
        newVector.addElement(new Option("\t" + this.numThreadsTipText() + "\n\t(default 1)", "E", 1, "-E <int>"));
        newVector.addAll(Collections.list(super.listOptions()));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String thresholdString = Utils.getOption('P', options);
        if (thresholdString.length() != 0) {
            this.setWeightThreshold(Integer.parseInt(thresholdString));
        } else {
            this.setWeightThreshold(100);
        }
        String precisionString = Utils.getOption('L', options);
        if (precisionString.length() != 0) {
            this.setLikelihoodThreshold(new Double(precisionString));
        } else {
            this.setLikelihoodThreshold(-1.7976931348623157E308);
        }
        String shrinkageString = Utils.getOption('H', options);
        if (shrinkageString.length() != 0) {
            this.setShrinkage(new Double(shrinkageString));
        } else {
            this.setShrinkage(1.0);
        }
        String zString = Utils.getOption('Z', options);
        if (zString.length() > 0) {
            this.setZMax(Double.parseDouble(zString));
        }
        this.setUseResampling(Utils.getFlag('Q', options));
        if (this.m_UseResampling && thresholdString.length() != 0) {
            throw new Exception("Weight pruning with resamplingnot allowed.");
        }
        String PoolSize = Utils.getOption('O', options);
        if (PoolSize.length() != 0) {
            this.setPoolSize(Integer.parseInt(PoolSize));
        } else {
            this.setPoolSize(1);
        }
        String NumThreads = Utils.getOption('E', options);
        if (NumThreads.length() != 0) {
            this.setNumThreads(Integer.parseInt(NumThreads));
        } else {
            this.setNumThreads(1);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        if (this.getUseResampling()) {
            options.add("-Q");
        } else {
            options.add("-P");
            options.add("" + this.getWeightThreshold());
        }
        options.add("-L");
        options.add("" + this.getLikelihoodThreshold());
        options.add("-H");
        options.add("" + this.getShrinkage());
        options.add("-Z");
        options.add("" + this.getZMax());
        options.add("-O");
        options.add("" + this.getPoolSize());
        options.add("-E");
        options.add("" + this.getNumThreads());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public String ZMaxTipText() {
        return "Z max threshold for responses";
    }

    public void setZMax(double zMax) {
        this.m_zMax = zMax;
    }

    public double getZMax() {
        return this.m_zMax;
    }

    public String shrinkageTipText() {
        return "Shrinkage parameter (use small value like 0.1 to reduce overfitting).";
    }

    public double getShrinkage() {
        return this.m_Shrinkage;
    }

    public void setShrinkage(double newShrinkage) {
        this.m_Shrinkage = newShrinkage;
    }

    public String likelihoodThresholdTipText() {
        return "Threshold on improvement in likelihood.";
    }

    public double getLikelihoodThreshold() {
        return this.m_Precision;
    }

    public void setLikelihoodThreshold(double newPrecision) {
        this.m_Precision = newPrecision;
    }

    public String useResamplingTipText() {
        return "Whether resampling is used instead of reweighting.";
    }

    public void setUseResampling(boolean r) {
        this.m_UseResampling = r;
    }

    public boolean getUseResampling() {
        return this.m_UseResampling;
    }

    public String weightThresholdTipText() {
        return "Weight threshold for weight pruning (reduce to 90 for speeding up learning process).";
    }

    public void setWeightThreshold(int threshold) {
        this.m_WeightThreshold = threshold;
    }

    public int getWeightThreshold() {
        return this.m_WeightThreshold;
    }

    public String numThreadsTipText() {
        return "The number of threads to use for batch prediction, which should be >= size of thread pool.";
    }

    public int getNumThreads() {
        return this.m_numThreads;
    }

    public void setNumThreads(int nT) {
        this.m_numThreads = nT;
    }

    public String poolSizeTipText() {
        return "The size of the thread pool, for example, the number of cores in the CPU.";
    }

    public int getPoolSize() {
        return this.m_poolSize;
    }

    public void setPoolSize(int nT) {
        this.m_poolSize = nT;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.initializeClassifier(data);
        while (this.next()) {
        }
        this.done();
    }

    @Override
    public void initializeClassifier(Instances data) throws Exception {
        this.m_RandomInstance = new Random(this.m_Seed);
        int classIndex = data.classIndex();
        if (this.m_Classifier == null) {
            throw new Exception("A base classifier has not been specified!");
        }
        if (!(this.m_Classifier instanceof WeightedInstancesHandler) && !this.m_UseResampling) {
            this.m_UseResampling = true;
        }
        this.getCapabilities().testWithFail(data);
        if (this.m_Debug) {
            System.err.println("Creating copy of the training data");
        }
        this.m_data = new Instances(data);
        this.m_data.deleteWithMissingClass();
        if (this.m_data.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(this.m_data);
            return;
        }
        this.m_ZeroR = null;
        this.m_NumClasses = this.m_data.numClasses();
        this.m_ClassAttribute = this.m_data.classAttribute();
        if (this.m_Debug) {
            System.err.println("Creating base classifiers");
        }
        this.m_Classifiers = new ArrayList();
        int numInstances = this.m_data.numInstances();
        this.m_trainFs = new double[numInstances][this.m_NumClasses];
        this.m_trainYs = new double[numInstances][this.m_NumClasses];
        for (int j = 0; j < this.m_NumClasses; ++j) {
            int i = 0;
            int k = 0;
            while (i < numInstances) {
                this.m_trainYs[i][j] = this.m_data.instance(k).classValue() == (double)j ? 1.0 - this.m_Offset : 0.0 + this.m_Offset / (double)this.m_NumClasses;
                ++i;
                ++k;
            }
        }
        this.m_data.setClassIndex(-1);
        this.m_data.deleteAttributeAt(classIndex);
        this.m_data.insertAttributeAt(new Attribute("'pseudo class'"), classIndex);
        this.m_data.setClassIndex(classIndex);
        this.m_NumericClassData = new Instances(this.m_data, 0);
        this.m_probs = this.initialProbs(numInstances);
        this.m_logLikelihood = this.logLikelihood(this.m_trainYs, this.m_probs);
        this.m_NumGenerated = 0;
        if (this.m_Debug) {
            System.err.println("Avg. log-likelihood: " + this.m_logLikelihood);
        }
        this.m_sumOfWeights = this.m_data.sumOfWeights();
    }

    @Override
    public boolean next() throws Exception {
        if (this.m_NumGenerated >= this.m_NumIterations) {
            return false;
        }
        if (this.m_ZeroR != null) {
            return false;
        }
        double previousLoglikelihood = this.m_logLikelihood;
        this.performIteration(this.m_trainYs, this.m_trainFs, this.m_probs, this.m_data, this.m_sumOfWeights);
        this.m_logLikelihood = this.logLikelihood(this.m_trainYs, this.m_probs);
        if (this.m_Debug) {
            System.err.println("Avg. log-likelihood: " + this.m_logLikelihood);
        }
        return !(Math.abs(previousLoglikelihood - this.m_logLikelihood) < this.m_Precision);
    }

    @Override
    public void done() {
        this.m_probs = null;
        this.m_trainFs = this.m_probs;
        this.m_trainYs = this.m_probs;
        this.m_data = null;
    }

    private double[][] initialProbs(int numInstances) {
        double[][] probs = new double[numInstances][this.m_NumClasses];
        for (int i = 0; i < numInstances; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                probs[i][j] = 1.0 / (double)this.m_NumClasses;
            }
        }
        return probs;
    }

    private double logLikelihood(double[][] trainYs, double[][] probs) {
        double logLikelihood = 0.0;
        for (int i = 0; i < trainYs.length; ++i) {
            for (int j = 0; j < this.m_NumClasses; ++j) {
                if (trainYs[i][j] != 1.0 - this.m_Offset) continue;
                logLikelihood -= Math.log(probs[i][j]);
            }
        }
        return logLikelihood / (double)trainYs.length;
    }

    private void performIteration(double[][] trainYs, double[][] trainFs, double[][] probs, Instances data, double origSumOfWeights) throws Exception {
        int i;
        if (this.m_Debug) {
            System.err.println("Training classifier " + (this.m_NumGenerated + 1));
        }
        Classifier[] classifiers = new Classifier[this.m_NumClasses];
        for (int j = 0; j < this.m_NumClasses; ++j) {
            if (this.m_Debug) {
                System.err.println("\t...for class " + (j + 1) + " (" + this.m_ClassAttribute.name() + "=" + this.m_ClassAttribute.value(j) + ")");
            }
            Instances boostData = new Instances(data);
            for (int i2 = 0; i2 < probs.length; ++i2) {
                double z;
                double p = probs[i2][j];
                double actual = trainYs[i2][j];
                if (actual == 1.0 - this.m_Offset) {
                    z = 1.0 / p;
                    if (z > this.m_zMax) {
                        z = this.m_zMax;
                    }
                } else {
                    z = -1.0 / (1.0 - p);
                    if (z < -this.m_zMax) {
                        z = -this.m_zMax;
                    }
                }
                double w = (actual - p) / z;
                Instance current = boostData.instance(i2);
                current.setValue(boostData.classIndex(), z);
                current.setWeight(current.weight() * w);
            }
            double sumOfWeights = boostData.sumOfWeights();
            double scalingFactor = origSumOfWeights / sumOfWeights;
            for (int i3 = 0; i3 < probs.length; ++i3) {
                Instance current = boostData.instance(i3);
                current.setWeight(current.weight() * scalingFactor);
            }
            Instances trainData = boostData;
            if (this.m_WeightThreshold < 100) {
                trainData = this.selectWeightQuantile(boostData, (double)this.m_WeightThreshold / 100.0);
            } else if (this.m_UseResampling) {
                double[] weights = new double[boostData.numInstances()];
                for (int kk = 0; kk < weights.length; ++kk) {
                    weights[kk] = boostData.instance(kk).weight();
                }
                trainData = boostData.resampleWithWeights(this.m_RandomInstance, weights);
            }
            classifiers[j] = AbstractClassifier.makeCopy(this.m_Classifier);
            classifiers[j].buildClassifier(trainData);
            if (this.m_NumClasses == 2) break;
        }
        this.m_Classifiers.add(classifiers);
        for (i = 0; i < trainFs.length; ++i) {
            int j;
            double[] pred = new double[this.m_NumClasses];
            double predSum = 0.0;
            for (j = 0; j < this.m_NumClasses; ++j) {
                double tempPred = this.m_Shrinkage * classifiers[j].classifyInstance(data.instance(i));
                if (Utils.isMissingValue(tempPred)) {
                    throw new UnassignedClassException("LogitBoost: base learner predicted missing value.");
                }
                pred[j] = tempPred;
                if (this.m_NumClasses == 2) {
                    pred[1] = -tempPred;
                    break;
                }
                predSum += pred[j];
            }
            predSum /= (double)this.m_NumClasses;
            for (j = 0; j < this.m_NumClasses; ++j) {
                double[] dArray = trainFs[i];
                int n = j;
                dArray[n] = dArray[n] + (pred[j] - predSum) * (double)(this.m_NumClasses - 1) / (double)this.m_NumClasses;
            }
        }
        ++this.m_NumGenerated;
        for (i = 0; i < trainYs.length; ++i) {
            probs[i] = this.probs(trainFs[i]);
        }
    }

    public Classifier[][] classifiers() {
        return (Classifier[][])this.m_Classifiers.toArray((T[])new Classifier[0][0]);
    }

    private double[] probs(double[] Fs) {
        double maxF = -1.7976931348623157E308;
        for (int i = 0; i < Fs.length; ++i) {
            if (!(Fs[i] > maxF)) continue;
            maxF = Fs[i];
        }
        double sum = 0.0;
        double[] probs = new double[Fs.length];
        for (int i = 0; i < Fs.length; ++i) {
            probs[i] = Math.exp(Fs[i] - maxF);
            sum += probs[i];
        }
        Utils.normalize(probs, sum);
        return probs;
    }

    @Override
    public boolean implementsMoreEfficientBatchPrediction() {
        return true;
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(inst);
        }
        double[] Fs = new double[this.m_NumClasses];
        double[] pred = new double[this.m_NumClasses];
        Instance instance = (Instance)inst.copy();
        instance.setDataset(this.m_NumericClassData);
        for (int i = 0; i < this.m_NumGenerated; ++i) {
            int j;
            double predSum = 0.0;
            for (j = 0; j < this.m_NumClasses; ++j) {
                double tempPred = this.m_Shrinkage * this.m_Classifiers.get(i)[j].classifyInstance(instance);
                if (Utils.isMissingValue(tempPred)) {
                    throw new UnassignedClassException("LogitBoost: base learner predicted missing value.");
                }
                pred[j] = tempPred;
                if (this.m_NumClasses == 2) {
                    pred[1] = -tempPred;
                    break;
                }
                predSum += pred[j];
            }
            predSum /= (double)this.m_NumClasses;
            for (j = 0; j < this.m_NumClasses; ++j) {
                int n = j;
                Fs[n] = Fs[n] + (pred[j] - predSum) * (double)(this.m_NumClasses - 1) / (double)this.m_NumClasses;
            }
        }
        return this.probs(Fs);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[][] distributionsForInstances(Instances insts) throws Exception {
        void var8_16;
        if (this.m_ZeroR != null) {
            double[][] preds = new double[insts.numInstances()][];
            for (int i = 0; i < preds.length; ++i) {
                preds[i] = this.m_ZeroR.distributionForInstance(insts.instance(i));
            }
            return preds;
        }
        final Instances numericClassInsts = new Instances(this.m_NumericClassData);
        for (int i = 0; i < insts.numInstances(); ++i) {
            numericClassInsts.add(insts.instance(i));
        }
        ExecutorService pool = Executors.newFixedThreadPool(this.m_poolSize);
        double[][] Fs = new double[insts.numInstances()][this.m_NumClasses];
        int chunksize = this.m_NumGenerated / this.m_numThreads;
        HashSet<Future<double[][]>> results = new HashSet<Future<double[][]>>();
        for (int j = 0; j < this.m_numThreads; ++j) {
            final int n = j * chunksize;
            final int hi = j < this.m_numThreads - 1 ? n + chunksize : this.m_NumGenerated;
            Future<double[][]> futureT = pool.submit(new Callable<double[][]>(){

                @Override
                public double[][] call() throws Exception {
                    double[][] localFs = new double[numericClassInsts.numInstances()][LogitBoost.this.m_NumClasses];
                    for (int k = 0; k < numericClassInsts.numInstances(); ++k) {
                        Instance instance = numericClassInsts.instance(k);
                        for (int i = n; i < hi; ++i) {
                            int j;
                            double predSum = 0.0;
                            double[] pred = new double[LogitBoost.this.m_NumClasses];
                            for (j = 0; j < LogitBoost.this.m_NumClasses; ++j) {
                                double tempPred = LogitBoost.this.m_Shrinkage * LogitBoost.this.m_Classifiers.get(i)[j].classifyInstance(instance);
                                if (Utils.isMissingValue(tempPred)) {
                                    throw new UnassignedClassException("LogitBoost: base learner predicted missing value.");
                                }
                                pred[j] = tempPred;
                                if (LogitBoost.this.m_NumClasses == 2) {
                                    pred[1] = -tempPred;
                                    break;
                                }
                                predSum += pred[j];
                            }
                            predSum /= (double)LogitBoost.this.m_NumClasses;
                            for (j = 0; j < LogitBoost.this.m_NumClasses; ++j) {
                                double[] dArray = localFs[k];
                                int n2 = j;
                                dArray[n2] = dArray[n2] + (pred[j] - predSum) * (double)(LogitBoost.this.m_NumClasses - 1) / (double)LogitBoost.this.m_NumClasses;
                            }
                        }
                    }
                    return localFs;
                }
            });
            results.add(futureT);
        }
        try {
            for (Future future : results) {
                double[][] f = (double[][])future.get();
                for (int j = 0; j < Fs.length; ++j) {
                    for (int i = 0; i < Fs[j].length; ++i) {
                        double[] dArray = Fs[j];
                        int n = i;
                        dArray[n] = dArray[n] + f[j][i];
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Predictions could not be generated.");
            e.printStackTrace();
        }
        pool.shutdown();
        double[][] preds = new double[insts.numInstances()][];
        boolean bl = false;
        while (var8_16 < preds.length) {
            preds[var8_16] = this.probs(Fs[var8_16]);
            ++var8_16;
        }
        return preds;
    }

    @Override
    public String toSource(String className) throws Exception {
        int j;
        int i;
        if (this.m_NumGenerated == 0) {
            throw new Exception("No model built yet");
        }
        if (!(this.m_Classifiers.get(0)[0] instanceof Sourcable)) {
            throw new Exception("Base learner " + this.m_Classifier.getClass().getName() + " is not Sourcable");
        }
        StringBuffer text = new StringBuffer("class ");
        text.append(className).append(" {\n\n");
        text.append("  private static double RtoP(double []R, int j) {\n    double Rcenter = 0;\n    for (int i = 0; i < R.length; i++) {\n      Rcenter += R[i];\n    }\n    Rcenter /= R.length;\n    double Rsum = 0;\n    for (int i = 0; i < R.length; i++) {\n      Rsum += Math.exp(R[i] - Rcenter);\n    }\n    return Math.exp(R[j]) / Rsum;\n  }\n\n");
        text.append("  public static double classify(Object[] i) {\n    double [] d = distribution(i);\n    double maxV = d[0];\n    int maxI = 0;\n    for (int j = 1; j < " + this.m_NumClasses + "; j++) {\n      if (d[j] > maxV) { maxV = d[j]; maxI = j; }\n    }\n    return (double) maxI;\n  }\n\n");
        text.append("  public static double [] distribution(Object [] i) {\n");
        text.append("    double [] Fs = new double [" + this.m_NumClasses + "];\n");
        text.append("    double [] Fi = new double [" + this.m_NumClasses + "];\n");
        text.append("    double Fsum;\n");
        for (i = 0; i < this.m_NumGenerated; ++i) {
            text.append("    Fsum = 0;\n");
            for (j = 0; j < this.m_NumClasses; ++j) {
                text.append("    Fi[" + j + "] = " + className + '_' + j + '_' + i + ".classify(i); Fsum += Fi[" + j + "];\n");
                if (this.m_NumClasses != 2) continue;
                text.append("    Fi[1] = -Fi[0];\n");
                break;
            }
            text.append("    Fsum /= " + this.m_NumClasses + ";\n");
            text.append("    for (int j = 0; j < " + this.m_NumClasses + "; j++) {");
            text.append(" Fs[j] += (Fi[j] - Fsum) * " + (this.m_NumClasses - 1) + " / " + this.m_NumClasses + "; }\n");
        }
        text.append("    double [] dist = new double [" + this.m_NumClasses + "];\n    for (int j = 0; j < " + this.m_NumClasses + "; j++) {\n      dist[j] = RtoP(Fs, j);\n    }\n    return dist;\n");
        text.append("  }\n}\n");
        for (i = 0; i < this.m_Classifiers.get(0).length; ++i) {
            for (j = 0; j < this.m_Classifiers.size(); ++j) {
                text.append(((Sourcable)((Object)this.m_Classifiers.get(j)[i])).toSource(className + '_' + i + '_' + j));
            }
            if (this.m_NumClasses == 2) break;
        }
        return text.toString();
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            buf.append(this.m_ZeroR.toString());
            return buf.toString();
        }
        StringBuffer text = new StringBuffer();
        if (this.m_NumGenerated == 0) {
            text.append("LogitBoost: No model built yet.");
        } else {
            text.append("LogitBoost: Base classifiers and their weights: \n");
            block0: for (int i = 0; i < this.m_NumGenerated; ++i) {
                text.append("\nIteration " + (i + 1));
                for (int j = 0; j < this.m_NumClasses; ++j) {
                    text.append("\n\tClass " + (j + 1) + " (" + this.m_ClassAttribute.name() + "=" + this.m_ClassAttribute.value(j) + ")\n\n" + this.m_Classifiers.get(i)[j].toString() + "\n");
                    if (this.m_NumClasses != 2) continue;
                    text.append("Two-class case: second classifier predicts additive inverse of first classifier and is not explicitly computed.\n\n");
                    continue block0;
                }
            }
            text.append("Number of performed iterations: " + this.m_NumGenerated + "\n");
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 13156 $");
    }

    public static void main(String[] argv) {
        LogitBoost.runClassifier(new LogitBoost(), argv);
    }
}

