/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Memory
implements RevisionHandler {
    protected static boolean m_Enabled = true;
    protected boolean m_UseGUI = false;
    protected static MemoryMXBean m_MemoryMXBean = ManagementFactory.getMemoryMXBean();
    protected MemoryUsage m_MemoryUsage = null;

    public Memory() {
        this(false);
    }

    public Memory(boolean useGUI) {
        this.m_UseGUI = useGUI;
    }

    public boolean isEnabled() {
        return m_Enabled;
    }

    public void setEnabled(boolean value) {
        m_Enabled = value;
    }

    public boolean getUseGUI() {
        return this.m_UseGUI;
    }

    public long getInitial() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        return this.m_MemoryUsage.getInit();
    }

    public long getCurrent() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        return this.m_MemoryUsage.getUsed();
    }

    public long getMax() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        return this.m_MemoryUsage.getMax();
    }

    public boolean isOutOfMemory() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        if (this.isEnabled()) {
            return this.m_MemoryUsage.getMax() - this.m_MemoryUsage.getUsed() < 0x3200000L;
        }
        return false;
    }

    public boolean memoryIsLow() {
        this.m_MemoryUsage = m_MemoryMXBean.getHeapMemoryUsage();
        if (this.isEnabled()) {
            long avail;
            long lowThreshold = (long)(0.2 * (double)this.m_MemoryUsage.getMax());
            if (lowThreshold < 0x6400000L) {
                lowThreshold = 0x6400000L;
            }
            return (avail = this.m_MemoryUsage.getMax() - this.m_MemoryUsage.getUsed()) < lowThreshold;
        }
        return false;
    }

    public static double toMegaByte(long bytes) {
        return (double)bytes / 1048576.0;
    }

    public void showOutOfMemory() {
        if (!this.isEnabled() || this.m_MemoryUsage == null) {
            return;
        }
        System.gc();
        String msg = "Not enough memory (less than 50MB left on heap). Please load a smaller dataset or use a larger heap size.\n- initial heap size:   " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getInit()), 1) + "MB\n" + "- current memory (heap) used:  " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getUsed()), 1) + "MB\n" + "- max. memory (heap) available: " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getMax()), 1) + "MB\n" + "\n" + "Note:\n" + "The Java heap size can be specified with the -Xmx option.\n" + "E.g., to use 128MB as heap size, the command line looks like this:\n" + "   java -Xmx128m -classpath ...\n" + "This does NOT work in the SimpleCLI, the above java command refers\n" + "to the one with which Weka is started. See the Weka FAQ on the web\n" + "for further info.";
        System.err.println(msg);
        if (this.getUseGUI()) {
            JOptionPane.showMessageDialog(null, msg, "OutOfMemory", 2);
        }
    }

    public boolean showMemoryIsLow() {
        if (!this.isEnabled() || this.m_MemoryUsage == null) {
            return true;
        }
        String msg = "Warning: memory is running low - available heap space is less than 20% of maximum or 100MB (whichever is greater)\n\n- initial heap size:   " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getInit()), 1) + "MB\n" + "- current memory (heap) used:  " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getUsed()), 1) + "MB\n" + "- max. memory (heap) available: " + Utils.doubleToString(Memory.toMegaByte(this.m_MemoryUsage.getMax()), 1) + "MB\n\n" + "Consider deleting some results before continuing.\nCheck the Weka FAQ " + "on the web for suggestions on how to save memory.\n" + "Note that Weka will shut down when less than 50MB remain." + "\nDo you wish to continue regardless?\n\n";
        System.err.println(msg);
        if (this.getUseGUI() && !Utils.getDontShowDialog("weka.core.Memory.LowMemoryWarning")) {
            JCheckBox dontShow = new JCheckBox("Do not show this message again");
            Object[] stuff = new Object[]{msg, dontShow};
            int result = JOptionPane.showConfirmDialog(null, stuff, "Memory", 0);
            if (dontShow.isSelected()) {
                try {
                    Utils.setDontShowDialog("weka.core.Memory.LowMemoryWarning");
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return result == 0;
        }
        return true;
    }

    public void stopThreads() {
        Thread[] thGroup = new Thread[Thread.activeCount()];
        Thread.enumerate(thGroup);
        for (int i = 0; i < thGroup.length; ++i) {
            Thread t = thGroup[i];
            if (t == null || t == Thread.currentThread()) continue;
            if (t.getName().startsWith("Thread")) {
                t.stop();
                continue;
            }
            if (!t.getName().startsWith("AWT-EventQueue")) continue;
            t.stop();
        }
        thGroup = null;
        System.gc();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9493 $");
    }

    public static void main(String[] args) {
        Memory mem = new Memory();
        System.out.println("Initial memory: " + Utils.doubleToString(Memory.toMegaByte(mem.getInitial()), 1) + "MB" + " (" + mem.getInitial() + ")");
        System.out.println("Max memory: " + Utils.doubleToString(Memory.toMegaByte(mem.getMax()), 1) + "MB" + " (" + mem.getMax() + ")");
    }
}

