/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.FileEnvironmentField;
import weka.gui.beans.Loader;

public class LoaderCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerCloseRequester,
EnvironmentHandler {
    private static final long serialVersionUID = 6990446313118930298L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Loader m_dsLoader;
    private PropertySheetPanel m_LoaderEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private Window m_parentWindow;
    private JDialog m_fileChooserFrame;
    private EnvironmentField m_dbaseURLText;
    private EnvironmentField m_userNameText;
    private EnvironmentField m_queryText;
    private EnvironmentField m_keyText;
    private JPasswordField m_passwordText;
    private JCheckBox m_relativeFilePath;
    private EnvironmentField m_fileText;
    private Environment m_env = Environment.getSystemWide();
    private FileEnvironmentField m_dbProps;
    private BeanCustomizer.ModifyListener m_modifyListener;
    private weka.core.converters.Loader m_backup = null;

    public LoaderCustomizer() {
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(0);
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    try {
                        File selectedFile = LoaderCustomizer.this.m_fileChooser.getSelectedFile();
                        LoaderCustomizer.this.m_fileText.setText(selectedFile.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (LoaderCustomizer.this.m_fileChooserFrame != null) {
                    LoaderCustomizer.this.m_fileChooserFrame.dispose();
                }
            }
        });
    }

    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_LoaderEditor, "Center");
        this.validate();
        this.repaint();
    }

    private void setUpDatabase() {
        this.removeAll();
        JPanel db = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        db.setLayout(gbLayout);
        JLabel urlLab = new JLabel("Database URL", 4);
        urlLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(urlLab, gbConstraints);
        db.add(urlLab);
        this.m_dbaseURLText = new EnvironmentField();
        this.m_dbaseURLText.setEnvironment(this.m_env);
        this.m_dbaseURLText.setText(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUrl());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 5.0;
        gbLayout.setConstraints(this.m_dbaseURLText, gbConstraints);
        db.add(this.m_dbaseURLText);
        JLabel userLab = new JLabel("Username", 4);
        userLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(userLab, gbConstraints);
        db.add(userLab);
        this.m_userNameText = new EnvironmentField();
        this.m_userNameText.setEnvironment(this.m_env);
        this.m_userNameText.setText(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUser());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_userNameText, gbConstraints);
        db.add(this.m_userNameText);
        JLabel passwordLab = new JLabel("Password ", 4);
        passwordLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(passwordLab, gbConstraints);
        db.add(passwordLab);
        this.m_passwordText = new JPasswordField();
        JPanel passwordHolder = new JPanel();
        passwordHolder.setLayout(new BorderLayout());
        passwordHolder.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        passwordHolder.add((Component)this.m_passwordText, "Center");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(passwordHolder, gbConstraints);
        db.add(passwordHolder);
        JLabel queryLab = new JLabel("Query", 4);
        queryLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(queryLab, gbConstraints);
        db.add(queryLab);
        this.m_queryText = new EnvironmentField();
        this.m_queryText.setEnvironment(this.m_env);
        this.m_queryText.setText(((DatabaseLoader)this.m_dsLoader.getLoader()).getQuery());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_queryText, gbConstraints);
        db.add(this.m_queryText);
        JLabel keyLab = new JLabel("Key columns", 4);
        keyLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(keyLab, gbConstraints);
        db.add(keyLab);
        this.m_keyText = new EnvironmentField();
        this.m_keyText.setEnvironment(this.m_env);
        this.m_keyText.setText(((DatabaseLoader)this.m_dsLoader.getLoader()).getKeys());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_keyText, gbConstraints);
        db.add(this.m_keyText);
        JLabel propsLab = new JLabel("DB config props", 4);
        propsLab.setToolTipText("The custom properties that the user can use to override the default ones.");
        propsLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 5;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(propsLab, gbConstraints);
        db.add(propsLab);
        this.m_dbProps = new FileEnvironmentField();
        this.m_dbProps.setEnvironment(this.m_env);
        this.m_dbProps.resetFileFilters();
        this.m_dbProps.addFileFilter(new ExtensionFileFilter(".props", "DatabaseUtils property file (*.props)"));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 5;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_dbProps, gbConstraints);
        db.add(this.m_dbProps);
        File toSet = ((DatabaseLoader)this.m_dsLoader.getLoader()).getCustomPropsFile();
        if (toSet != null) {
            this.m_dbProps.setText(toSet.getPath());
        }
        JButton loadPropsBut = new JButton("Load");
        loadPropsBut.setToolTipText("Load config");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 5;
        gbConstraints.gridx = 2;
        gbLayout.setConstraints(loadPropsBut, gbConstraints);
        db.add(loadPropsBut);
        loadPropsBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LoaderCustomizer.this.m_dbProps.getText() != null && LoaderCustomizer.this.m_dbProps.getText().length() > 0) {
                    String propsS = LoaderCustomizer.this.m_dbProps.getText();
                    try {
                        propsS = LoaderCustomizer.this.m_env.substitute(propsS);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    File propsFile = new File(propsS);
                    if (propsFile.exists()) {
                        ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).setCustomPropsFile(propsFile);
                        ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).resetOptions();
                        LoaderCustomizer.this.m_dbaseURLText.setText(((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).getUrl());
                    }
                }
            }
        });
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        buttonsP.add(ok);
        JButton cancel = new JButton("Cancel");
        buttonsP.add(cancel);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LoaderCustomizer.this.resetAndUpdateDatabaseLoaderIfChanged()) {
                    try {
                        LoaderCustomizer.this.m_dsLoader.setDB(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (LoaderCustomizer.this.m_parentWindow != null) {
                    LoaderCustomizer.this.m_parentWindow.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LoaderCustomizer.this.m_backup != null) {
                    LoaderCustomizer.this.m_dsLoader.setLoader(LoaderCustomizer.this.m_backup);
                }
                if (LoaderCustomizer.this.m_parentWindow != null) {
                    LoaderCustomizer.this.m_parentWindow.dispose();
                }
            }
        });
        JPanel holderP = new JPanel();
        holderP.setLayout(new BorderLayout());
        holderP.add((Component)db, "North");
        holderP.add((Component)buttonsP, "South");
        JPanel about = this.m_LoaderEditor.getAboutPanel();
        if (about != null) {
            this.add((Component)about, "North");
        }
        this.add((Component)holderP, "South");
    }

    private boolean resetAndUpdateDatabaseLoaderIfChanged() {
        boolean update;
        DatabaseLoader dbl = (DatabaseLoader)this.m_dsLoader.getLoader();
        String url = dbl.getUrl();
        String user = dbl.getUser();
        String password = dbl.getPassword();
        String query = dbl.getQuery();
        String keys = dbl.getKeys();
        File propsFile = dbl.getCustomPropsFile();
        boolean bl = update = !url.equals(this.m_dbaseURLText.getText()) || !user.equals(this.m_userNameText.getText()) || !password.equals(this.m_passwordText.getText()) || !query.equalsIgnoreCase(this.m_queryText.getText()) || !keys.equals(this.m_keyText.getText());
        if (propsFile != null && this.m_dbProps.getText().length() > 0) {
            update = update || !propsFile.toString().equals(this.m_dbProps.getText());
        } else {
            boolean bl2 = update = update || this.m_dbProps.getText().length() > 0;
        }
        if (update) {
            dbl.resetStructure();
            dbl.setUrl(this.m_dbaseURLText.getText());
            dbl.setUser(this.m_userNameText.getText());
            dbl.setPassword(new String(this.m_passwordText.getPassword()));
            dbl.setQuery(this.m_queryText.getText());
            dbl.setKeys(this.m_keyText.getText());
            if (this.m_dbProps.getText() != null && this.m_dbProps.getText().length() > 0) {
                dbl.setCustomPropsFile(new File(this.m_dbProps.getText()));
            }
        }
        return update;
    }

    public void setUpFile() {
        File tmp2;
        this.removeAll();
        boolean currentFileIsDir = false;
        File tmp = ((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).retrieveFile();
        String tmpString = tmp.toString();
        if (Environment.containsEnvVariables(tmpString)) {
            try {
                tmpString = this.m_env.substitute(tmpString);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((tmp2 = new File(new File(tmpString).getAbsolutePath())).isDirectory()) {
            this.m_fileChooser.setCurrentDirectory(tmp2);
            currentFileIsDir = true;
        } else {
            this.m_fileChooser.setSelectedFile(tmp2);
        }
        FileSourcedConverter loader = (FileSourcedConverter)((Object)this.m_dsLoader.getLoader());
        String[] ext = loader.getFileExtensions();
        ExtensionFileFilter firstFilter = null;
        for (int i = 0; i < ext.length; ++i) {
            ExtensionFileFilter ff = new ExtensionFileFilter(ext[i], loader.getFileDescription() + " (*" + ext[i] + ")");
            if (i == 0) {
                firstFilter = ff;
            }
            this.m_fileChooser.addChoosableFileFilter(ff);
        }
        if (firstFilter != null) {
            this.m_fileChooser.setFileFilter(firstFilter);
        }
        JPanel about = this.m_LoaderEditor.getAboutPanel();
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        if (about != null) {
            northPanel.add((Component)about, "North");
        }
        this.add((Component)northPanel, "North");
        final EnvironmentField ef = new EnvironmentField();
        JPanel efHolder = new JPanel();
        efHolder.setLayout(new BorderLayout());
        ef.setEnvironment(this.m_env);
        this.m_fileText = ef;
        if (!currentFileIsDir) {
            ef.setText(tmp.toString());
        }
        efHolder.add((Component)ef, "Center");
        JButton browseBut = new JButton("Browse...");
        browseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JDialog jf = new JDialog((JDialog)LoaderCustomizer.this.getTopLevelAncestor(), "Choose file", true);
                    jf.setLayout(new BorderLayout());
                    jf.getContentPane().add((Component)LoaderCustomizer.this.m_fileChooser, "Center");
                    LoaderCustomizer.this.m_fileChooserFrame = jf;
                    jf.pack();
                    jf.setVisible(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel bP = new JPanel();
        bP.setLayout(new BorderLayout());
        bP.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        bP.add((Component)browseBut, "Center");
        efHolder.add((Component)bP, "East");
        JPanel alignedP = new JPanel();
        alignedP.setBorder(BorderFactory.createTitledBorder("File"));
        alignedP.setLayout(new BorderLayout());
        JLabel efLab = new JLabel("Filename", 4);
        efLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        alignedP.add((Component)efLab, "West");
        alignedP.add((Component)efHolder, "Center");
        northPanel.add((Component)alignedP, "South");
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new FlowLayout());
        JButton OKBut = new JButton("OK");
        OKBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ((FileSourcedConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setFile(new File(ef.getText()));
                    LoaderCustomizer.this.m_dsLoader.newFileSelected();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (LoaderCustomizer.this.m_modifyListener != null) {
                    LoaderCustomizer.this.m_modifyListener.setModifiedStatus(LoaderCustomizer.this, true);
                }
                LoaderCustomizer.this.m_parentWindow.dispose();
            }
        });
        JButton CancelBut = new JButton("Cancel");
        CancelBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LoaderCustomizer.this.m_modifyListener != null) {
                    LoaderCustomizer.this.m_modifyListener.setModifiedStatus(LoaderCustomizer.this, false);
                }
                if (LoaderCustomizer.this.m_backup != null) {
                    LoaderCustomizer.this.m_dsLoader.setLoader(LoaderCustomizer.this.m_backup);
                }
                LoaderCustomizer.this.m_parentWindow.dispose();
            }
        });
        butHolder.add(OKBut);
        butHolder.add(CancelBut);
        JPanel optionsHolder = new JPanel();
        optionsHolder.setLayout(new BorderLayout());
        optionsHolder.setBorder(BorderFactory.createTitledBorder("Other options"));
        optionsHolder.add((Component)this.m_LoaderEditor, "South");
        JScrollPane scroller = new JScrollPane(optionsHolder);
        this.add((Component)scroller, "Center");
        this.add((Component)butHolder, "South");
    }

    public void setObject(Object object) {
        this.m_dsLoader = (Loader)object;
        try {
            this.m_backup = (weka.core.converters.Loader)GenericObjectEditor.makeCopy(this.m_dsLoader.getLoader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_LoaderEditor.setTarget(this.m_dsLoader.getLoader());
        this.m_LoaderEditor.setEnvironment(this.m_env);
        if (this.m_dsLoader.getLoader() instanceof FileSourcedConverter) {
            this.setUpFile();
        } else if (this.m_dsLoader.getLoader() instanceof DatabaseConverter) {
            this.setUpDatabase();
        } else {
            this.setUpOther();
        }
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

