/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.experiment.Experiment;
import weka.gui.experiment.AbstractSetupPanel;
import weka.gui.experiment.ExperimenterDefaults;
import weka.gui.experiment.SetupPanel;
import weka.gui.experiment.SimpleSetupPanel;

public class SetupModePanel
extends JPanel {
    private static final long serialVersionUID = -3758035565520727822L;
    protected AbstractSetupPanel[] m_Panels = AbstractSetupPanel.getPanels();
    protected JComboBox m_ComboBoxPanels;
    protected AbstractSetupPanel m_defaultPanel = null;
    protected AbstractSetupPanel m_advancedPanel = null;
    protected AbstractSetupPanel m_CurrentPanel;

    public SetupModePanel() {
        if (this.m_Panels.length == 0) {
            System.err.println("No experimenter setup panels discovered? Using fallback (simple, advanced).");
            this.m_Panels = new AbstractSetupPanel[]{new SetupPanel(), new SimpleSetupPanel()};
        }
        for (AbstractSetupPanel panel : this.m_Panels) {
            if (panel.getClass().getName().equals(ExperimenterDefaults.getSetupPanel())) {
                this.m_defaultPanel = panel;
            }
            if (panel instanceof SetupPanel) {
                this.m_advancedPanel = panel;
            }
            panel.setModePanel(this);
        }
        if (this.m_defaultPanel == null) {
            for (AbstractSetupPanel panel : this.m_Panels) {
                if (!(panel instanceof SimpleSetupPanel)) continue;
                this.m_defaultPanel = panel;
            }
        }
        this.m_CurrentPanel = this.m_defaultPanel;
        this.m_ComboBoxPanels = new JComboBox<AbstractSetupPanel>(this.m_Panels);
        this.m_ComboBoxPanels.setSelectedItem(this.m_defaultPanel);
        this.m_ComboBoxPanels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SetupModePanel.this.m_ComboBoxPanels.getSelectedIndex() == -1) {
                    return;
                }
                AbstractSetupPanel panel = (AbstractSetupPanel)SetupModePanel.this.m_ComboBoxPanels.getSelectedItem();
                SetupModePanel.this.switchTo(panel, null);
            }
        });
        JPanel switchPanel = new JPanel();
        switchPanel.setLayout(new FlowLayout(0));
        switchPanel.add(new JLabel("Experiment Configuration Mode"));
        switchPanel.add(this.m_ComboBoxPanels);
        this.setLayout(new BorderLayout());
        this.add((Component)switchPanel, "North");
        this.add((Component)this.m_defaultPanel, "Center");
    }

    public void switchToAdvanced(Experiment exp) {
        this.switchTo(this.m_advancedPanel, exp);
    }

    public void switchTo(AbstractSetupPanel panel, Experiment exp) {
        if (exp == null) {
            exp = this.m_CurrentPanel.getExperiment();
        }
        this.remove(this.m_CurrentPanel);
        this.m_CurrentPanel.cleanUpAfterSwitch();
        if (exp != null) {
            panel.setExperiment(exp);
        }
        this.add((Component)panel, "Center");
        this.validate();
        this.repaint();
        this.m_CurrentPanel = panel;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        for (AbstractSetupPanel panel : this.m_Panels) {
            panel.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        for (AbstractSetupPanel panel : this.m_Panels) {
            panel.removePropertyChangeListener(l);
        }
    }

    public Experiment getExperiment() {
        return this.m_CurrentPanel.getExperiment();
    }
}

