/*
 * Decompiled with CFR 0.152.
 */
package weka.core.metastore;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import weka.core.WekaPackageManager;
import weka.core.metastore.MetaStore;
import weka.core.xml.XMLBasicSerialization;

public class XMLFileBasedMetaStore
implements MetaStore {
    public static final String DEFAULT_STORE_LOCATION = WekaPackageManager.WEKA_HOME.toString() + File.separator + "wekaMetaStore";
    protected File m_storeHome = new File(DEFAULT_STORE_LOCATION);
    protected boolean m_storeDirOK;
    protected Map<String, Map<String, File>> m_stores = new LinkedHashMap<String, Map<String, File>>();

    protected synchronized void establishStoreHome() throws IOException {
        File[] contents;
        if (this.m_storeDirOK) {
            return;
        }
        if (!this.m_storeHome.exists() && !this.m_storeHome.mkdir()) {
            throw new IOException("Unable to create the metastore directory: " + this.m_storeHome.toString());
        }
        if (!this.m_storeHome.isDirectory()) {
            throw new IOException("The metastore (" + this.m_storeHome + ") seems to exist, but it isn't a directory!");
        }
        this.m_storeDirOK = true;
        this.lockStore();
        for (File f : contents = this.m_storeHome.listFiles()) {
            File[] storeEntries;
            if (!f.isDirectory()) continue;
            LinkedHashMap<String, File> store = new LinkedHashMap<String, File>();
            this.m_stores.put(f.getName(), store);
            for (File se : storeEntries = f.listFiles()) {
                store.put(se.getName(), se);
            }
        }
        this.unlockStore();
    }

    @Override
    public Set<String> listMetaStores() throws IOException {
        return this.m_stores.keySet();
    }

    @Override
    public Set<String> listMetaStoreEntries(String storeName) throws IOException {
        this.establishStoreHome();
        HashSet<String> results = new HashSet<String>();
        Map<String, File> store = this.m_stores.get(storeName);
        if (store != null) {
            results.addAll(store.keySet());
        }
        return results;
    }

    @Override
    public synchronized Set<String> listMetaStoreEntries(String storeName, String prefix) throws IOException {
        this.establishStoreHome();
        HashSet<String> matches = new HashSet<String>();
        Map<String, File> store = this.m_stores.get(storeName);
        if (store != null) {
            for (Map.Entry<String, File> e : store.entrySet()) {
                if (!e.getKey().startsWith(prefix)) continue;
                matches.add(e.getKey());
            }
        }
        return matches;
    }

    @Override
    public Object getEntry(String storeName, String name, Class<?> clazz) throws IOException {
        this.establishStoreHome();
        Map<String, File> store = this.m_stores.get(storeName);
        if (store != null && store.containsKey(name)) {
            File toLoad = store.get(name);
            try {
                this.lockStore();
                XMLBasicSerialization deserializer = new XMLBasicSerialization();
                Object loaded = deserializer.read(toLoad);
                if (loaded.getClass().equals(clazz)) {
                    throw new IOException("Deserialized entry (" + loaded.getClass().getName() + ") was not " + "the expected class: " + clazz.getName());
                }
                Object object = loaded;
                return object;
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            finally {
                this.unlockStore();
            }
        }
        return null;
    }

    @Override
    public void createStore(String storeName) throws IOException {
        File store = new File(this.m_storeHome, storeName);
        if (store.exists()) {
            throw new IOException("Meta store '" + storeName + "' already exists!");
        }
        this.lockStore();
        try {
            if (!store.mkdir()) {
                throw new IOException("Unable to create meta store '" + storeName + "'");
            }
        }
        finally {
            this.unlockStore();
        }
    }

    @Override
    public synchronized void storeEntry(String storeName, String name, Object toStore) throws IOException {
        this.establishStoreHome();
        Map<String, File> store = this.m_stores.get(storeName);
        if (store == null) {
            this.createStore(storeName);
            store = new LinkedHashMap<String, File>();
            this.m_stores.put(storeName, store);
        }
        File loc = new File(this.m_storeHome.toString() + File.separator + storeName, name);
        store.put(name, loc);
        try {
            this.lockStore();
            XMLBasicSerialization serializer = new XMLBasicSerialization();
            serializer.write(loc, toStore);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            this.unlockStore();
        }
    }

    protected void lockStore() throws IOException {
        int totalWaitTime = 0;
        do {
            File lock;
            if ((lock = new File(this.m_storeHome, ".lock")).createNewFile()) {
                return;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        } while ((totalWaitTime += 200) <= 5000);
        throw new IOException("Unable to lock store within 5 seconds");
    }

    protected void unlockStore() {
        File lock = new File(this.m_storeHome, ".lock");
        lock.delete();
    }
}

