/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.experiment.SplitEvaluator;

public class RegressionSplitEvaluator
implements SplitEvaluator,
OptionHandler,
AdditionalMeasureProducer,
RevisionHandler {
    static final long serialVersionUID = -328181640503349202L;
    protected Classifier m_Template = new ZeroR();
    protected Classifier m_Classifier;
    protected String[] m_AdditionalMeasures = null;
    protected boolean[] m_doesProduce = null;
    protected String m_result = null;
    protected String m_ClassifierOptions = "";
    protected String m_ClassifierVersion = "";
    private static final int KEY_SIZE = 3;
    private static final int RESULT_SIZE = 21;

    public RegressionSplitEvaluator() {
        this.updateOptions();
    }

    public String globalInfo() {
        return "A SplitEvaluator that produces results for a classification scheme on a numeric class attribute.";
    }

    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(1);
        newVector.addElement(new Option("\tThe full class name of the classifier.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W <class name>"));
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            newVector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Template.getClass().getName() + ":"));
            Enumeration enu = this.m_Template.listOptions();
            while (enu.hasMoreElements()) {
                newVector.addElement((Option)enu.nextElement());
            }
        }
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String cName = Utils.getOption('W', options);
        if (cName.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(cName, null));
        if (this.getClassifier() instanceof OptionHandler) {
            this.getClassifier().setOptions(Utils.partitionOptions(options));
            this.updateOptions();
        }
    }

    public String[] getOptions() {
        String[] classifierOptions = new String[]{};
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            classifierOptions = this.m_Template.getOptions();
        }
        String[] options = new String[classifierOptions.length + 3];
        int current = 0;
        if (this.getClassifier() != null) {
            options[current++] = "-W";
            options[current++] = this.getClassifier().getClass().getName();
        }
        options[current++] = "--";
        System.arraycopy(classifierOptions, 0, options, current, classifierOptions.length);
        current += classifierOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public void setAdditionalMeasures(String[] additionalMeasures) {
        this.m_AdditionalMeasures = additionalMeasures;
        if (this.m_AdditionalMeasures != null && this.m_AdditionalMeasures.length > 0) {
            this.m_doesProduce = new boolean[this.m_AdditionalMeasures.length];
            if (this.m_Template instanceof AdditionalMeasureProducer) {
                Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
                while (en.hasMoreElements()) {
                    String mname = (String)en.nextElement();
                    for (int j = 0; j < this.m_AdditionalMeasures.length; ++j) {
                        if (mname.compareToIgnoreCase(this.m_AdditionalMeasures[j]) != 0) continue;
                        this.m_doesProduce[j] = true;
                    }
                }
            }
        } else {
            this.m_doesProduce = null;
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = (String)en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            if (this.m_Classifier == null) {
                throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return result for measure, classifier has not been built yet.");
            }
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return value for : " + additionalMeasureName + ". " + this.m_Template.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    public Object[] getKeyTypes() {
        Object[] keyTypes = new Object[]{"", "", ""};
        return keyTypes;
    }

    public String[] getKeyNames() {
        String[] keyNames = new String[]{"Scheme", "Scheme_options", "Scheme_version_ID"};
        return keyNames;
    }

    public Object[] getKey() {
        Object[] key = new Object[]{this.m_Template.getClass().getName(), this.m_ClassifierOptions, this.m_ClassifierVersion};
        return key;
    }

    public Object[] getResultTypes() {
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        Object[] resultTypes = new Object[21 + addm];
        Double doub = new Double(0.0);
        int current = 0;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = doub;
        resultTypes[current++] = "";
        for (int i = 0; i < addm; ++i) {
            resultTypes[current++] = doub;
        }
        if (current != 21 + addm) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return resultTypes;
    }

    public String[] getResultNames() {
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        String[] resultNames = new String[21 + addm];
        int current = 0;
        resultNames[current++] = "Number_of_training_instances";
        resultNames[current++] = "Number_of_testing_instances";
        resultNames[current++] = "Mean_absolute_error";
        resultNames[current++] = "Root_mean_squared_error";
        resultNames[current++] = "Relative_absolute_error";
        resultNames[current++] = "Root_relative_squared_error";
        resultNames[current++] = "Correlation_coefficient";
        resultNames[current++] = "SF_prior_entropy";
        resultNames[current++] = "SF_scheme_entropy";
        resultNames[current++] = "SF_entropy_gain";
        resultNames[current++] = "SF_mean_prior_entropy";
        resultNames[current++] = "SF_mean_scheme_entropy";
        resultNames[current++] = "SF_mean_entropy_gain";
        resultNames[current++] = "Elapsed_Time_training";
        resultNames[current++] = "Elapsed_Time_testing";
        resultNames[current++] = "UserCPU_Time_training";
        resultNames[current++] = "UserCPU_Time_testing";
        resultNames[current++] = "Serialized_Model_Size";
        resultNames[current++] = "Serialized_Train_Set_Size";
        resultNames[current++] = "Serialized_Test_Set_Size";
        resultNames[current++] = "Summary";
        for (int i = 0; i < addm; ++i) {
            resultNames[current++] = this.m_AdditionalMeasures[i];
        }
        if (current != 21 + addm) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return resultNames;
    }

    public Object[] getResult(Instances train, Instances test) throws Exception {
        if (train.classAttribute().type() != 0) {
            throw new Exception("Class attribute is not numeric!");
        }
        if (this.m_Template == null) {
            throw new Exception("No classifier has been specified");
        }
        ThreadMXBean thMonitor = ManagementFactory.getThreadMXBean();
        boolean canMeasureCPUTime = thMonitor.isThreadCpuTimeSupported();
        if (!thMonitor.isThreadCpuTimeEnabled()) {
            thMonitor.setThreadCpuTimeEnabled(true);
        }
        int addm = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        Object[] result = new Object[21 + addm];
        long thID = Thread.currentThread().getId();
        long CPUStartTime = -1L;
        long trainCPUTimeElapsed = -1L;
        long testCPUTimeElapsed = -1L;
        Evaluation eval = new Evaluation(train);
        this.m_Classifier = Classifier.makeCopy(this.m_Template);
        long trainTimeStart = System.currentTimeMillis();
        if (canMeasureCPUTime) {
            CPUStartTime = thMonitor.getThreadUserTime(thID);
        }
        this.m_Classifier.buildClassifier(train);
        if (canMeasureCPUTime) {
            trainCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
        }
        long trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
        long testTimeStart = System.currentTimeMillis();
        if (canMeasureCPUTime) {
            CPUStartTime = thMonitor.getThreadUserTime(thID);
        }
        eval.evaluateModel(this.m_Classifier, test, new Object[0]);
        if (canMeasureCPUTime) {
            testCPUTimeElapsed = thMonitor.getThreadUserTime(thID) - CPUStartTime;
        }
        long testTimeElapsed = System.currentTimeMillis() - testTimeStart;
        thMonitor = null;
        this.m_result = eval.toSummaryString();
        int current = 0;
        result[current++] = new Double(train.numInstances());
        result[current++] = new Double(eval.numInstances());
        result[current++] = new Double(eval.meanAbsoluteError());
        result[current++] = new Double(eval.rootMeanSquaredError());
        result[current++] = new Double(eval.relativeAbsoluteError());
        result[current++] = new Double(eval.rootRelativeSquaredError());
        result[current++] = new Double(eval.correlationCoefficient());
        result[current++] = new Double(eval.SFPriorEntropy());
        result[current++] = new Double(eval.SFSchemeEntropy());
        result[current++] = new Double(eval.SFEntropyGain());
        result[current++] = new Double(eval.SFMeanPriorEntropy());
        result[current++] = new Double(eval.SFMeanSchemeEntropy());
        result[current++] = new Double(eval.SFMeanEntropyGain());
        result[current++] = new Double((double)trainTimeElapsed / 1000.0);
        result[current++] = new Double((double)testTimeElapsed / 1000.0);
        if (canMeasureCPUTime) {
            result[current++] = new Double((double)trainCPUTimeElapsed / 1000000.0 / 1000.0);
            result[current++] = new Double((double)testCPUTimeElapsed / 1000000.0 / 1000.0);
        } else {
            result[current++] = new Double(Instance.missingValue());
            result[current++] = new Double(Instance.missingValue());
        }
        ByteArrayOutputStream bastream = new ByteArrayOutputStream();
        ObjectOutputStream oostream = new ObjectOutputStream(bastream);
        oostream.writeObject(this.m_Classifier);
        result[current++] = new Double(bastream.size());
        bastream = new ByteArrayOutputStream();
        oostream = new ObjectOutputStream(bastream);
        oostream.writeObject(train);
        result[current++] = new Double(bastream.size());
        bastream = new ByteArrayOutputStream();
        oostream = new ObjectOutputStream(bastream);
        oostream.writeObject(test);
        result[current++] = new Double(bastream.size());
        result[current++] = this.m_Classifier instanceof Summarizable ? ((Summarizable)((Object)this.m_Classifier)).toSummaryString() : null;
        for (int i = 0; i < addm; ++i) {
            if (this.m_doesProduce[i]) {
                try {
                    double dv = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                    if (!Instance.isMissingValue(dv)) {
                        Double value = new Double(dv);
                        result[current++] = value;
                        continue;
                    }
                    result[current++] = null;
                }
                catch (Exception ex) {
                    System.err.println(ex);
                }
                continue;
            }
            result[current++] = null;
        }
        if (current != 21 + addm) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        return result;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public Classifier getClassifier() {
        return this.m_Template;
    }

    public void setClassifier(Classifier newClassifier) {
        this.m_Template = newClassifier;
        this.updateOptions();
        System.err.println("RegressionSplitEvaluator: In set classifier");
    }

    protected void updateOptions() {
        this.m_ClassifierOptions = this.m_Template instanceof OptionHandler ? Utils.joinOptions(this.m_Template.getOptions()) : "";
        if (this.m_Template instanceof Serializable) {
            ObjectStreamClass obs = ObjectStreamClass.lookup(this.m_Template.getClass());
            this.m_ClassifierVersion = "" + obs.getSerialVersionUID();
        } else {
            this.m_ClassifierVersion = "";
        }
    }

    public void setClassifierName(String newClassifierName) throws Exception {
        try {
            this.setClassifier((Classifier)Class.forName(newClassifierName).newInstance());
        }
        catch (Exception ex) {
            throw new Exception("Can't find Classifier with class name: " + newClassifierName);
        }
    }

    public String getRawResultOutput() {
        StringBuffer result = new StringBuffer();
        if (this.m_Classifier == null) {
            return "<null> classifier";
        }
        result.append(this.toString());
        result.append("Classifier model: \n" + this.m_Classifier.toString() + '\n');
        if (this.m_result != null) {
            result.append(this.m_result);
            if (this.m_doesProduce != null) {
                for (int i = 0; i < this.m_doesProduce.length; ++i) {
                    if (!this.m_doesProduce[i]) continue;
                    try {
                        double dv = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                        if (!Instance.isMissingValue(dv)) {
                            Double value = new Double(dv);
                            result.append(this.m_AdditionalMeasures[i] + " : " + value + '\n');
                            continue;
                        }
                        result.append(this.m_AdditionalMeasures[i] + " : " + '?' + '\n');
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
            }
        }
        return result.toString();
    }

    public String toString() {
        String result = "RegressionSplitEvaluator: ";
        if (this.m_Template == null) {
            return result + "<null> classifier";
        }
        return result + this.m_Template.getClass().getName() + " " + this.m_ClassifierOptions + "(version " + this.m_ClassifierVersion + ")";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.25 $");
    }
}

