/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.functions.SMOreg;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.SMOset;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RegOptimizer
implements OptionHandler,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -2198266997254461814L;
    public double[] m_alpha;
    public double[] m_alphaStar;
    protected double m_b;
    protected double m_epsilon = 0.001;
    protected double m_C = 1.0;
    protected double[] m_target;
    protected Instances m_data;
    protected Kernel m_kernel;
    protected int m_classIndex = -1;
    protected int m_nInstances = -1;
    protected Random m_random = new Random(this.m_nSeed);
    protected int m_nSeed = 1;
    protected SMOset m_supportVectors;
    protected int m_nEvals = 0;
    protected int m_nCacheHits = -1;
    protected double[] m_weights;
    protected double[] m_sparseWeights;
    protected int[] m_sparseIndices;
    protected boolean m_bModelBuilt = false;
    protected SMOreg m_SVM = null;

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe epsilon parameter in epsilon-insensitive loss function.\n\t(default 1.0e-3)", "L", 1, "-L <double>"));
        vector.addElement(new Option("\tThe random number seed.\n\t(default 1)", "W", 1, "-W <double>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('L', stringArray);
        if (string.length() != 0) {
            this.setEpsilonParameter(Double.parseDouble(string));
        } else {
            this.setEpsilonParameter(0.001);
        }
        string = Utils.getOption('W', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(1);
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-L");
        vector.add("" + this.getEpsilonParameter());
        vector.add("-W");
        vector.add("" + this.getSeed());
        return vector.toArray(new String[vector.size()]);
    }

    public boolean modelBuilt() {
        return this.m_bModelBuilt;
    }

    public void setSMOReg(SMOreg sMOreg) {
        this.m_SVM = sMOreg;
    }

    public int getKernelEvaluations() {
        return this.m_nEvals;
    }

    public int getCacheHits() {
        return this.m_nCacheHits;
    }

    protected void init(Instances instances) throws Exception {
        if (this.m_SVM == null) {
            throw new Exception("SVM not initialized in optimizer. Use RegOptimizer.setSVMReg()");
        }
        this.m_C = this.m_SVM.getC();
        this.m_data = instances;
        this.m_classIndex = instances.classIndex();
        this.m_nInstances = instances.numInstances();
        this.m_kernel = Kernel.makeCopy(this.m_SVM.getKernel());
        this.m_kernel.buildKernel(instances);
        this.m_target = new double[this.m_nInstances];
        for (int i = 0; i < this.m_nInstances; ++i) {
            this.m_target[i] = instances.instance(i).classValue();
        }
        this.m_random = new Random(this.m_nSeed);
        this.m_alpha = new double[this.m_target.length];
        this.m_alphaStar = new double[this.m_target.length];
        this.m_supportVectors = new SMOset(this.m_nInstances);
        this.m_b = 0.0;
        this.m_nEvals = 0;
        this.m_nCacheHits = -1;
    }

    protected void wrapUp() throws Exception {
        this.m_target = null;
        this.m_nEvals = this.m_kernel.numEvals();
        this.m_nCacheHits = this.m_kernel.numCacheHits();
        if (this.m_SVM.getKernel() instanceof PolyKernel && ((PolyKernel)this.m_SVM.getKernel()).getExponent() == 1.0) {
            double[] dArray = new double[this.m_data.numAttributes()];
            int n = this.m_supportVectors.getNext(-1);
            while (n != -1) {
                for (int i = 0; i < dArray.length; ++i) {
                    if (i == this.m_classIndex) continue;
                    int n2 = i;
                    dArray[n2] = dArray[n2] + (this.m_alpha[n] - this.m_alphaStar[n]) * this.m_data.instance(n).value(i);
                }
                n = this.m_supportVectors.getNext(n);
            }
            this.m_weights = dArray;
            this.m_alpha = null;
            this.m_alphaStar = null;
            this.m_kernel = null;
        }
        this.m_bModelBuilt = true;
    }

    protected double getScore() throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.m_nInstances; ++i) {
            d4 += this.m_alpha[i] - this.m_alphaStar[i];
            for (int j = 0; j < this.m_nInstances; ++j) {
                d2 += (this.m_alpha[i] - this.m_alphaStar[i]) * (this.m_alpha[j] - this.m_alphaStar[j]) * this.m_kernel.eval(i, j, this.m_data.instance(i));
            }
            d3 += this.m_target[i] * (this.m_alpha[i] - this.m_alphaStar[i]) - this.m_epsilon * (this.m_alpha[i] + this.m_alphaStar[i]);
        }
        return d += -0.5 * d2 + d3;
    }

    public void buildClassifier(Instances instances) throws Exception {
        throw new Exception("Don't call this directly, use subclass instead");
    }

    protected double SVMOutput(int n) throws Exception {
        double d = -this.m_b;
        int n2 = this.m_supportVectors.getNext(-1);
        while (n2 != -1) {
            d += (this.m_alpha[n2] - this.m_alphaStar[n2]) * this.m_kernel.eval(n, n2, this.m_data.instance(n));
            n2 = this.m_supportVectors.getNext(n2);
        }
        return d;
    }

    public double SVMOutput(Instance instance) throws Exception {
        double d = -this.m_b;
        if (this.m_weights != null) {
            for (int i = 0; i < this.m_weights.length; ++i) {
                if (instance.index(i) == this.m_classIndex) continue;
                d += this.m_weights[instance.index(i)] * instance.valueSparse(i);
            }
        } else {
            int n = this.m_supportVectors.getNext(-1);
            while (n != -1) {
                d += (this.m_alpha[n] - this.m_alphaStar[n]) * this.m_kernel.eval(-1, n, instance);
                n = this.m_supportVectors.getNext(n);
            }
        }
        return d;
    }

    public String seedTipText() {
        return "Seed for random number generator.";
    }

    public int getSeed() {
        return this.m_nSeed;
    }

    public void setSeed(int n) {
        this.m_nSeed = n;
    }

    public String epsilonParameterTipText() {
        return "The epsilon parameter of the epsilon insensitive loss function.(default 0.001).";
    }

    public double getEpsilonParameter() {
        return this.m_epsilon;
    }

    public void setEpsilonParameter(double d) {
        this.m_epsilon = d;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SMOreg\n\n");
        if (this.m_weights != null) {
            stringBuffer.append("weights (not support vectors):\n");
            for (n = 0; n < this.m_data.numAttributes(); ++n) {
                if (n == this.m_classIndex) continue;
                stringBuffer.append((this.m_weights[n] >= 0.0 ? " + " : " - ") + Utils.doubleToString(Math.abs(this.m_weights[n]), 12, 4) + " * ");
                if (this.m_SVM.getFilterType().getSelectedTag().getID() == 1) {
                    stringBuffer.append("(standardized) ");
                } else if (this.m_SVM.getFilterType().getSelectedTag().getID() == 0) {
                    stringBuffer.append("(normalized) ");
                }
                stringBuffer.append(this.m_data.attribute(n).name() + "\n");
            }
        } else {
            stringBuffer.append("Support vectors:\n");
            for (n = 0; n < this.m_nInstances; ++n) {
                if (this.m_alpha[n] > 0.0) {
                    stringBuffer.append("+" + this.m_alpha[n] + " * k[" + n + "]\n");
                }
                if (!(this.m_alphaStar[n] > 0.0)) continue;
                stringBuffer.append("-" + this.m_alphaStar[n] + " * k[" + n + "]\n");
            }
        }
        stringBuffer.append((this.m_b <= 0.0 ? " + " : " - ") + Utils.doubleToString(Math.abs(this.m_b), 12, 4) + "\n\n");
        stringBuffer.append("\n\nNumber of kernel evaluations: " + this.m_nEvals);
        if (this.m_nCacheHits >= 0 && this.m_nEvals > 0) {
            double d = 1.0 - (double)this.m_nEvals * 1.0 / (double)(this.m_nCacheHits + this.m_nEvals);
            stringBuffer.append(" (" + Utils.doubleToString(d * 100.0, 7, 3).trim() + "% cached)");
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5439 $");
    }
}

