/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Attribute;
import weka.core.AttributeLocator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class RelationalLocator
extends AttributeLocator {
    private static final long serialVersionUID = 4646872277151854732L;

    public RelationalLocator(Instances instances) {
        super(instances, 4);
    }

    public RelationalLocator(Instances instances, int n, int n2) {
        super(instances, 4, n, n2);
    }

    public RelationalLocator(Instances instances, int[] nArray) {
        super(instances, 4, nArray);
    }

    public static void copyRelationalValues(Instance instance, Instances instances, AttributeLocator attributeLocator) {
        if (instance.dataset() == null) {
            throw new IllegalArgumentException("Instance has no dataset assigned!!");
        }
        if (instance.dataset().numAttributes() != instances.numAttributes()) {
            throw new IllegalArgumentException("Src and Dest differ in # of attributes!!");
        }
        RelationalLocator.copyRelationalValues(instance, true, instance.dataset(), attributeLocator, instances, attributeLocator);
    }

    public static void copyRelationalValues(Instance instance, boolean bl, Instances instances, AttributeLocator attributeLocator, Instances instances2, AttributeLocator attributeLocator2) {
        if (instances == instances2) {
            return;
        }
        if (attributeLocator.getAttributeIndices().length != attributeLocator2.getAttributeIndices().length) {
            throw new IllegalArgumentException("Src and Dest relational indices differ in length!!");
        }
        if (attributeLocator.getLocatorIndices().length != attributeLocator2.getLocatorIndices().length) {
            throw new IllegalArgumentException("Src and Dest locator indices differ in length!!");
        }
        for (int i = 0; i < attributeLocator.getAttributeIndices().length; ++i) {
            int n = bl ? attributeLocator.getActualIndex(attributeLocator.getAttributeIndices()[i]) : attributeLocator2.getActualIndex(attributeLocator2.getAttributeIndices()[i]);
            Attribute attribute = instances.attribute(attributeLocator.getActualIndex(attributeLocator.getAttributeIndices()[i]));
            Attribute attribute2 = instances2.attribute(attributeLocator2.getActualIndex(attributeLocator2.getAttributeIndices()[i]));
            if (instance.isMissing(n)) continue;
            int n2 = attribute2.addRelation(attribute.relation((int)instance.value(n)));
            instance.setValue(n, (double)n2);
        }
        int[] nArray = attributeLocator.getLocatorIndices();
        int[] nArray2 = attributeLocator2.getLocatorIndices();
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n3 = n = bl ? attributeLocator.getActualIndex(nArray[i]) : attributeLocator2.getActualIndex(nArray2[i]);
            if (instance.isMissing(n)) continue;
            Instances instances3 = bl ? instance.relationalValue(n) : instance.relationalValue(n);
            AttributeLocator attributeLocator3 = attributeLocator.getLocator(nArray[i]);
            Instances instances4 = attributeLocator3.getData();
            AttributeLocator attributeLocator4 = attributeLocator2.getLocator(nArray2[i]);
            Instances instances5 = attributeLocator4.getData();
            for (int j = 0; j < instances3.numInstances(); ++j) {
                RelationalLocator.copyRelationalValues(instances3.instance(j), bl, instances4, attributeLocator3, instances5, attributeLocator4);
            }
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

