/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import weka.associations.tertius.IndividualInstance;
import weka.associations.tertius.IndividualLiteral;
import weka.associations.tertius.Literal;
import weka.associations.tertius.Rule;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;

public abstract class LiteralSet
implements Serializable,
Cloneable,
RevisionHandler {
    private static final long serialVersionUID = 6094536488654503152L;
    private ArrayList m_literals = new ArrayList();
    private Literal m_lastLiteral = null;
    private int m_numInstances;
    private ArrayList m_counterInstances = null;
    private int m_counter;
    private int m_type = -1;

    public LiteralSet() {
    }

    public LiteralSet(Instances instances) {
        this();
        this.m_numInstances = instances.numInstances();
        this.m_counterInstances = new ArrayList(this.m_numInstances);
        Enumeration enumeration = instances.enumerateInstances();
        while (enumeration.hasMoreElements()) {
            this.m_counterInstances.add(enumeration.nextElement());
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
            ((LiteralSet)object).m_literals = (ArrayList)this.m_literals.clone();
            if (this.m_counterInstances != null) {
                ((LiteralSet)object).m_counterInstances = (ArrayList)this.m_counterInstances.clone();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        return object;
    }

    public void upDate(Instances instances) {
        Enumeration enumeration = instances.enumerateInstances();
        this.m_numInstances = instances.numInstances();
        this.m_counter = 0;
        while (enumeration.hasMoreElements()) {
            if (!this.counterInstance((Instance)enumeration.nextElement())) continue;
            ++this.m_counter;
        }
    }

    public int getCounterInstancesNumber() {
        if (this.m_counterInstances != null) {
            return this.m_counterInstances.size();
        }
        return this.m_counter;
    }

    public double getCounterInstancesFrequency() {
        return (double)this.getCounterInstancesNumber() / (double)this.m_numInstances;
    }

    public boolean overFrequencyThreshold(double d) {
        return this.getCounterInstancesFrequency() >= d;
    }

    public boolean hasMaxCounterInstances() {
        return this.getCounterInstancesNumber() == this.m_numInstances;
    }

    public void addElement(Literal literal) {
        int n;
        this.m_literals.add(literal);
        this.m_lastLiteral = literal;
        if (literal instanceof IndividualLiteral && (n = ((IndividualLiteral)literal).getType()) > this.m_type) {
            this.m_type = n;
        }
        if (this.m_counterInstances != null) {
            for (n = this.m_counterInstances.size() - 1; n >= 0; --n) {
                Instance instance = (Instance)this.m_counterInstances.get(n);
                if (this.canKeep(instance, literal)) continue;
                this.m_counterInstances.remove(n);
            }
        }
    }

    public final boolean isEmpty() {
        return this.m_literals.size() == 0;
    }

    public final int numLiterals() {
        return this.m_literals.size();
    }

    public final Iterator enumerateLiterals() {
        return this.m_literals.iterator();
    }

    public Literal getLastLiteral() {
        return this.m_lastLiteral;
    }

    public boolean negationIncludedIn(LiteralSet literalSet) {
        Iterator iterator = this.enumerateLiterals();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            if (literalSet.contains(literal.getNegation())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Literal literal) {
        return this.m_literals.contains(literal);
    }

    public int getType() {
        return this.m_type;
    }

    public boolean counterInstance(Instance instance, Instance instance2) {
        Iterator iterator = this.enumerateLiterals();
        while (iterator.hasNext()) {
            IndividualLiteral individualLiteral = (IndividualLiteral)iterator.next();
            if (individualLiteral.getType() == IndividualLiteral.INDIVIDUAL_PROPERTY && !this.canKeep(instance, individualLiteral)) {
                return false;
            }
            if (individualLiteral.getType() != IndividualLiteral.PART_PROPERTY || this.canKeep(instance2, individualLiteral)) continue;
            return false;
        }
        return true;
    }

    public boolean counterInstance(Instance instance) {
        if (instance instanceof IndividualInstance && this.m_type == IndividualLiteral.PART_PROPERTY) {
            Enumeration enumeration = ((IndividualInstance)instance).getParts().enumerateInstances();
            while (enumeration.hasMoreElements()) {
                if (!this.counterInstance(instance, (Instance)enumeration.nextElement())) continue;
                return true;
            }
            return false;
        }
        Iterator iterator = this.enumerateLiterals();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            if (this.canKeep(instance, literal)) continue;
            return false;
        }
        return true;
    }

    public abstract boolean canKeep(Instance var1, Literal var2);

    public abstract boolean isIncludedIn(Rule var1);

    public abstract String toString();
}

