/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import javax.swing.JOptionPane;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Memory
implements RevisionHandler {
    protected static boolean m_Enabled = true;
    protected boolean m_UseGUI = false;
    protected static long m_Initial = Runtime.getRuntime().totalMemory();
    protected long m_Total;
    protected long m_Max;
    protected Runtime m_Runtime;

    public Memory() {
        this(false);
    }

    public Memory(boolean bl) {
        this.m_UseGUI = bl;
        this.m_Runtime = Runtime.getRuntime();
        this.m_Max = this.m_Runtime.maxMemory();
        this.m_Total = this.m_Runtime.totalMemory();
    }

    public boolean isEnabled() {
        return m_Enabled;
    }

    public void setEnabled(boolean bl) {
        m_Enabled = bl;
    }

    public boolean getUseGUI() {
        return this.m_UseGUI;
    }

    public long getInitial() {
        return m_Initial;
    }

    public long getCurrent() {
        this.m_Runtime = Runtime.getRuntime();
        this.m_Total = this.m_Runtime.totalMemory();
        return this.m_Total;
    }

    public long getMax() {
        return this.m_Max;
    }

    public boolean isOutOfMemory() {
        if (this.isEnabled()) {
            return this.getMax() - this.getCurrent() < this.getInitial() + 200000L;
        }
        return false;
    }

    public static double toMegaByte(long l) {
        return (double)l / 1048576.0;
    }

    public void showOutOfMemory() {
        if (!this.isEnabled()) {
            return;
        }
        System.gc();
        String string = "Not enough memory. Please load a smaller dataset or use larger heap size.\n- initial JVM size:   " + Utils.doubleToString(Memory.toMegaByte(m_Initial), 1) + "MB\n" + "- total memory used:  " + Utils.doubleToString(Memory.toMegaByte(this.m_Total), 1) + "MB\n" + "- max. memory avail.: " + Utils.doubleToString(Memory.toMegaByte(this.m_Max), 1) + "MB\n" + "\n" + "Note:\n" + "The Java heap size can be specified with the -Xmx option.\n" + "E.g., to use 128MB as heap size, the command line looks like this:\n" + "   java -Xmx128m -classpath ...\n" + "This does NOT work in the SimpleCLI, the java command refers\n" + "to the one with which Weka is started.";
        System.err.println(string);
        if (this.getUseGUI()) {
            JOptionPane.showMessageDialog(null, string, "OutOfMemory", 2);
        }
    }

    public void stopThreads() {
        Thread[] threadArray = new Thread[Thread.activeCount()];
        Thread.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            Thread thread = threadArray[i];
            if (thread == null || thread == Thread.currentThread()) continue;
            if (thread.getName().startsWith("Thread")) {
                thread.stop();
                continue;
            }
            if (!thread.getName().startsWith("AWT-EventQueue")) continue;
            thread.stop();
        }
        threadArray = null;
        System.gc();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }

    public static void main(String[] stringArray) {
        Memory memory = new Memory();
        System.out.println("Initial memory: " + Utils.doubleToString(Memory.toMegaByte(memory.getInitial()), 1) + "MB" + " (" + memory.getInitial() + ")");
        System.out.println("Max memory: " + Utils.doubleToString(Memory.toMegaByte(memory.getMax()), 1) + "MB" + " (" + memory.getMax() + ")");
    }
}

