/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class RemoveRange
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = -3064641215340828695L;
    private Range m_Range = new Range("first-last");

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(6);
        vector.addElement(new Option("\tSpecifies list of instances to select. First and last\n\tare valid indexes. (required)\n", "R", 1, "-R <inst1,inst2-inst4,...>"));
        vector.addElement(new Option("\tSpecifies if inverse of selection is to be output.\n", "V", 0, "-V"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('R', stringArray);
        if (string.length() != 0) {
            this.setInstancesIndices(string);
        } else {
            this.setInstancesIndices("first-last");
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[8];
        int n = 0;
        if (this.getInvertSelection()) {
            stringArray[n++] = "-V";
        }
        stringArray[n++] = "-R";
        stringArray[n++] = this.getInstancesIndices();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String globalInfo() {
        return "A filter that removes a given range of instances of a dataset.";
    }

    public String instancesIndicesTipText() {
        return "The range of instances to select. First and last are valid indexes.";
    }

    public String getInstancesIndices() {
        return this.m_Range.getRanges();
    }

    public void setInstancesIndices(String string) {
        this.m_Range.setRanges(string);
    }

    public String invertSelectionTipText() {
        return "Whether to invert the selection.";
    }

    public boolean getInvertSelection() {
        return this.m_Range.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_Range.setInvert(bl);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.m_Range.setUpper(this.getInputFormat().numInstances() - 1);
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                if (this.m_Range.isInRange(i)) continue;
                this.push(this.getInputFormat().instance(i));
            }
        } else {
            for (int i = 0; i < this.getInputFormat().numInstances(); ++i) {
                this.push(this.getInputFormat().instance(i));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5548 $");
    }

    public static void main(String[] stringArray) {
        RemoveRange.runFilter(new RemoveRange(), stringArray);
    }
}

