/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class RandomTree
extends Classifier
implements OptionHandler,
WeightedInstancesHandler,
Randomizable,
Drawable {
    static final long serialVersionUID = 8934314652175299374L;
    protected RandomTree[] m_Successors;
    protected int m_Attribute = -1;
    protected double m_SplitPoint = Double.NaN;
    protected Instances m_Info = null;
    protected double[] m_Prop = null;
    protected double[] m_ClassDistribution = null;
    protected double m_MinNum = 1.0;
    protected int m_KValue = 0;
    protected int m_randomSeed = 1;
    protected int m_MaxDepth = 0;
    protected int m_NumFolds = 0;
    protected boolean m_AllowUnclassifiedInstances = false;
    protected Classifier m_ZeroR;

    public String globalInfo() {
        return "Class for constructing a tree that considers K randomly  chosen attributes at each node. Performs no pruning. Also has an option to allow estimation of class probabilities based on a hold-out set (backfitting).";
    }

    public String minNumTipText() {
        return "The minimum total weight of the instances in a leaf.";
    }

    public double getMinNum() {
        return this.m_MinNum;
    }

    public void setMinNum(double d) {
        this.m_MinNum = d;
    }

    public String KValueTipText() {
        return "Sets the number of randomly chosen attributes. If 0, log_2(number_of_attributes) + 1 is used.";
    }

    public int getKValue() {
        return this.m_KValue;
    }

    public void setKValue(int n) {
        this.m_KValue = n;
    }

    public String seedTipText() {
        return "The random number seed used for selecting attributes.";
    }

    public void setSeed(int n) {
        this.m_randomSeed = n;
    }

    public int getSeed() {
        return this.m_randomSeed;
    }

    public String maxDepthTipText() {
        return "The maximum depth of the tree, 0 for unlimited.";
    }

    public int getMaxDepth() {
        return this.m_MaxDepth;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for backfitting. One fold is used for backfitting, the rest for growing the tree. (Default: 0, no backfitting)";
    }

    public int getNumFolds() {
        return this.m_NumFolds;
    }

    public void setNumFolds(int n) {
        this.m_NumFolds = n;
    }

    public String allowUnclassifiedInstancesTipText() {
        return "Whether to allow unclassified instances.";
    }

    public boolean getAllowUnclassifiedInstances() {
        return this.m_AllowUnclassifiedInstances;
    }

    public void setAllowUnclassifiedInstances(boolean bl) {
        this.m_AllowUnclassifiedInstances = bl;
    }

    public void setMaxDepth(int n) {
        this.m_MaxDepth = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tNumber of attributes to randomly investigate\n\t(<0 = int(log_2(#attributes)+1)).", "K", 1, "-K <number of attributes>"));
        vector.addElement(new Option("\tSet minimum number of instances per leaf.", "M", 1, "-M <minimum number of instances>"));
        vector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tThe maximum depth of the tree, 0 for unlimited.\n\t(default 0)", "depth", 1, "-depth <num>"));
        vector.addElement(new Option("\tNumber of folds for backfitting (default 0, no backfitting).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tAllow unclassified instances.", "U", 0, "-U"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-K");
        vector.add("" + this.getKValue());
        vector.add("-M");
        vector.add("" + this.getMinNum());
        vector.add("-S");
        vector.add("" + this.getSeed());
        if (this.getMaxDepth() > 0) {
            vector.add("-depth");
            vector.add("" + this.getMaxDepth());
        }
        if (this.getNumFolds() > 0) {
            vector.add("-N");
            vector.add("" + this.getNumFolds());
        }
        if (this.getAllowUnclassifiedInstances()) {
            vector.add("-U");
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('K', stringArray);
        this.m_KValue = string.length() != 0 ? Integer.parseInt(string) : 0;
        string = Utils.getOption('M', stringArray);
        this.m_MinNum = string.length() != 0 ? Double.parseDouble(string) : 1.0;
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(1);
        }
        string = Utils.getOption("depth", stringArray);
        if (string.length() != 0) {
            this.setMaxDepth(Integer.parseInt(string));
        } else {
            this.setMaxDepth(0);
        }
        String string2 = Utils.getOption('N', stringArray);
        this.m_NumFolds = string2.length() != 0 ? Integer.parseInt(string2) : 0;
        this.setAllowUnclassifiedInstances(Utils.getFlag('U', stringArray));
        super.setOptions(stringArray);
        Utils.checkForRemainingOptions(stringArray);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (this.m_KValue > instances.numAttributes() - 1) {
            this.m_KValue = instances.numAttributes() - 1;
        }
        if (this.m_KValue < 1) {
            this.m_KValue = (int)Utils.log2(instances.numAttributes()) + 1;
        }
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        if (instances.numAttributes() == 1) {
            System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
            this.m_ZeroR = new ZeroR();
            this.m_ZeroR.buildClassifier(instances);
            return;
        }
        this.m_ZeroR = null;
        Instances instances2 = null;
        Instances instances3 = null;
        Random random = instances.getRandomNumberGenerator(this.m_randomSeed);
        if (this.m_NumFolds <= 0) {
            instances2 = instances;
        } else {
            instances.randomize(random);
            instances.stratify(this.m_NumFolds);
            instances2 = instances.trainCV(this.m_NumFolds, 1, random);
            instances3 = instances.testCV(this.m_NumFolds, 1);
        }
        int[] nArray = new int[instances.numAttributes() - 1];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n == instances.classIndex()) {
                // empty if block
            }
            int n2 = ++n;
            ++n;
            nArray[i] = n2;
        }
        double[] dArray = new double[instances2.numClasses()];
        for (int i = 0; i < instances2.numInstances(); ++i) {
            Instance instance = instances2.instance(i);
            int n3 = (int)instance.classValue();
            dArray[n3] = dArray[n3] + instance.weight();
        }
        this.buildTree(instances2, dArray, new Instances(instances, 0), this.m_MinNum, this.m_Debug, nArray, random, 0, this.getAllowUnclassifiedInstances());
        if (instances3 != null) {
            this.backfitData(instances3);
        }
    }

    public void backfitData(Instances instances) throws Exception {
        double[] dArray = new double[instances.numClasses()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            int n = (int)instance.classValue();
            dArray[n] = dArray[n] + instance.weight();
        }
        this.backfitData(instances, dArray);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.m_ZeroR != null) {
            return this.m_ZeroR.distributionForInstance(instance);
        }
        double[] dArray = null;
        if (this.m_Attribute > -1) {
            if (instance.isMissing(this.m_Attribute)) {
                dArray = new double[this.m_Info.numClasses()];
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    double[] dArray2 = this.m_Successors[i].distributionForInstance(instance);
                    if (dArray2 == null) continue;
                    for (int j = 0; j < dArray2.length; ++j) {
                        int n = j;
                        dArray[n] = dArray[n] + this.m_Prop[i] * dArray2[j];
                    }
                }
            } else {
                dArray = this.m_Info.attribute(this.m_Attribute).isNominal() ? this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance) : (instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance));
            }
        }
        if (this.m_Attribute == -1 || dArray == null) {
            if (this.m_ClassDistribution == null) {
                if (this.getAllowUnclassifiedInstances()) {
                    return new double[this.m_Info.numClasses()];
                }
                return null;
            }
            double[] dArray3 = (double[])this.m_ClassDistribution.clone();
            Utils.normalize(dArray3);
            return dArray3;
        }
        return dArray;
    }

    public String toGraph() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.toGraph(stringBuffer, 0);
            String string = "digraph Tree {\nedge [style=bold]\n" + stringBuffer.toString() + "\n}\n";
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int toGraph(StringBuffer stringBuffer, int n) throws Exception {
        int n2 = Utils.maxIndex(this.m_ClassDistribution);
        String string = this.m_Info.classAttribute().value(n2);
        ++n;
        if (this.m_Attribute == -1) {
            stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + ": " + string + "\"" + "shape=box]\n");
        } else {
            stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + ": " + string + "\"]\n");
            for (int i = 0; i < this.m_Successors.length; ++i) {
                stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + "->" + "N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"" + this.m_Info.attribute(this.m_Attribute).name());
                if (this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                    if (i == 0) {
                        stringBuffer.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                    } else {
                        stringBuffer.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                    }
                } else {
                    stringBuffer.append(" = " + this.m_Info.attribute(this.m_Attribute).value(i));
                }
                stringBuffer.append("\"]\n");
                n = this.m_Successors[i].toGraph(stringBuffer, n);
            }
        }
        return n;
    }

    public String toString() {
        if (this.m_ZeroR != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
            stringBuffer.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
            stringBuffer.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
            stringBuffer.append(this.m_ZeroR.toString());
            return stringBuffer.toString();
        }
        if (this.m_Successors == null) {
            return "RandomTree: no model has been built yet.";
        }
        return "\nRandomTree\n==========\n" + this.toString(0) + "\n" + "\nSize of the tree : " + this.numNodes() + (this.getMaxDepth() > 0 ? "\nMax depth of tree: " + this.getMaxDepth() : "");
    }

    protected String leafString() throws Exception {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        if (this.m_ClassDistribution != null) {
            d = Utils.sum(this.m_ClassDistribution);
            n = Utils.maxIndex(this.m_ClassDistribution);
            d2 = this.m_ClassDistribution[n];
        }
        return " : " + this.m_Info.classAttribute().value(n) + " (" + Utils.doubleToString(d, 2) + "/" + Utils.doubleToString(d - d2, 2) + ")";
    }

    protected String toString(int n) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_Attribute == -1) {
                return this.leafString();
            }
            if (this.m_Info.attribute(this.m_Attribute).isNominal()) {
                for (int i = 0; i < this.m_Successors.length; ++i) {
                    stringBuffer.append("\n");
                    for (int j = 0; j < n; ++j) {
                        stringBuffer.append("|   ");
                    }
                    stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " = " + this.m_Info.attribute(this.m_Attribute).value(i));
                    stringBuffer.append(this.m_Successors[i].toString(n + 1));
                }
            } else {
                int n2;
                stringBuffer.append("\n");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("|   ");
                }
                stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " < " + Utils.doubleToString(this.m_SplitPoint, 2));
                stringBuffer.append(this.m_Successors[0].toString(n + 1));
                stringBuffer.append("\n");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append("|   ");
                }
                stringBuffer.append(this.m_Info.attribute(this.m_Attribute).name() + " >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                stringBuffer.append(this.m_Successors[1].toString(n + 1));
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "RandomTree: tree can't be printed";
        }
    }

    protected void backfitData(Instances instances, double[] dArray) throws Exception {
        if (instances.numInstances() == 0) {
            this.m_Attribute = -1;
            this.m_ClassDistribution = null;
            this.m_Prop = null;
            return;
        }
        this.m_ClassDistribution = (double[])dArray.clone();
        if (this.m_Attribute > -1) {
            int n;
            this.m_Prop = new double[this.m_Successors.length];
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance = instances.instance(i);
                if (instance.isMissing(this.m_Attribute)) continue;
                if (instances.attribute(this.m_Attribute).isNominal()) {
                    int n2 = (int)instance.value(this.m_Attribute);
                    this.m_Prop[n2] = this.m_Prop[n2] + instance.weight();
                    continue;
                }
                int n3 = instance.value(this.m_Attribute) < this.m_SplitPoint ? 0 : 1;
                this.m_Prop[n3] = this.m_Prop[n3] + instance.weight();
            }
            if (Utils.sum(this.m_Prop) <= 0.0) {
                this.m_Attribute = -1;
                this.m_Prop = null;
                return;
            }
            Utils.normalize(this.m_Prop);
            Instances[] instancesArray = this.splitData(instances);
            for (n = 0; n < instancesArray.length; ++n) {
                double[] dArray2 = new double[instances.numClasses()];
                for (int i = 0; i < instancesArray[n].numInstances(); ++i) {
                    int n4 = (int)instancesArray[n].instance(i).classValue();
                    dArray2[n4] = dArray2[n4] + instancesArray[n].instance(i).weight();
                }
                this.m_Successors[n].backfitData(instancesArray[n], dArray2);
            }
            if (this.getAllowUnclassifiedInstances()) {
                this.m_ClassDistribution = null;
                return;
            }
            n = 0;
            for (int i = 0; i < instancesArray.length; ++i) {
                if (this.m_Successors[i].m_ClassDistribution != null) continue;
                n = 1;
                return;
            }
            this.m_ClassDistribution = null;
        }
    }

    protected void buildTree(Instances instances, double[] dArray, Instances instances2, double d, boolean bl, int[] nArray, Random random, int n, boolean bl2) throws Exception {
        this.m_Info = instances2;
        this.m_Debug = bl;
        this.m_MinNum = d;
        this.m_AllowUnclassifiedInstances = bl2;
        if (instances.numInstances() == 0) {
            this.m_Attribute = -1;
            this.m_ClassDistribution = null;
            this.m_Prop = null;
            return;
        }
        this.m_ClassDistribution = (double[])dArray.clone();
        if (Utils.sum(this.m_ClassDistribution) < 2.0 * this.m_MinNum || Utils.eq(this.m_ClassDistribution[Utils.maxIndex(this.m_ClassDistribution)], Utils.sum(this.m_ClassDistribution)) || this.getMaxDepth() > 0 && n >= this.getMaxDepth()) {
            this.m_Attribute = -1;
            this.m_Prop = null;
            return;
        }
        double[] dArray2 = new double[instances.numAttributes()];
        double[][][] dArray3 = new double[instances.numAttributes()][0][0];
        double[][] dArray4 = new double[instances.numAttributes()][0];
        double[] dArray5 = new double[instances.numAttributes()];
        int n2 = 0;
        int n3 = this.m_KValue;
        boolean bl3 = false;
        for (int i = nArray.length; !(i <= 0 || n3-- <= 0 && bl3); --i) {
            int n4 = random.nextInt(i);
            n2 = nArray[n4];
            nArray[n4] = nArray[i - 1];
            nArray[i - 1] = n2;
            dArray5[n2] = this.distribution(dArray4, dArray3, n2, instances);
            dArray2[n2] = this.gain(dArray3[n2], this.priorVal(dArray3[n2]));
            if (!Utils.gr(dArray2[n2], 0.0)) continue;
            bl3 = true;
        }
        this.m_Attribute = Utils.maxIndex(dArray2);
        double[][] dArray6 = dArray3[this.m_Attribute];
        if (Utils.gr(dArray2[this.m_Attribute], 0.0)) {
            int n5;
            this.m_SplitPoint = dArray5[this.m_Attribute];
            this.m_Prop = dArray4[this.m_Attribute];
            Instances[] instancesArray = this.splitData(instances);
            this.m_Successors = new RandomTree[dArray6.length];
            for (n5 = 0; n5 < dArray6.length; ++n5) {
                this.m_Successors[n5] = new RandomTree();
                this.m_Successors[n5].setKValue(this.m_KValue);
                this.m_Successors[n5].setMaxDepth(this.getMaxDepth());
                this.m_Successors[n5].buildTree(instancesArray[n5], dArray6[n5], instances2, this.m_MinNum, this.m_Debug, nArray, random, n + 1, bl2);
            }
            n5 = 0;
            for (int i = 0; i < instancesArray.length; ++i) {
                if (this.m_Successors[i].m_ClassDistribution != null) continue;
                n5 = 1;
                break;
            }
            if (n5 == 0) {
                this.m_ClassDistribution = null;
            }
        } else {
            this.m_Attribute = -1;
        }
    }

    public int numNodes() {
        if (this.m_Attribute == -1) {
            return 1;
        }
        int n = 1;
        for (int i = 0; i < this.m_Successors.length; ++i) {
            n += this.m_Successors[i].numNodes();
        }
        return n;
    }

    protected Instances[] splitData(Instances instances) throws Exception {
        int n;
        Instances[] instancesArray = new Instances[this.m_Prop.length];
        for (n = 0; n < this.m_Prop.length; ++n) {
            instancesArray[n] = new Instances(instances, instances.numInstances());
        }
        for (n = 0; n < instances.numInstances(); ++n) {
            Instance instance = instances.instance(n);
            if (instance.isMissing(this.m_Attribute)) {
                for (int i = 0; i < this.m_Prop.length; ++i) {
                    if (!(this.m_Prop[i] > 0.0)) continue;
                    Instance instance2 = (Instance)instance.copy();
                    instance2.setWeight(this.m_Prop[i] * instance.weight());
                    instancesArray[i].add(instance2);
                }
                continue;
            }
            if (instances.attribute(this.m_Attribute).isNominal()) {
                instancesArray[(int)instance.value(this.m_Attribute)].add(instance);
                continue;
            }
            if (instances.attribute(this.m_Attribute).isNumeric()) {
                instancesArray[instance.value(this.m_Attribute) < this.m_SplitPoint ? 0 : 1].add(instance);
                continue;
            }
            throw new IllegalArgumentException("Unknown attribute type");
        }
        for (n = 0; n < this.m_Prop.length; ++n) {
            instancesArray[n].compactify();
        }
        return instancesArray;
    }

    protected double distribution(double[][] dArray, double[][][] dArray2, int n, Instances instances) throws Exception {
        int n2;
        double d = Double.NaN;
        Attribute attribute = instances.attribute(n);
        double[][] dArray3 = null;
        int n3 = -1;
        if (attribute.isNominal()) {
            dArray3 = new double[attribute.numValues()][instances.numClasses()];
            for (n2 = 0; n2 < instances.numInstances(); ++n2) {
                Instance instance = instances.instance(n2);
                if (instance.isMissing(n)) {
                    if (n3 >= 0) continue;
                    n3 = n2;
                    continue;
                }
                double[] dArray4 = dArray3[(int)instance.value(n)];
                int n4 = (int)instance.classValue();
                dArray4[n4] = dArray4[n4] + instance.weight();
            }
        } else {
            Instance instance;
            double[][] dArray5 = new double[2][instances.numClasses()];
            dArray3 = new double[2][instances.numClasses()];
            instances.sort(n);
            for (int i = 0; i < instances.numInstances(); ++i) {
                Instance instance2 = instances.instance(i);
                if (instance2.isMissing(n)) {
                    n3 = i;
                    break;
                }
                double[] dArray6 = dArray5[1];
                int n5 = (int)instance2.classValue();
                dArray6[n5] = dArray6[n5] + instance2.weight();
            }
            double d2 = this.priorVal(dArray5);
            for (int i = 0; i < dArray5.length; ++i) {
                System.arraycopy(dArray5[i], 0, dArray3[i], 0, dArray3[i].length);
            }
            double d3 = instances.instance(0).value(n);
            double d4 = -1.7976931348623157E308;
            for (int i = 0; i < instances.numInstances() && !(instance = instances.instance(i)).isMissing(n); ++i) {
                double d5;
                if (instance.value(n) > d3 && (d5 = this.gain(dArray5, d2)) > d4) {
                    d4 = d5;
                    d = (instance.value(n) + d3) / 2.0;
                    for (int j = 0; j < dArray5.length; ++j) {
                        System.arraycopy(dArray5[j], 0, dArray3[j], 0, dArray3[j].length);
                    }
                }
                d3 = instance.value(n);
                double[] dArray7 = dArray5[0];
                int n6 = (int)instance.classValue();
                dArray7[n6] = dArray7[n6] + instance.weight();
                double[] dArray8 = dArray5[1];
                int n7 = (int)instance.classValue();
                dArray8[n7] = dArray8[n7] - instance.weight();
            }
        }
        dArray[n] = new double[dArray3.length];
        for (n2 = 0; n2 < dArray[n].length; ++n2) {
            dArray[n][n2] = Utils.sum(dArray3[n2]);
        }
        if (Utils.eq(Utils.sum(dArray[n]), 0.0)) {
            for (n2 = 0; n2 < dArray[n].length; ++n2) {
                dArray[n][n2] = 1.0 / (double)dArray[n].length;
            }
        } else {
            Utils.normalize(dArray[n]);
        }
        if (n3 > -1) {
            for (n2 = n3; n2 < instances.numInstances(); ++n2) {
                Instance instance = instances.instance(n2);
                if (attribute.isNominal()) {
                    if (!instance.isMissing(n)) continue;
                    for (int i = 0; i < dArray3.length; ++i) {
                        double[] dArray9 = dArray3[i];
                        int n8 = (int)instance.classValue();
                        dArray9[n8] = dArray9[n8] + dArray[n][i] * instance.weight();
                    }
                    continue;
                }
                for (int i = 0; i < dArray3.length; ++i) {
                    double[] dArray10 = dArray3[i];
                    int n9 = (int)instance.classValue();
                    dArray10[n9] = dArray10[n9] + dArray[n][i] * instance.weight();
                }
            }
        }
        dArray2[n] = dArray3;
        return d;
    }

    protected double priorVal(double[][] dArray) {
        return ContingencyTables.entropyOverColumns(dArray);
    }

    protected double gain(double[][] dArray, double d) {
        return d - ContingencyTables.entropyConditionedOnRows(dArray);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] stringArray) {
        RandomTree.runClassifier(new RandomTree(), stringArray);
    }

    public String graph() throws Exception {
        if (this.m_Successors == null) {
            throw new Exception("RandomTree: No model built yet.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.toGraph(stringBuffer, 0, null);
        String string = "digraph RandomTree {\nedge [style=bold]\n" + stringBuffer.toString() + "\n}\n";
        return string;
    }

    public int graphType() {
        return 1;
    }

    protected int toGraph(StringBuffer stringBuffer, int n, RandomTree randomTree) throws Exception {
        ++n;
        if (this.m_Attribute == -1) {
            stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + this.leafString() + "\"" + " shape=box]\n");
        } else {
            stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + n + ": " + this.m_Info.attribute(this.m_Attribute).name() + "\"]\n");
            for (int i = 0; i < this.m_Successors.length; ++i) {
                stringBuffer.append("N" + Integer.toHexString(this.hashCode()) + "->" + "N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"");
                if (this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                    if (i == 0) {
                        stringBuffer.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                    } else {
                        stringBuffer.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                    }
                } else {
                    stringBuffer.append(" = " + this.m_Info.attribute(this.m_Attribute).value(i));
                }
                stringBuffer.append("\"]\n");
                n = this.m_Successors[i].toGraph(stringBuffer, n, this);
            }
        }
        return n;
    }
}

