/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.lang.reflect.Method;
import java.util.Arrays;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.matrix.FlexibleDecimalFormat;
import weka.core.matrix.IntVector;

public class DoubleVector
implements Cloneable,
RevisionHandler {
    double[] V;
    private int sizeOfVector;

    public DoubleVector() {
        this(0);
    }

    public DoubleVector(int n) {
        this.V = new double[n];
        this.setSize(n);
    }

    public DoubleVector(int n, double d) {
        this(n);
        this.set(d);
    }

    public DoubleVector(double[] dArray) {
        if (dArray == null) {
            this.V = new double[0];
            this.setSize(0);
        } else {
            this.V = dArray;
            this.setSize(dArray.length);
        }
    }

    public void set(int n, double d) {
        this.V[n] = d;
    }

    public void set(double d) {
        this.set(0, this.size() - 1, d);
    }

    public void set(int n, int n2, double d) {
        for (int i = n; i <= n2; ++i) {
            this.V[i] = d;
        }
    }

    public void set(int n, int n2, double[] dArray, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.V[i] = dArray[n3 + i - n];
        }
    }

    public void set(DoubleVector doubleVector) {
        this.set(0, doubleVector.size() - 1, doubleVector, 0);
    }

    public void set(int n, int n2, DoubleVector doubleVector, int n3) {
        for (int i = n; i <= n2; ++i) {
            this.V[i] = doubleVector.V[n3 + i - n];
        }
    }

    public double[] getArray() {
        return this.V;
    }

    void setArray(double[] dArray) {
        this.V = dArray;
    }

    public double[] getArrayCopy() {
        double[] dArray = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            dArray[i] = this.V[i];
        }
        return dArray;
    }

    public void sort() {
        Arrays.sort(this.V, 0, this.size());
    }

    public IntVector sortWithIndex() {
        IntVector intVector = IntVector.seq(0, this.size() - 1);
        this.sortWithIndex(0, this.size() - 1, intVector);
        return intVector;
    }

    public void sortWithIndex(int n, int n2, IntVector intVector) {
        if (n < n2) {
            int n3 = (n + n2) / 2;
            double d = Math.min(this.V[n], Math.max(this.V[n3], this.V[n2]));
            int n4 = n;
            int n5 = n2;
            while (n4 < n5) {
                while (this.V[n4] < d && n4 < n2) {
                    ++n4;
                }
                while (this.V[n5] > d && n5 > n) {
                    --n5;
                }
                if (n4 > n5) continue;
                this.swap(n4, n5);
                intVector.swap(n4, n5);
                ++n4;
                --n5;
            }
            this.sortWithIndex(n, n5, intVector);
            this.sortWithIndex(n4, n2, intVector);
        }
    }

    public int size() {
        return this.sizeOfVector;
    }

    public void setSize(int n) {
        if (n > this.capacity()) {
            throw new IllegalArgumentException("insufficient capacity");
        }
        this.sizeOfVector = n;
    }

    public int capacity() {
        if (this.V == null) {
            return 0;
        }
        return this.V.length;
    }

    public void setCapacity(int n) {
        if (n == this.capacity()) {
            return;
        }
        double[] dArray = this.V;
        int n2 = Math.min(n, this.size());
        this.V = new double[n];
        this.setSize(n2);
        this.set(0, n2 - 1, dArray, 0);
    }

    public double get(int n) {
        return this.V[n];
    }

    public void setPlus(int n, double d) {
        int n2 = n;
        this.V[n2] = this.V[n2] + d;
    }

    public void setTimes(int n, double d) {
        int n2 = n;
        this.V[n2] = this.V[n2] * d;
    }

    public void addElement(double d) {
        if (this.capacity() == 0) {
            this.setCapacity(10);
        }
        if (this.size() == this.capacity()) {
            this.setCapacity(2 * this.capacity());
        }
        this.V[this.size()] = d;
        this.setSize(this.size() + 1);
    }

    public DoubleVector square() {
        DoubleVector doubleVector = new DoubleVector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            doubleVector.V[i] = this.V[i] * this.V[i];
        }
        return doubleVector;
    }

    public DoubleVector sqrt() {
        DoubleVector doubleVector = new DoubleVector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            doubleVector.V[i] = Math.sqrt(this.V[i]);
        }
        return doubleVector;
    }

    public DoubleVector copy() {
        return (DoubleVector)this.clone();
    }

    public Object clone() {
        int n = this.size();
        DoubleVector doubleVector = new DoubleVector(n);
        for (int i = 0; i < n; ++i) {
            doubleVector.V[i] = this.V[i];
        }
        return doubleVector;
    }

    public double innerProduct(DoubleVector doubleVector) {
        if (this.size() != doubleVector.size()) {
            throw new IllegalArgumentException("sizes unmatch");
        }
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            d += this.V[i] * doubleVector.V[i];
        }
        return d;
    }

    public DoubleVector sign() {
        DoubleVector doubleVector = new DoubleVector(this.size());
        for (int i = 0; i < this.size(); ++i) {
            doubleVector.V[i] = this.V[i] > 0.0 ? 1.0 : (this.V[i] < 0.0 ? -1.0 : 0.0);
        }
        return doubleVector;
    }

    public double sum() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            d += this.V[i];
        }
        return d;
    }

    public double sum2() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            d += this.V[i] * this.V[i];
        }
        return d;
    }

    public double norm1() {
        double d = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            d += Math.abs(this.V[i]);
        }
        return d;
    }

    public double norm2() {
        return Math.sqrt(this.sum2());
    }

    public double sum2(DoubleVector doubleVector) {
        return this.minus(doubleVector).sum2();
    }

    public DoubleVector subvector(int n, int n2) {
        DoubleVector doubleVector = new DoubleVector(n2 - n + 1);
        doubleVector.set(0, n2 - n, this, n);
        return doubleVector;
    }

    public DoubleVector subvector(IntVector intVector) {
        DoubleVector doubleVector = new DoubleVector(intVector.size());
        for (int i = 0; i < intVector.size(); ++i) {
            doubleVector.V[i] = this.V[intVector.V[i]];
        }
        return doubleVector;
    }

    public DoubleVector unpivoting(IntVector intVector, int n) {
        if (intVector.size() > n) {
            throw new IllegalArgumentException("index.size() > length ");
        }
        DoubleVector doubleVector = new DoubleVector(n);
        for (int i = 0; i < intVector.size(); ++i) {
            doubleVector.V[intVector.V[i]] = this.V[i];
        }
        return doubleVector;
    }

    public DoubleVector plus(double d) {
        return this.copy().plusEquals(d);
    }

    public DoubleVector plusEquals(double d) {
        int n = 0;
        while (n < this.size()) {
            int n2 = n++;
            this.V[n2] = this.V[n2] + d;
        }
        return this;
    }

    public DoubleVector plus(DoubleVector doubleVector) {
        return this.copy().plusEquals(doubleVector);
    }

    public DoubleVector plusEquals(DoubleVector doubleVector) {
        for (int i = 0; i < this.size(); ++i) {
            int n = i;
            this.V[n] = this.V[n] + doubleVector.V[i];
        }
        return this;
    }

    public DoubleVector minus(double d) {
        return this.plus(-d);
    }

    public DoubleVector minusEquals(double d) {
        this.plusEquals(-d);
        return this;
    }

    public DoubleVector minus(DoubleVector doubleVector) {
        return this.copy().minusEquals(doubleVector);
    }

    public DoubleVector minusEquals(DoubleVector doubleVector) {
        for (int i = 0; i < this.size(); ++i) {
            int n = i;
            this.V[n] = this.V[n] - doubleVector.V[i];
        }
        return this;
    }

    public DoubleVector times(double d) {
        return this.copy().timesEquals(d);
    }

    public DoubleVector timesEquals(double d) {
        int n = 0;
        while (n < this.size()) {
            int n2 = n++;
            this.V[n2] = this.V[n2] * d;
        }
        return this;
    }

    public DoubleVector times(DoubleVector doubleVector) {
        return this.copy().timesEquals(doubleVector);
    }

    public DoubleVector timesEquals(DoubleVector doubleVector) {
        for (int i = 0; i < this.size(); ++i) {
            int n = i;
            this.V[n] = this.V[n] * doubleVector.V[i];
        }
        return this;
    }

    public DoubleVector dividedBy(DoubleVector doubleVector) {
        return this.copy().dividedByEquals(doubleVector);
    }

    public DoubleVector dividedByEquals(DoubleVector doubleVector) {
        for (int i = 0; i < this.size(); ++i) {
            int n = i;
            this.V[n] = this.V[n] / doubleVector.V[i];
        }
        return this;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public DoubleVector cumulate() {
        return this.copy().cumulateInPlace();
    }

    public DoubleVector cumulateInPlace() {
        for (int i = 1; i < this.size(); ++i) {
            int n = i;
            this.V[n] = this.V[n] + this.V[i - 1];
        }
        return this;
    }

    public int indexOfMax() {
        int n = 0;
        double d = this.V[0];
        for (int i = 1; i < this.size(); ++i) {
            if (!(d < this.V[i])) continue;
            d = this.V[i];
            n = i;
        }
        return n;
    }

    public boolean unsorted() {
        if (this.size() < 2) {
            return false;
        }
        for (int i = 1; i < this.size(); ++i) {
            if (!(this.V[i - 1] > this.V[i])) continue;
            return true;
        }
        return false;
    }

    public DoubleVector cat(DoubleVector doubleVector) {
        DoubleVector doubleVector2 = new DoubleVector(this.size() + doubleVector.size());
        doubleVector2.set(0, this.size() - 1, this, 0);
        doubleVector2.set(this.size(), this.size() + doubleVector.size() - 1, doubleVector, 0);
        return doubleVector2;
    }

    public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        double d = this.V[n];
        this.V[n] = this.V[n2];
        this.V[n2] = d;
    }

    public double max() {
        if (this.size() < 1) {
            throw new IllegalArgumentException("zero size");
        }
        double d = this.V[0];
        if (this.size() < 2) {
            return d;
        }
        for (int i = 1; i < this.size(); ++i) {
            if (!(this.V[i] > d)) continue;
            d = this.V[i];
        }
        return d;
    }

    public DoubleVector map(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Double.TYPE};
            Method method = clazz.getMethod(string2, classArray);
            DoubleVector doubleVector = new DoubleVector(this.size());
            Object[] objectArray = new Object[1];
            for (int i = 0; i < this.size(); ++i) {
                objectArray[0] = new Double(this.V[i]);
                doubleVector.set(i, Double.parseDouble(method.invoke(null, objectArray).toString()));
            }
            return doubleVector;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public DoubleVector rev() {
        int n = this.size();
        DoubleVector doubleVector = new DoubleVector(n);
        for (int i = 0; i < n; ++i) {
            doubleVector.V[i] = this.V[n - i - 1];
        }
        return doubleVector;
    }

    public static DoubleVector random(int n) {
        DoubleVector doubleVector = new DoubleVector(n);
        for (int i = 0; i < n; ++i) {
            doubleVector.V[i] = Math.random();
        }
        return doubleVector;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int n, boolean bl) {
        int n2;
        if (this.isEmpty()) {
            return "null vector";
        }
        StringBuffer stringBuffer = new StringBuffer();
        FlexibleDecimalFormat flexibleDecimalFormat = new FlexibleDecimalFormat(n, bl);
        flexibleDecimalFormat.grouping(true);
        for (n2 = 0; n2 < this.size(); ++n2) {
            flexibleDecimalFormat.update(this.V[n2]);
        }
        n2 = 0;
        int n3 = 80;
        for (int i = 0; i < this.size(); ++i) {
            String string = flexibleDecimalFormat.format(this.V[i]);
            if ((n2 += 1 + string.length()) > n3 - 1) {
                stringBuffer.append('\n');
                n2 = 1 + string.length();
            }
            stringBuffer.append(" " + string);
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] stringArray) {
        DoubleVector doubleVector;
        DoubleVector doubleVector2 = DoubleVector.random(10);
        DoubleVector doubleVector3 = DoubleVector.random(10);
        DoubleVector doubleVector4 = doubleVector = DoubleVector.random(10);
        System.out.println(DoubleVector.random(10).plus(doubleVector3).plus(doubleVector4));
    }
}

