/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventSetDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.gui.Logger;
import weka.gui.ResultHistoryPanel;
import weka.gui.SaveBuffer;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;

public class TextViewer
extends JPanel
implements TextListener,
DataSourceListener,
TrainingSetListener,
TestSetListener,
Visible,
UserRequestAcceptor,
BeanContextChild,
BeanCommon,
EventConstraints {
    private static final long serialVersionUID = 104838186352536832L;
    protected BeanVisual m_visual;
    private transient JFrame m_resultsFrame = null;
    private transient JTextArea m_outText = null;
    protected transient ResultHistoryPanel m_history;
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);
    private Vector m_textListeners = new Vector();
    private transient Logger m_log = null;

    public TextViewer() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!graphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        }
    }

    protected void appearanceDesign() {
        this.setUpResultHistory();
        this.removeAll();
        this.m_visual = new BeanVisual("TextViewer", "weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.setUpFinal();
    }

    protected void setUpFinal() {
        this.setUpResultHistory();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_outText);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Text"));
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.m_history, "West");
        this.add((Component)jPanel, "Center");
    }

    public String globalInfo() {
        return "General purpose text display.";
    }

    private void setUpResultHistory() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!graphicsEnvironment.isHeadless()) {
            if (this.m_outText == null) {
                this.m_outText = new JTextArea(20, 80);
                this.m_history = new ResultHistoryPanel(this.m_outText);
            }
            this.m_outText.setEditable(false);
            this.m_outText.setFont(new Font("Monospaced", 0, 12));
            this.m_outText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.m_history.setBorder(BorderFactory.createTitledBorder("Result list"));
            this.m_history.setHandleRightClicks(false);
            this.m_history.getList().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 0x10) != 16 || mouseEvent.isAltDown()) {
                        int n = TextViewer.this.m_history.getList().locationToIndex(mouseEvent.getPoint());
                        if (n != -1) {
                            String string = TextViewer.this.m_history.getNameAtIndex(n);
                            TextViewer.this.visualize(string, mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            TextViewer.this.visualize(null, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
            });
        }
    }

    protected void visualize(String string, int n, int n2) {
        final TextViewer textViewer = this;
        final String string2 = string;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("View in main window");
        if (string2 != null) {
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TextViewer.this.m_history.setSingle(string2);
                }
            });
        } else {
            jMenuItem.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("View in separate window");
        if (string2 != null) {
            jMenuItem2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TextViewer.this.m_history.openFrame(string2);
                }
            });
        } else {
            jMenuItem2.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Save result buffer");
        if (string2 != null) {
            jMenuItem3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SaveBuffer saveBuffer = new SaveBuffer(null, textViewer);
                    StringBuffer stringBuffer = TextViewer.this.m_history.getNamedBuffer(string2);
                    if (stringBuffer != null) {
                        saveBuffer.save(stringBuffer);
                    }
                }
            });
        } else {
            jMenuItem3.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Delete result buffer");
        if (string2 != null) {
            jMenuItem4.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TextViewer.this.m_history.removeResult(string2);
                }
            });
        } else {
            jMenuItem4.setEnabled(false);
        }
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.show(this.m_history.getList(), n, n2);
    }

    public synchronized void acceptDataSet(DataSetEvent dataSetEvent) {
        TextEvent textEvent = new TextEvent(dataSetEvent.getSource(), dataSetEvent.getDataSet().toString(), dataSetEvent.getDataSet().relationName());
        this.acceptText(textEvent);
    }

    public synchronized void acceptTrainingSet(TrainingSetEvent trainingSetEvent) {
        TextEvent textEvent = new TextEvent(trainingSetEvent.getSource(), trainingSetEvent.getTrainingSet().toString(), trainingSetEvent.getTrainingSet().relationName());
        this.acceptText(textEvent);
    }

    public synchronized void acceptTestSet(TestSetEvent testSetEvent) {
        TextEvent textEvent = new TextEvent(testSetEvent.getSource(), testSetEvent.getTestSet().toString(), testSetEvent.getTestSet().relationName());
        this.acceptText(textEvent);
    }

    public synchronized void acceptText(TextEvent textEvent) {
        if (this.m_outText == null) {
            this.setUpResultHistory();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(textEvent.getText());
        String string = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
        string = string + textEvent.getTextTitle();
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        if (this.m_outText != null) {
            int n = 2;
            String string2 = new String(string);
            while (this.m_history.getNamedBuffer(string) != null) {
                string = new String(string2 + "" + n);
                ++n;
            }
            this.m_history.addResult(string, stringBuffer);
            this.m_history.setSingle(string);
        }
        this.notifyTextListeners(textEvent);
    }

    public void setVisual(BeanVisual beanVisual) {
        this.m_visual = beanVisual;
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultText.gif", "weka/gui/beans/icons/DefaultText_animated.gif");
    }

    public void showResults() {
        if (this.m_resultsFrame == null) {
            if (this.m_outText == null) {
                this.setUpResultHistory();
            }
            this.m_resultsFrame = new JFrame("Text Viewer");
            this.m_resultsFrame.getContentPane().setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(this.m_outText);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Text"));
            this.m_resultsFrame.getContentPane().add((Component)jScrollPane, "Center");
            this.m_resultsFrame.getContentPane().add((Component)this.m_history, "West");
            this.m_resultsFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TextViewer.this.m_resultsFrame.dispose();
                    TextViewer.this.m_resultsFrame = null;
                }
            });
            this.m_resultsFrame.pack();
            this.m_resultsFrame.setVisible(true);
        } else {
            this.m_resultsFrame.toFront();
        }
    }

    public Enumeration enumerateRequests() {
        Vector<String> vector = new Vector<String>(0);
        vector.addElement("Show results");
        vector.addElement("Clear results");
        return vector.elements();
    }

    public void performRequest(String string) {
        if (string.compareTo("Show results") == 0) {
            this.showResults();
        } else if (string.compareTo("Clear results") == 0) {
            this.m_outText.setText("");
        } else {
            throw new IllegalArgumentException(string + " not supported (TextViewer)");
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.m_bcSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.addVetoableChangeListener(string, vetoableChangeListener);
    }

    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        this.m_bcSupport.removeVetoableChangeListener(string, vetoableChangeListener);
    }

    public void setBeanContext(BeanContext beanContext) {
        this.m_beanContext = beanContext;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!graphicsEnvironment.isHeadless()) {
                this.appearanceFinal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent textEvent) {
        Vector vector;
        TextViewer textViewer = this;
        synchronized (textViewer) {
            vector = (Vector)this.m_textListeners.clone();
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                ((TextListener)vector.elementAt(i)).acceptText(textEvent);
            }
        }
    }

    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public void stop() {
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    public void setCustomName(String string) {
        this.m_visual.setText(string);
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public boolean connectionAllowed(EventSetDescriptor eventSetDescriptor) {
        return this.connectionAllowed(eventSetDescriptor.getName());
    }

    public boolean connectionAllowed(String string) {
        return true;
    }

    public void connectionNotification(String string, Object object) {
    }

    public void disconnectionNotification(String string, Object object) {
    }

    public boolean eventGeneratable(String string) {
        return string.equals("text");
    }

    public synchronized void addTextListener(TextListener textListener) {
        this.m_textListeners.addElement(textListener);
    }

    public synchronized void removeTextListener(TextListener textListener) {
        this.m_textListeners.remove(textListener);
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            TextViewer textViewer = new TextViewer();
            textViewer.acceptText(new TextEvent(textViewer, "Here is some test text from the main method of this class.", "The Title"));
            jFrame.getContentPane().add((Component)textViewer, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.setSize(800, 600);
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

