/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.functions.LinearRegression;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Debug;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MathematicalExpression;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PropertyPath;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.Summarizable;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;
import weka.filters.unsupervised.attribute.NumericCleaner;
import weka.filters.unsupervised.instance.Resample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridSearch
extends RandomizableSingleClassifierEnhancer
implements AdditionalMeasureProducer,
Summarizable {
    private static final long serialVersionUID = -3034773968581595348L;
    public static final int EVALUATION_CC = 0;
    public static final int EVALUATION_RMSE = 1;
    public static final int EVALUATION_RRSE = 2;
    public static final int EVALUATION_MAE = 3;
    public static final int EVALUATION_RAE = 4;
    public static final int EVALUATION_COMBINED = 5;
    public static final int EVALUATION_ACC = 6;
    public static final Tag[] TAGS_EVALUATION = new Tag[]{new Tag(0, "CC", "Correlation coefficient"), new Tag(1, "RMSE", "Root mean squared error"), new Tag(2, "RRSE", "Root relative squared error"), new Tag(3, "MAE", "Mean absolute error"), new Tag(4, "RAE", "Root absolute error"), new Tag(5, "COMB", "Combined = (1-abs(CC)) + RRSE + RAE"), new Tag(6, "ACC", "Accuracy")};
    public static final int TRAVERSAL_BY_ROW = 0;
    public static final int TRAVERSAL_BY_COLUMN = 1;
    public static final Tag[] TAGS_TRAVERSAL = new Tag[]{new Tag(0, "row-wise", "row-wise"), new Tag(1, "column-wise", "column-wise")};
    public static final String PREFIX_CLASSIFIER = "classifier.";
    public static final String PREFIX_FILTER = "filter.";
    protected Filter m_Filter;
    protected Filter m_BestFilter;
    protected Classifier m_BestClassifier;
    protected PointDouble m_Values = null;
    protected int m_Evaluation = 0;
    protected String m_Y_Property = "classifier.ridge";
    protected double m_Y_Min = -10.0;
    protected double m_Y_Max = 5.0;
    protected double m_Y_Step = 1.0;
    protected double m_Y_Base = 10.0;
    protected String m_Y_Expression = "pow(BASE,I)";
    protected String m_X_Property = "filter.numComponents";
    protected double m_X_Min = 5.0;
    protected double m_X_Max = 20.0;
    protected double m_X_Step = 1.0;
    protected double m_X_Base = 10.0;
    protected String m_X_Expression = "I";
    protected boolean m_GridIsExtendable = false;
    protected int m_MaxGridExtensions = 3;
    protected int m_GridExtensionsPerformed = 0;
    protected double m_SampleSize = 100.0;
    protected int m_Traversal = 1;
    protected File m_LogFile = new File(System.getProperty("user.dir"));
    protected Grid m_Grid;
    protected Instances m_Data;
    protected PerformanceCache m_Cache;
    protected boolean m_UniformPerformance = false;

    public GridSearch() {
        this.m_Classifier = new LinearRegression();
        ((LinearRegression)this.m_Classifier).setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        ((LinearRegression)this.m_Classifier).setEliminateColinearAttributes(false);
        this.m_Filter = new PLSFilter();
        PLSFilter pLSFilter = new PLSFilter();
        pLSFilter.setPreprocessing(new SelectedTag(2, PLSFilter.TAGS_PREPROCESSING));
        pLSFilter.setReplaceMissing(true);
        try {
            this.m_BestClassifier = Classifier.makeCopy(this.m_Classifier);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.m_BestFilter = Filter.makeCopy(pLSFilter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String globalInfo() {
        return "Performs a grid search of parameter pairs for the a classifier (Y-axis, default is LinearRegression with the \"Ridge\" parameter) and the PLSFilter (X-axis, \"# of Components\") and chooses the best pair found for the actual predicting.\n\nThe initial grid is worked on with 2-fold CV to determine the values of the parameter pairs for the selected type of evaluation (e.g., accuracy). The best point in the grid is then taken and a 10-fold CV is performed with the adjacent parameter pairs. If a better pair is found, then this will act as new center and another 10-fold CV will be performed (kind of hill-climbing). This process is repeated until no better pair is found or the best pair is on the border of the grid.\nIn case the best pair is on the border, one can let GridSearch automatically extend the grid and continue the search. Check out the properties 'gridIsExtendable' (option '-extend-grid') and 'maxGridExtensions' (option '-max-grid-extensions <num>').\n\nGridSearch can handle doubles, integers (values are just cast to int) and booleans (0 is false, otherwise true). float, char and long are supported as well.\n\nThe best filter/classifier setup can be accessed after the buildClassifier call via the getBestFilter/getBestClassifier methods.\nNote on the implementation: after the data has been passed through the filter, a default NumericCleaner filter is applied to the data in order to avoid numbers that are getting too small and might produce NaNs in other schemes.";
    }

    @Override
    protected String defaultClassifierString() {
        return LinearRegression.class.getName();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        String string = "";
        for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
            SelectedTag selectedTag = new SelectedTag(TAGS_EVALUATION[i].getID(), TAGS_EVALUATION);
            string = string + "\t" + selectedTag.getSelectedTag().getIDStr() + " = " + selectedTag.getSelectedTag().getReadable() + "\n";
        }
        vector.addElement(new Option("\tDetermines the parameter used for evaluation:\n" + string + "\t(default: " + new SelectedTag(0, TAGS_EVALUATION) + ")", "E", 1, "-E " + Tag.toOptionList(TAGS_EVALUATION)));
        vector.addElement(new Option("\tThe Y option to test (without leading dash).\n\t(default: classifier.ridge)", "y-property", 1, "-y-property <option>"));
        vector.addElement(new Option("\tThe minimum for Y.\n\t(default: -10)", "y-min", 1, "-y-min <num>"));
        vector.addElement(new Option("\tThe maximum for Y.\n\t(default: +5)", "y-max", 1, "-y-max <num>"));
        vector.addElement(new Option("\tThe step size for Y.\n\t(default: 1)", "y-step", 1, "-y-step <num>"));
        vector.addElement(new Option("\tThe base for Y.\n\t(default: 10)", "y-base", 1, "-y-base <num>"));
        vector.addElement(new Option("\tThe expression for Y.\n\tAvailable parameters:\n\t\tBASE\n\t\tFROM\n\t\tTO\n\t\tSTEP\n\t\tI - the current iteration value\n\t\t(from 'FROM' to 'TO' with stepsize 'STEP')\n\t(default: 'pow(BASE,I)')", "y-expression", 1, "-y-expression <expr>"));
        vector.addElement(new Option("\tThe filter to use (on X axis). Full classname of filter to include, \n\tfollowed by scheme options.\n\t(default: weka.filters.supervised.attribute.PLSFilter)", "filter", 1, "-filter <filter specification>"));
        vector.addElement(new Option("\tThe X option to test (without leading dash).\n\t(default: filter.numComponents)", "x-property", 1, "-x-property <option>"));
        vector.addElement(new Option("\tThe minimum for X.\n\t(default: +5)", "x-min", 1, "-x-min <num>"));
        vector.addElement(new Option("\tThe maximum for X.\n\t(default: +20)", "x-max", 1, "-x-max <num>"));
        vector.addElement(new Option("\tThe step size for X.\n\t(default: 1)", "x-step", 1, "-x-step <num>"));
        vector.addElement(new Option("\tThe base for X.\n\t(default: 10)", "x-base", 1, "-x-base <num>"));
        vector.addElement(new Option("\tThe expression for the X value.\n\tAvailable parameters:\n\t\tBASE\n\t\tMIN\n\t\tMAX\n\t\tSTEP\n\t\tI - the current iteration value\n\t\t(from 'FROM' to 'TO' with stepsize 'STEP')\n\t(default: 'pow(BASE,I)')", "x-expression", 1, "-x-expression <expr>"));
        vector.addElement(new Option("\tWhether the grid can be extended.\n\t(default: no)", "extend-grid", 0, "-extend-grid"));
        vector.addElement(new Option("\tThe maximum number of grid extensions (-1 is unlimited).\n\t(default: 3)", "max-grid-extensions", 1, "-max-grid-extensions <num>"));
        vector.addElement(new Option("\tThe size (in percent) of the sample to search the inital grid with.\n\t(default: 100)", "sample-size", 1, "-sample-size <num>"));
        vector.addElement(new Option("\tThe type of traversal for the grid.\n\t(default: " + new SelectedTag(1, TAGS_TRAVERSAL) + ")", "traversal", 1, "-traversal " + Tag.toOptionList(TAGS_TRAVERSAL)));
        vector.addElement(new Option("\tThe log file to log the messages to.\n\t(default: none)", "log-file", 1, "-log-file <filename>"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        if (this.getFilter() instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to filter " + this.getFilter().getClass().getName() + " ('-filter'):"));
            enumeration = ((OptionHandler)((Object)this.getFilter())).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-E");
        vector.add("" + this.getEvaluation());
        vector.add("-y-property");
        vector.add("" + this.getYProperty());
        vector.add("-y-min");
        vector.add("" + this.getYMin());
        vector.add("-y-max");
        vector.add("" + this.getYMax());
        vector.add("-y-step");
        vector.add("" + this.getYStep());
        vector.add("-y-base");
        vector.add("" + this.getYBase());
        vector.add("-y-expression");
        vector.add("" + this.getYExpression());
        vector.add("-filter");
        if (this.getFilter() instanceof OptionHandler) {
            vector.add(this.getFilter().getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()));
        } else {
            vector.add(this.getFilter().getClass().getName());
        }
        vector.add("-x-property");
        vector.add("" + this.getXProperty());
        vector.add("-x-min");
        vector.add("" + this.getXMin());
        vector.add("-x-max");
        vector.add("" + this.getXMax());
        vector.add("-x-step");
        vector.add("" + this.getXStep());
        vector.add("-x-base");
        vector.add("" + this.getXBase());
        vector.add("-x-expression");
        vector.add("" + this.getXExpression());
        if (this.getGridIsExtendable()) {
            vector.add("-extend-grid");
            vector.add("-max-grid-extensions");
            vector.add("" + this.getMaxGridExtensions());
        }
        vector.add("-sample-size");
        vector.add("" + this.getSampleSizePercent());
        vector.add("-traversal");
        vector.add("" + this.getTraversal());
        vector.add("-log-file");
        vector.add("" + this.getLogFile());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    @Override
    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setEvaluation(new SelectedTag(string, TAGS_EVALUATION));
        } else {
            this.setEvaluation(new SelectedTag(0, TAGS_EVALUATION));
        }
        string = Utils.getOption("y-property", stringArray);
        if (string.length() != 0) {
            this.setYProperty(string);
        } else {
            this.setYProperty("classifier.ridge");
        }
        string = Utils.getOption("y-min", stringArray);
        if (string.length() != 0) {
            this.setYMin(Double.parseDouble(string));
        } else {
            this.setYMin(-10.0);
        }
        string = Utils.getOption("y-max", stringArray);
        if (string.length() != 0) {
            this.setYMax(Double.parseDouble(string));
        } else {
            this.setYMax(10.0);
        }
        string = Utils.getOption("y-step", stringArray);
        if (string.length() != 0) {
            this.setYStep(Double.parseDouble(string));
        } else {
            this.setYStep(1.0);
        }
        string = Utils.getOption("y-base", stringArray);
        if (string.length() != 0) {
            this.setYBase(Double.parseDouble(string));
        } else {
            this.setYBase(10.0);
        }
        string = Utils.getOption("y-expression", stringArray);
        if (string.length() != 0) {
            this.setYExpression(string);
        } else {
            this.setYExpression("pow(BASE,I)");
        }
        string = Utils.getOption("filter", stringArray);
        String[] stringArray2 = Utils.splitOptions(string);
        if (stringArray2.length != 0) {
            string = stringArray2[0];
            stringArray2[0] = "";
            this.setFilter((Filter)Utils.forName(Filter.class, string, stringArray2));
        }
        if ((string = Utils.getOption("x-property", stringArray)).length() != 0) {
            this.setXProperty(string);
        } else {
            this.setXProperty("filter.filters[0].kernel.gamma");
        }
        string = Utils.getOption("x-min", stringArray);
        if (string.length() != 0) {
            this.setXMin(Double.parseDouble(string));
        } else {
            this.setXMin(-10.0);
        }
        string = Utils.getOption("x-max", stringArray);
        if (string.length() != 0) {
            this.setXMax(Double.parseDouble(string));
        } else {
            this.setXMax(10.0);
        }
        string = Utils.getOption("x-step", stringArray);
        if (string.length() != 0) {
            this.setXStep(Double.parseDouble(string));
        } else {
            this.setXStep(1.0);
        }
        string = Utils.getOption("x-base", stringArray);
        if (string.length() != 0) {
            this.setXBase(Double.parseDouble(string));
        } else {
            this.setXBase(10.0);
        }
        string = Utils.getOption("x-expression", stringArray);
        if (string.length() != 0) {
            this.setXExpression(string);
        } else {
            this.setXExpression("pow(BASE,I)");
        }
        this.setGridIsExtendable(Utils.getFlag("extend-grid", stringArray));
        if (this.getGridIsExtendable()) {
            string = Utils.getOption("max-grid-extensions", stringArray);
            if (string.length() != 0) {
                this.setMaxGridExtensions(Integer.parseInt(string));
            } else {
                this.setMaxGridExtensions(3);
            }
        }
        if ((string = Utils.getOption("sample-size", stringArray)).length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(string));
        } else {
            this.setSampleSizePercent(100.0);
        }
        string = Utils.getOption("traversal", stringArray);
        if (string.length() != 0) {
            this.setTraversal(new SelectedTag(string, TAGS_TRAVERSAL));
        } else {
            this.setTraversal(new SelectedTag(0, TAGS_TRAVERSAL));
        }
        string = Utils.getOption("log-file", stringArray);
        if (string.length() != 0) {
            this.setLogFile(new File(string));
        } else {
            this.setLogFile(new File(System.getProperty("user.dir")));
        }
        super.setOptions(stringArray);
    }

    @Override
    public void setClassifier(Classifier classifier) {
        boolean bl;
        Capabilities capabilities = classifier.getCapabilities();
        boolean bl2 = capabilities.handles(Capabilities.Capability.NUMERIC_CLASS) || capabilities.hasDependency(Capabilities.Capability.NUMERIC_CLASS);
        boolean bl3 = bl = capabilities.handles(Capabilities.Capability.NOMINAL_CLASS) || capabilities.hasDependency(Capabilities.Capability.NOMINAL_CLASS) || capabilities.handles(Capabilities.Capability.BINARY_CLASS) || capabilities.hasDependency(Capabilities.Capability.BINARY_CLASS) || capabilities.handles(Capabilities.Capability.UNARY_CLASS) || capabilities.hasDependency(Capabilities.Capability.UNARY_CLASS);
        if (this.m_Evaluation == 0 && !bl2) {
            throw new IllegalArgumentException("Classifier needs to handle numeric class for chosen type of evaluation!");
        }
        if (this.m_Evaluation == 6 && !bl) {
            throw new IllegalArgumentException("Classifier needs to handle nominal class for chosen type of evaluation!");
        }
        super.setClassifier(classifier);
        try {
            this.m_BestClassifier = Classifier.makeCopy(this.m_Classifier);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String filterTipText() {
        return "The filter to be used (only used for setup).";
    }

    public void setFilter(Filter filter) {
        this.m_Filter = filter;
        try {
            this.m_BestFilter = Filter.makeCopy(this.m_Filter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Filter getFilter() {
        return this.m_Filter;
    }

    public String evaluationTipText() {
        return "Sets the criterion for evaluating the classifier performance and choosing the best one.";
    }

    public void setEvaluation(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_EVALUATION) {
            this.m_Evaluation = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getEvaluation() {
        return new SelectedTag(this.m_Evaluation, TAGS_EVALUATION);
    }

    public String YPropertyTipText() {
        return "The Y property to test (normally the classifier).";
    }

    public String getYProperty() {
        return this.m_Y_Property;
    }

    public void setYProperty(String string) {
        this.m_Y_Property = string;
    }

    public String YMinTipText() {
        return "The minimum of Y (normally the classifier).";
    }

    public double getYMin() {
        return this.m_Y_Min;
    }

    public void setYMin(double d) {
        this.m_Y_Min = d;
    }

    public String YMaxTipText() {
        return "The maximum of Y.";
    }

    public double getYMax() {
        return this.m_Y_Max;
    }

    public void setYMax(double d) {
        this.m_Y_Max = d;
    }

    public String YStepTipText() {
        return "The step size of Y.";
    }

    public double getYStep() {
        return this.m_Y_Step;
    }

    public void setYStep(double d) {
        this.m_Y_Step = d;
    }

    public String YBaseTipText() {
        return "The base of Y.";
    }

    public double getYBase() {
        return this.m_Y_Base;
    }

    public void setYBase(double d) {
        this.m_Y_Base = d;
    }

    public String YExpressionTipText() {
        return "The expression for the Y value (parameters: BASE, FROM, TO, STEP, I).";
    }

    public String getYExpression() {
        return this.m_Y_Expression;
    }

    public void setYExpression(String string) {
        this.m_Y_Expression = string;
    }

    public String XPropertyTipText() {
        return "The X property to test (normally the filter).";
    }

    public String getXProperty() {
        return this.m_X_Property;
    }

    public void setXProperty(String string) {
        this.m_X_Property = string;
    }

    public String XMinTipText() {
        return "The minimum of X.";
    }

    public double getXMin() {
        return this.m_X_Min;
    }

    public void setXMin(double d) {
        this.m_X_Min = d;
    }

    public String XMaxTipText() {
        return "The maximum of X.";
    }

    public double getXMax() {
        return this.m_X_Max;
    }

    public void setXMax(double d) {
        this.m_X_Max = d;
    }

    public String XStepTipText() {
        return "The step size of X.";
    }

    public double getXStep() {
        return this.m_X_Step;
    }

    public void setXStep(double d) {
        this.m_X_Step = d;
    }

    public String XBaseTipText() {
        return "The base of X.";
    }

    public double getXBase() {
        return this.m_X_Base;
    }

    public void setXBase(double d) {
        this.m_X_Base = d;
    }

    public String XExpressionTipText() {
        return "The expression for the X value (parameters: BASE, FROM, TO, STEP, I).";
    }

    public String getXExpression() {
        return this.m_X_Expression;
    }

    public void setXExpression(String string) {
        this.m_X_Expression = string;
    }

    public String gridIsExtendableTipText() {
        return "Whether the grid can be extended.";
    }

    public boolean getGridIsExtendable() {
        return this.m_GridIsExtendable;
    }

    public void setGridIsExtendable(boolean bl) {
        this.m_GridIsExtendable = bl;
    }

    public String maxGridExtensionsTipText() {
        return "The maximum number of grid extensions, -1 for unlimited.";
    }

    public int getMaxGridExtensions() {
        return this.m_MaxGridExtensions;
    }

    public void setMaxGridExtensions(int n) {
        this.m_MaxGridExtensions = n;
    }

    public String sampleSizePercentTipText() {
        return "The sample size (in percent) to use in the initial grid search.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSize;
    }

    public void setSampleSizePercent(double d) {
        this.m_SampleSize = d;
    }

    public String traversalTipText() {
        return "Sets type of traversal of the grid, either by rows or columns.";
    }

    public void setTraversal(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_TRAVERSAL) {
            this.m_Traversal = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getTraversal() {
        return new SelectedTag(this.m_Traversal, TAGS_TRAVERSAL);
    }

    public String logFileTipText() {
        return "The log file to log the messages to.";
    }

    public File getLogFile() {
        return this.m_LogFile;
    }

    public void setLogFile(File file) {
        this.m_LogFile = file;
    }

    public Filter getBestFilter() {
        return this.m_BestFilter;
    }

    public Classifier getBestClassifier() {
        return this.m_BestClassifier;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        vector.add("measureX");
        vector.add("measureY");
        vector.add("measureGridExtensionsPerformed");
        return vector.elements();
    }

    @Override
    public double getMeasure(String string) {
        if (string.equalsIgnoreCase("measureX")) {
            return this.evaluate(this.getValues().getX(), true);
        }
        if (string.equalsIgnoreCase("measureY")) {
            return this.evaluate(this.getValues().getY(), false);
        }
        if (string.equalsIgnoreCase("measureGridExtensionsPerformed")) {
            return this.getGridExtensionsPerformed();
        }
        throw new IllegalArgumentException("Measure '" + string + "' not supported!");
    }

    public PointDouble getValues() {
        return this.m_Values;
    }

    public int getGridExtensionsPerformed() {
        return this.m_GridExtensionsPerformed;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getFilter() == null ? super.getCapabilities() : this.getFilter().getCapabilities();
        Capabilities capabilities2 = capabilities.getClassCapabilities();
        Iterator iterator = capabilities2.capabilities();
        while (iterator.hasNext()) {
            Capabilities.Capability capability = (Capabilities.Capability)((Object)iterator.next());
            if (capability == Capabilities.Capability.BINARY_CLASS || capability == Capabilities.Capability.NOMINAL_CLASS || capability == Capabilities.Capability.NUMERIC_CLASS || capability == Capabilities.Capability.DATE_CLASS) continue;
            capabilities.disable(capability);
        }
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        if (capabilities.getMinimumNumberInstances() < 1) {
            capabilities.setMinimumNumberInstances(1);
        }
        capabilities.setOwner(this);
        return capabilities;
    }

    protected void log(String string) {
        this.log(string, false);
    }

    protected void log(String string, boolean bl) {
        if (this.getDebug() && !bl) {
            System.out.println(string);
        }
        if (!this.getLogFile().isDirectory()) {
            Debug.writeToFile(this.getLogFile().getAbsolutePath(), string, true);
        }
    }

    protected String[] updateOption(String[] stringArray, String string, String string2) throws Exception {
        Utils.getOption(string, stringArray);
        Vector<String> vector = new Vector<String>();
        vector.add("-" + string);
        vector.add("" + string2);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() == 0) continue;
            vector.add(stringArray[i]);
        }
        String[] stringArray2 = vector.toArray(new String[vector.size()]);
        return stringArray2;
    }

    protected double evaluate(double d, boolean bl) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        String string;
        if (bl) {
            string = this.getXExpression();
            d6 = this.getXBase();
            d5 = this.getXMin();
            d4 = this.getXMax();
            d3 = this.getXStep();
        } else {
            string = this.getYExpression();
            d6 = this.getYBase();
            d5 = this.getYMin();
            d4 = this.getYMax();
            d3 = this.getYStep();
        }
        try {
            HashMap<String, Double> hashMap = new HashMap<String, Double>();
            hashMap.put("BASE", new Double(d6));
            hashMap.put("FROM", new Double(d5));
            hashMap.put("TO", new Double(d4));
            hashMap.put("STEP", new Double(d3));
            hashMap.put("I", new Double(d));
            d2 = MathematicalExpression.evaluate(string, hashMap);
        }
        catch (Exception exception) {
            d2 = Double.NaN;
        }
        return d2;
    }

    protected Object setValue(Object object, String string, double d) throws Exception {
        PropertyDescriptor propertyDescriptor = PropertyPath.getPropertyDescriptor(object, string);
        Class<?> clazz = propertyDescriptor.getPropertyType();
        if (clazz == Float.class || clazz == Float.TYPE) {
            PropertyPath.setValue(object, string, (Object)new Float((float)d));
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            PropertyPath.setValue(object, string, (Object)new Double(d));
        } else if (clazz == Character.class || clazz == Character.TYPE) {
            PropertyPath.setValue(object, string, (Object)new Integer((char)d));
        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
            PropertyPath.setValue(object, string, (Object)new Integer((int)d));
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            PropertyPath.setValue(object, string, (Object)new Long((long)d));
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            PropertyPath.setValue(object, string, (Object)(d == 0.0 ? new Boolean(false) : new Boolean(true)));
        } else {
            throw new Exception("Could neither set double nor integer nor boolean value for '" + string + "'!");
        }
        return object;
    }

    protected Object setup(Object object, double d, double d2) throws Exception {
        Object object2 = new SerializedObject(object).getObject();
        if (object instanceof Classifier) {
            if (this.getXProperty().startsWith(PREFIX_CLASSIFIER)) {
                this.setValue(object2, this.getXProperty().substring(PREFIX_CLASSIFIER.length()), d);
            }
            if (this.getYProperty().startsWith(PREFIX_CLASSIFIER)) {
                this.setValue(object2, this.getYProperty().substring(PREFIX_CLASSIFIER.length()), d2);
            }
        } else if (object instanceof Filter) {
            if (this.getXProperty().startsWith(PREFIX_FILTER)) {
                this.setValue(object2, this.getXProperty().substring(PREFIX_FILTER.length()), d);
            }
            if (this.getYProperty().startsWith(PREFIX_FILTER)) {
                this.setValue(object2, this.getYProperty().substring(PREFIX_FILTER.length()), d2);
            }
        } else {
            throw new IllegalArgumentException("Object must be either classifier or filter!");
        }
        return object2;
    }

    protected String logPerformances(Grid grid, Vector<Performance> vector, Tag tag) {
        StringBuffer stringBuffer = new StringBuffer(tag.getReadable() + ":\n");
        PerformanceTable performanceTable = new PerformanceTable(grid, vector, tag.getID());
        stringBuffer.append(performanceTable.toString() + "\n");
        stringBuffer.append("\n");
        stringBuffer.append(performanceTable.toGnuplot() + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected void logPerformances(Grid grid, Vector vector) {
        for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
            this.log("\n" + this.logPerformances(grid, vector, TAGS_EVALUATION[i]), true);
        }
    }

    protected PointDouble determineBestInGrid(Grid grid, Instances instances, int n) throws Exception {
        int n2;
        Vector<Performance> vector = new Vector<Performance>();
        this.log("Determining best pair with " + n + "-fold CV in Grid:\n" + grid + "\n");
        int n3 = this.m_Traversal == 1 ? grid.width() : grid.height();
        boolean bl = true;
        for (n2 = 0; n2 < n3; ++n2) {
            Enumeration<PointDouble> enumeration = this.m_Traversal == 1 ? grid.column(n2) : grid.row(n2);
            Filter filter = null;
            Instances instances2 = null;
            while (enumeration.hasMoreElements()) {
                PointDouble pointDouble = enumeration.nextElement();
                boolean bl2 = this.m_Cache.isCached(n, pointDouble);
                if (bl2) {
                    vector.add(this.m_Cache.get(n, pointDouble));
                } else {
                    bl = false;
                    double d = this.evaluate(pointDouble.getX(), true);
                    double d2 = this.evaluate(pointDouble.getY(), false);
                    if (filter == null) {
                        filter = (Filter)this.setup(this.getFilter(), d, d2);
                        filter.setInputFormat(instances);
                        instances2 = Filter.useFilter(instances, filter);
                        NumericCleaner numericCleaner = new NumericCleaner();
                        ((Filter)numericCleaner).setInputFormat(instances2);
                        instances2 = Filter.useFilter(instances2, numericCleaner);
                    }
                    Classifier classifier = (Classifier)this.setup(this.getClassifier(), d, d2);
                    Evaluation evaluation = new Evaluation(instances2);
                    evaluation.crossValidateModel(classifier, instances2, n, new Random(this.getSeed()));
                    vector.add(new Performance(pointDouble, evaluation));
                    this.m_Cache.add(n, new Performance(pointDouble, evaluation));
                }
                this.log("" + vector.get(vector.size() - 1) + ": cached=" + bl2);
            }
        }
        if (bl) {
            this.log("All points were already cached - abnormal state!");
            throw new IllegalStateException("All points were already cached - abnormal state!");
        }
        Collections.sort(vector, new PerformanceComparator(this.m_Evaluation));
        PointDouble pointDouble = ((Performance)vector.get(vector.size() - 1)).getValues();
        this.m_UniformPerformance = true;
        Performance performance = (Performance)vector.get(0);
        for (n2 = 1; n2 < vector.size(); ++n2) {
            Performance performance2 = (Performance)vector.get(n2);
            if (performance2.getPerformance(this.m_Evaluation) == performance.getPerformance(this.m_Evaluation)) continue;
            this.m_UniformPerformance = false;
            break;
        }
        if (this.m_UniformPerformance) {
            this.log("All performances are the same!");
        }
        this.logPerformances(grid, vector);
        this.log("\nBest performance:\n" + vector.get(vector.size() - 1));
        return pointDouble;
    }

    protected PointDouble findBest() throws Exception {
        Instances instances;
        this.log("Step 1:\n");
        if (this.getSampleSizePercent() == 100.0) {
            instances = this.m_Data;
        } else {
            this.log("Generating sample (" + this.getSampleSizePercent() + "%)");
            Resample resample = new Resample();
            resample.setRandomSeed(this.getSeed());
            resample.setSampleSizePercent(this.getSampleSizePercent());
            resample.setInputFormat(this.m_Data);
            instances = Filter.useFilter(this.m_Data, resample);
        }
        boolean bl = false;
        int n = 0;
        this.m_GridExtensionsPerformed = 0;
        this.m_UniformPerformance = false;
        this.log("\n=== Initial grid - Start ===");
        PointDouble pointDouble = this.determineBestInGrid(this.m_Grid, instances, 2);
        this.log("\nResult of Step 1: " + pointDouble + "\n");
        this.log("=== Initial grid - End ===\n");
        bl = this.m_UniformPerformance;
        if (!bl) {
            do {
                ++n;
                PointDouble pointDouble2 = (PointDouble)pointDouble.clone();
                PointInt pointInt = this.m_Grid.getLocation(pointDouble);
                if (this.m_Grid.isOnBorder(pointInt)) {
                    this.log("Center is on border of grid.");
                    if (this.getGridIsExtendable()) {
                        if (this.m_GridExtensionsPerformed == this.getMaxGridExtensions()) {
                            this.log("Maximum number of extensions reached!\n");
                            bl = true;
                        } else {
                            ++this.m_GridExtensionsPerformed;
                            this.m_Grid = this.m_Grid.extend(pointDouble);
                            pointInt = this.m_Grid.getLocation(pointDouble);
                            this.log("Extending grid (" + this.m_GridExtensionsPerformed + "/" + this.getMaxGridExtensions() + "):\n" + this.m_Grid + "\n");
                        }
                    } else {
                        bl = true;
                    }
                }
                if (bl) continue;
                Grid grid = this.m_Grid.subgrid((int)pointInt.getY() + 1, (int)pointInt.getX() - 1, (int)pointInt.getY() - 1, (int)pointInt.getX() + 1);
                pointDouble = this.determineBestInGrid(grid, instances, 10);
                this.log("\nResult of Step 2/Iteration " + n + ":\n" + pointDouble);
                bl = this.m_UniformPerformance;
                if (!pointDouble.equals(pointDouble2)) continue;
                bl = true;
                this.log("\nNo better point found.");
            } while (!bl);
        }
        this.log("\nFinal result: " + pointDouble);
        return pointDouble;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_Data = new Instances(instances);
        this.m_Data.deleteWithMissingClass();
        this.m_Cache = new PerformanceCache();
        String string = this.getXProperty().startsWith(PREFIX_FILTER) ? this.m_Filter.getClass().getName() : this.m_Classifier.getClass().getName();
        String string2 = this.getYProperty().startsWith(PREFIX_CLASSIFIER) ? this.m_Classifier.getClass().getName() : this.m_Filter.getClass().getName();
        this.m_Grid = new Grid(this.getXMin(), this.getXMax(), this.getXStep(), string + ", property " + this.getXProperty() + ", expr. " + this.getXExpression() + ", base " + this.getXBase(), this.getYMin(), this.getYMax(), this.getYStep(), string2 + ", property " + this.getYProperty() + ", expr. " + this.getYExpression() + ", base " + this.getYBase());
        this.log("\n" + this.getClass().getName() + "\n" + this.getClass().getName().replaceAll(".", "=") + "\n" + "Options: " + Utils.joinOptions(this.getOptions()) + "\n");
        this.m_Values = this.findBest();
        double d = this.evaluate(this.m_Values.getX(), true);
        double d2 = this.evaluate(this.m_Values.getY(), false);
        this.m_BestFilter = (Filter)this.setup(this.getFilter(), d, d2);
        this.m_BestClassifier = (Classifier)this.setup(this.getClassifier(), d, d2);
        this.m_Filter = (Filter)this.setup(this.getFilter(), d, d2);
        this.m_Filter.setInputFormat(this.m_Data);
        Instances instances2 = Filter.useFilter(this.m_Data, this.m_Filter);
        this.m_Classifier = (Classifier)this.setup(this.getClassifier(), d, d2);
        this.m_Classifier.buildClassifier(instances2);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        this.m_Filter.input(instance);
        this.m_Filter.batchFinished();
        Instance instance2 = this.m_Filter.output();
        return this.m_Classifier.classifyInstance(instance2);
    }

    public String toString() {
        String string = "";
        if (this.m_Values == null) {
            string = "No search performed yet.";
        } else {
            string = this.getClass().getName() + ":\n" + "Filter: " + this.getFilter().getClass().getName() + (this.getFilter() instanceof OptionHandler ? " " + Utils.joinOptions(((OptionHandler)((Object)this.getFilter())).getOptions()) : "") + "\n" + "Classifier: " + this.getClassifier().getClass().getName() + " " + Utils.joinOptions(this.getClassifier().getOptions()) + "\n\n" + "X property: " + this.getXProperty() + "\n" + "Y property: " + this.getYProperty() + "\n\n" + "Evaluation: " + this.getEvaluation().getSelectedTag().getReadable() + "\n" + "Coordinates: " + this.getValues() + "\n";
            if (this.getGridIsExtendable()) {
                string = string + "Grid-Extensions: " + this.getGridExtensionsPerformed() + "\n";
            }
            string = string + "Values: " + this.evaluate(this.getValues().getX(), true) + " (X coordinate)" + ", " + this.evaluate(this.getValues().getY(), false) + " (Y coordinate)" + "\n\n" + this.m_Classifier.toString();
        }
        return string;
    }

    @Override
    public String toSummaryString() {
        String string = "Best filter: " + this.getBestFilter().getClass().getName() + (this.getBestFilter() instanceof OptionHandler ? " " + Utils.joinOptions(((OptionHandler)((Object)this.getBestFilter())).getOptions()) : "") + "\n" + "Best classifier: " + this.getBestClassifier().getClass().getName() + " " + Utils.joinOptions(this.getBestClassifier().getOptions());
        return string;
    }

    public static void main(String[] stringArray) {
        GridSearch.runClassifier(new GridSearch(), stringArray);
    }

    protected class PerformanceCache
    implements Serializable {
        private static final long serialVersionUID = 5838863230451530252L;
        protected Hashtable m_Cache = new Hashtable();

        protected PerformanceCache() {
        }

        protected String getID(int n, PointDouble pointDouble) {
            return n + "\t" + pointDouble.getX() + "\t" + pointDouble.getY();
        }

        public boolean isCached(int n, PointDouble pointDouble) {
            return this.get(n, pointDouble) != null;
        }

        public Performance get(int n, PointDouble pointDouble) {
            return (Performance)this.m_Cache.get(this.getID(n, pointDouble));
        }

        public void add(int n, Performance performance) {
            this.m_Cache.put(this.getID(n, performance.getValues()), performance);
        }

        public String toString() {
            return this.m_Cache.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PerformanceTable
    implements Serializable {
        private static final long serialVersionUID = 5486491313460338379L;
        protected Grid m_Grid;
        protected Vector<Performance> m_Performances;
        protected int m_Type;
        protected double[][] m_Table;
        protected double m_Min;
        protected double m_Max;

        public PerformanceTable(Grid grid, Vector<Performance> vector, int n) {
            this.m_Grid = grid;
            this.m_Type = n;
            this.m_Performances = vector;
            this.generate();
        }

        protected void generate() {
            this.m_Table = new double[this.getGrid().height()][this.getGrid().width()];
            this.m_Min = 0.0;
            this.m_Max = 0.0;
            for (int i = 0; i < this.getPerformances().size(); ++i) {
                Performance performance = this.getPerformances().get(i);
                PointInt pointInt = this.getGrid().getLocation(performance.getValues());
                this.m_Table[this.getGrid().height() - (int)pointInt.getY() - 1][(int)pointInt.getX()] = performance.getPerformance(this.getType());
                if (i == 0) {
                    this.m_Max = this.m_Min = performance.getPerformance(this.m_Type);
                    continue;
                }
                if (performance.getPerformance(this.m_Type) < this.m_Min) {
                    this.m_Min = performance.getPerformance(this.m_Type);
                }
                if (!(performance.getPerformance(this.m_Type) > this.m_Max)) continue;
                this.m_Max = performance.getPerformance(this.m_Type);
            }
        }

        public Grid getGrid() {
            return this.m_Grid;
        }

        public Vector<Performance> getPerformances() {
            return this.m_Performances;
        }

        public int getType() {
            return this.m_Type;
        }

        public double[][] getTable() {
            return this.m_Table;
        }

        public double getMin() {
            return this.m_Min;
        }

        public double getMax() {
            return this.m_Max;
        }

        public String toString() {
            String string = "Table (" + new SelectedTag(this.getType(), TAGS_EVALUATION).getSelectedTag().getReadable() + ") - " + "X: " + this.getGrid().getLabelX() + ", Y: " + this.getGrid().getLabelY() + ":\n";
            for (int i = 0; i < this.getTable().length; ++i) {
                if (i > 0) {
                    string = string + "\n";
                }
                for (int j = 0; j < this.getTable()[i].length; ++j) {
                    if (j > 0) {
                        string = string + ",";
                    }
                    string = string + this.getTable()[i][j];
                }
            }
            return string;
        }

        public String toGnuplot() {
            StringBuffer stringBuffer = new StringBuffer();
            Tag tag = new SelectedTag(this.getType(), TAGS_EVALUATION).getSelectedTag();
            stringBuffer.append("Gnuplot (" + tag.getReadable() + "):\n");
            stringBuffer.append("# begin 'gridsearch.data'\n");
            stringBuffer.append("# " + tag.getReadable() + "\n");
            for (int i = 0; i < this.getPerformances().size(); ++i) {
                stringBuffer.append(this.getPerformances().get(i).toGnuplot(tag.getID()) + "\n");
            }
            stringBuffer.append("# end 'gridsearch.data'\n\n");
            stringBuffer.append("# begin 'gridsearch.plot'\n");
            stringBuffer.append("# " + tag.getReadable() + "\n");
            stringBuffer.append("set data style lines\n");
            stringBuffer.append("set contour base\n");
            stringBuffer.append("set surface\n");
            stringBuffer.append("set title '" + GridSearch.this.m_Data.relationName() + "'\n");
            stringBuffer.append("set xrange [" + this.getGrid().getMinX() + ":" + this.getGrid().getMaxX() + "]\n");
            stringBuffer.append("set xlabel 'x (" + GridSearch.this.getFilter().getClass().getName() + ": " + GridSearch.this.getXProperty() + ")'\n");
            stringBuffer.append("set yrange [" + this.getGrid().getMinY() + ":" + this.getGrid().getMaxY() + "]\n");
            stringBuffer.append("set ylabel 'y - (" + GridSearch.this.getClassifier().getClass().getName() + ": " + GridSearch.this.getYProperty() + ")'\n");
            stringBuffer.append("set zrange [" + (this.getMin() - (this.getMax() - this.getMin()) * 0.1) + ":" + (this.getMax() + (this.getMax() - this.getMin()) * 0.1) + "]\n");
            stringBuffer.append("set zlabel 'z - " + tag.getReadable() + "'\n");
            stringBuffer.append("set dgrid3d " + this.getGrid().height() + "," + this.getGrid().width() + ",1\n");
            stringBuffer.append("show contour\n");
            stringBuffer.append("splot 'gridsearch.data'\n");
            stringBuffer.append("pause -1\n");
            stringBuffer.append("# end 'gridsearch.plot'");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PerformanceComparator
    implements Comparator<Performance>,
    Serializable {
        private static final long serialVersionUID = 6507592831825393847L;
        protected int m_Evaluation;

        public PerformanceComparator(int n) {
            this.m_Evaluation = n;
        }

        public int getEvaluation() {
            return this.m_Evaluation;
        }

        @Override
        public int compare(Performance performance, Performance performance2) {
            double d;
            double d2 = performance.getPerformance(this.getEvaluation());
            int n = Utils.sm(d2, d = performance2.getPerformance(this.getEvaluation())) ? -1 : (Utils.gr(d2, d) ? 1 : 0);
            if (this.getEvaluation() != 0 && this.getEvaluation() != 6) {
                n = -n;
            }
            return n;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof PerformanceComparator)) {
                throw new IllegalArgumentException("Must be PerformanceComparator!");
            }
            return this.m_Evaluation == ((PerformanceComparator)object).m_Evaluation;
        }
    }

    protected class Performance
    implements Serializable {
        private static final long serialVersionUID = -4374706475277588755L;
        protected PointDouble m_Values;
        protected double m_CC;
        protected double m_RMSE;
        protected double m_RRSE;
        protected double m_MAE;
        protected double m_RAE;
        protected double m_ACC;

        public Performance(PointDouble pointDouble, Evaluation evaluation) throws Exception {
            this.m_Values = pointDouble;
            this.m_RMSE = evaluation.rootMeanSquaredError();
            this.m_RRSE = evaluation.rootRelativeSquaredError();
            this.m_MAE = evaluation.meanAbsoluteError();
            this.m_RAE = evaluation.relativeAbsoluteError();
            try {
                this.m_CC = evaluation.correlationCoefficient();
            }
            catch (Exception exception) {
                this.m_CC = Double.NaN;
            }
            try {
                this.m_ACC = evaluation.pctCorrect();
            }
            catch (Exception exception) {
                this.m_ACC = Double.NaN;
            }
        }

        public double getPerformance(int n) {
            double d = Double.NaN;
            switch (n) {
                case 0: {
                    d = this.m_CC;
                    break;
                }
                case 1: {
                    d = this.m_RMSE;
                    break;
                }
                case 2: {
                    d = this.m_RRSE;
                    break;
                }
                case 3: {
                    d = this.m_MAE;
                    break;
                }
                case 4: {
                    d = this.m_RAE;
                    break;
                }
                case 5: {
                    d = 1.0 - StrictMath.abs(this.m_CC) + this.m_RRSE + this.m_RAE;
                    break;
                }
                case 6: {
                    d = this.m_ACC;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Evaluation type '" + n + "' not supported!");
                }
            }
            return d;
        }

        public PointDouble getValues() {
            return this.m_Values;
        }

        public String toString(int n) {
            String string = "Performance (" + this.getValues() + "): " + this.getPerformance(n) + " (" + new SelectedTag(n, TAGS_EVALUATION) + ")";
            return string;
        }

        public String toGnuplot(int n) {
            String string = this.getValues().getX() + "\t" + this.getValues().getY() + "\t" + this.getPerformance(n);
            return string;
        }

        public String toString() {
            String string = "Performance (" + this.getValues() + "): ";
            for (int i = 0; i < TAGS_EVALUATION.length; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + this.getPerformance(TAGS_EVALUATION[i].getID()) + " (" + new SelectedTag(TAGS_EVALUATION[i].getID(), TAGS_EVALUATION) + ")";
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Grid
    implements Serializable {
        private static final long serialVersionUID = 7290732613611243139L;
        protected double m_MinX;
        protected double m_MaxX;
        protected double m_StepX;
        protected String m_LabelX;
        protected double m_MinY;
        protected double m_MaxY;
        protected double m_StepY;
        protected String m_LabelY;
        protected int m_Width;
        protected int m_Height;

        public Grid(double d, double d2, double d3, double d4, double d5, double d6) {
            this(d, d2, d3, "", d4, d5, d6, "");
        }

        public Grid(double d, double d2, double d3, String string, double d4, double d5, double d6, String string2) {
            this.m_MinX = d;
            this.m_MaxX = d2;
            this.m_StepX = d3;
            this.m_LabelX = string;
            this.m_MinY = d4;
            this.m_MaxY = d5;
            this.m_StepY = d6;
            this.m_LabelY = string2;
            this.m_Height = (int)StrictMath.round((this.m_MaxY - this.m_MinY) / this.m_StepY) + 1;
            this.m_Width = (int)StrictMath.round((this.m_MaxX - this.m_MinX) / this.m_StepX) + 1;
            if (this.m_MinX >= this.m_MaxX) {
                throw new IllegalArgumentException("XMin must be smaller than XMax!");
            }
            if (this.m_MinY >= this.m_MaxY) {
                throw new IllegalArgumentException("YMin must be smaller than YMax!");
            }
            if (this.m_StepX <= 0.0) {
                throw new IllegalArgumentException("XStep must be a positive number!");
            }
            if (this.m_StepY <= 0.0) {
                throw new IllegalArgumentException("YStep must be a positive number!");
            }
            if (!Utils.eq(this.m_MinX + (double)(this.m_Width - 1) * this.m_StepX, this.m_MaxX)) {
                throw new IllegalArgumentException("X axis doesn't match! Provided max: " + this.m_MaxX + ", calculated max via min and step size: " + (this.m_MinX + (double)(this.m_Width - 1) * this.m_StepX));
            }
            if (!Utils.eq(this.m_MinY + (double)(this.m_Height - 1) * this.m_StepY, this.m_MaxY)) {
                throw new IllegalArgumentException("Y axis doesn't match! Provided max: " + this.m_MaxY + ", calculated max via min and step size: " + (this.m_MinY + (double)(this.m_Height - 1) * this.m_StepY));
            }
        }

        public boolean equals(Object object) {
            Grid grid = (Grid)object;
            boolean bl = this.width() == grid.width() && this.height() == grid.height() && this.getMinX() == grid.getMinX() && this.getMinY() == grid.getMinY() && this.getStepX() == grid.getStepX() && this.getStepY() == grid.getStepY() && this.getLabelX().equals(grid.getLabelX()) && this.getLabelY().equals(grid.getLabelY());
            return bl;
        }

        public double getMinX() {
            return this.m_MinX;
        }

        public double getMaxX() {
            return this.m_MaxX;
        }

        public double getStepX() {
            return this.m_StepX;
        }

        public String getLabelX() {
            return this.m_LabelX;
        }

        public double getMinY() {
            return this.m_MinY;
        }

        public double getMaxY() {
            return this.m_MaxY;
        }

        public double getStepY() {
            return this.m_StepY;
        }

        public String getLabelY() {
            return this.m_LabelY;
        }

        public int height() {
            return this.m_Height;
        }

        public int width() {
            return this.m_Width;
        }

        public PointDouble getValues(int n, int n2) {
            if (n >= this.width()) {
                throw new IllegalArgumentException("Index out of scope on X axis (" + n + " >= " + this.width() + ")!");
            }
            if (n2 >= this.height()) {
                throw new IllegalArgumentException("Index out of scope on Y axis (" + n2 + " >= " + this.height() + ")!");
            }
            return new PointDouble(this.m_MinX + this.m_StepX * (double)n, this.m_MinY + this.m_StepY * (double)n2);
        }

        public PointInt getLocation(PointDouble pointDouble) {
            double d;
            int n;
            int n2 = 0;
            double d2 = this.m_StepX;
            for (n = 0; n < this.width(); ++n) {
                d = StrictMath.abs(pointDouble.getX() - this.getValues(n, 0).getX());
                if (!Utils.sm(d, d2)) continue;
                d2 = d;
                n2 = n;
            }
            int n3 = 0;
            d2 = this.m_StepY;
            for (n = 0; n < this.height(); ++n) {
                d = StrictMath.abs(pointDouble.getY() - this.getValues(0, n).getY());
                if (!Utils.sm(d, d2)) continue;
                d2 = d;
                n3 = n;
            }
            PointInt pointInt = new PointInt(n2, n3);
            return pointInt;
        }

        public boolean isOnBorder(PointDouble pointDouble) {
            return this.isOnBorder(this.getLocation(pointDouble));
        }

        public boolean isOnBorder(PointInt pointInt) {
            if (pointInt.getX() == 0.0) {
                return true;
            }
            if (pointInt.getX() == (double)(this.width() - 1)) {
                return true;
            }
            if (pointInt.getY() == 0.0) {
                return true;
            }
            return pointInt.getY() == (double)(this.height() - 1);
        }

        public Grid subgrid(int n, int n2, int n3, int n4) {
            return new Grid(this.getValues(n2, n).getX(), this.getValues(n4, n).getX(), this.getStepX(), this.getLabelX(), this.getValues(n2, n3).getY(), this.getValues(n2, n).getY(), this.getStepY(), this.getLabelY());
        }

        public Grid extend(PointDouble pointDouble) {
            double d;
            double d2 = Utils.smOrEq(pointDouble.getX(), this.getMinX()) ? (Utils.eq(d = this.getMinX() - pointDouble.getX(), 0.0) ? this.getMinX() - this.getStepX() * (double)(StrictMath.round(d / this.getStepX()) + 1L) : this.getMinX() - this.getStepX() * (double)StrictMath.round(d / this.getStepX())) : this.getMinX();
            double d3 = Utils.grOrEq(pointDouble.getX(), this.getMaxX()) ? (Utils.eq(d = pointDouble.getX() - this.getMaxX(), 0.0) ? this.getMaxX() + this.getStepX() * (double)(StrictMath.round(d / this.getStepX()) + 1L) : this.getMaxX() + this.getStepX() * (double)StrictMath.round(d / this.getStepX())) : this.getMaxX();
            double d4 = Utils.smOrEq(pointDouble.getY(), this.getMinY()) ? (Utils.eq(d = this.getMinY() - pointDouble.getY(), 0.0) ? this.getMinY() - this.getStepY() * (double)(StrictMath.round(d / this.getStepY()) + 1L) : this.getMinY() - this.getStepY() * (double)StrictMath.round(d / this.getStepY())) : this.getMinY();
            double d5 = Utils.grOrEq(pointDouble.getY(), this.getMaxY()) ? (Utils.eq(d = pointDouble.getY() - this.getMaxY(), 0.0) ? this.getMaxY() + this.getStepY() * (double)(StrictMath.round(d / this.getStepY()) + 1L) : this.getMaxY() + this.getStepY() * (double)StrictMath.round(d / this.getStepY())) : this.getMaxY();
            Grid grid = new Grid(d2, d3, this.getStepX(), this.getLabelX(), d4, d5, this.getStepY(), this.getLabelY());
            if (this.equals(grid)) {
                throw new IllegalStateException("Grid extension failed!");
            }
            return grid;
        }

        public Enumeration<PointDouble> row(int n) {
            Vector<PointDouble> vector = new Vector<PointDouble>();
            for (int i = 0; i < this.width(); ++i) {
                vector.add(this.getValues(i, n));
            }
            return vector.elements();
        }

        public Enumeration<PointDouble> column(int n) {
            Vector<PointDouble> vector = new Vector<PointDouble>();
            for (int i = 0; i < this.height(); ++i) {
                vector.add(this.getValues(n, i));
            }
            return vector.elements();
        }

        public String toString() {
            String string = "X: " + this.m_MinX + " - " + this.m_MaxX + ", Step " + this.m_StepX;
            if (this.m_LabelX.length() != 0) {
                string = string + " (" + this.m_LabelX + ")";
            }
            string = string + "\n";
            string = string + "Y: " + this.m_MinY + " - " + this.m_MaxY + ", Step " + this.m_StepY;
            if (this.m_LabelY.length() != 0) {
                string = string + " (" + this.m_LabelY + ")";
            }
            string = string + "\n";
            string = string + "Dimensions (Rows x Columns): " + this.height() + " x " + this.width();
            return string;
        }
    }

    protected class PointInt
    extends Point
    implements Serializable {
        private static final long serialVersionUID = -5900415163698021618L;

        public PointInt(int n, int n2) {
            super(n, n2);
        }

        public String toString() {
            return super.toString().replaceAll(".*\\[", "[");
        }
    }

    protected class PointDouble
    extends Point2D.Double
    implements Serializable {
        private static final long serialVersionUID = 7151661776161898119L;

        public PointDouble(double d, double d2) {
            super(d, d2);
        }

        public boolean equals(Object object) {
            PointDouble pointDouble = (PointDouble)object;
            return Utils.eq(this.getX(), pointDouble.getX()) && Utils.eq(this.getY(), pointDouble.getY());
        }

        public String toString() {
            return super.toString().replaceAll(".*\\[", "[");
        }
    }
}

