/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.lmt;

import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.lmt.ResidualSplit;
import weka.core.Instances;

public class ResidualModelSelection
extends ModelSelection {
    protected int m_minNumInstances;
    protected double m_minInfoGain;

    public ResidualModelSelection(int n) {
        this.m_minNumInstances = n;
        this.m_minInfoGain = 1.0E-4;
    }

    public void cleanup() {
    }

    public final ClassifierSplitModel selectModel(Instances instances, double[][] dArray, double[][] dArray2) throws Exception {
        int n = instances.numAttributes();
        if (n < 2) {
            throw new Exception("Can't select Model without non-class attribute");
        }
        if (instances.numInstances() < this.m_minNumInstances) {
            return new NoSplit(new Distribution(instances));
        }
        double d = -1.7976931348623157E308;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            double d2;
            if (i == instances.classIndex()) continue;
            ResidualSplit residualSplit = new ResidualSplit(i);
            residualSplit.buildClassifier(instances, dArray, dArray2);
            if (!residualSplit.checkModel(this.m_minNumInstances) || !((d2 = residualSplit.entropyGain()) > d)) continue;
            d = d2;
            n2 = i;
        }
        if (d >= this.m_minInfoGain) {
            ResidualSplit residualSplit = new ResidualSplit(n2);
            residualSplit.buildClassifier(instances, dArray, dArray2);
            return residualSplit;
        }
        return new NoSplit(new Distribution(instances));
    }

    public final ClassifierSplitModel selectModel(Instances instances) {
        return null;
    }

    public final ClassifierSplitModel selectModel(Instances instances, Instances instances2) {
        return null;
    }
}

