/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.NoSupportForMissingValuesException;
import weka.core.UnassignedClassException;
import weka.core.UnsupportedAttributeTypeException;
import weka.core.WekaException;

public class Capabilities
implements Cloneable,
Serializable {
    static final long serialVersionUID = -5478590032325567849L;
    private static final int ATTRIBUTE = 1;
    private static final int CLASS = 2;
    private static final int ATTRIBUTE_CAPABILITY = 4;
    private static final int CLASS_CAPABILITY = 8;
    private static final int OTHER_CAPABILITY = 16;
    protected CapabilitiesHandler m_Owner;
    protected HashSet m_Capabilities;
    protected HashSet m_Dependencies;
    protected Exception m_FailReason = null;
    protected int m_MinimumNumberInstances = 1;

    public Capabilities(CapabilitiesHandler capabilitiesHandler) {
        this.setOwner(capabilitiesHandler);
        this.m_Capabilities = new HashSet();
        this.m_Dependencies = new HashSet();
    }

    public Object clone() {
        Capabilities capabilities = new Capabilities(this.m_Owner);
        capabilities.assign(this);
        return capabilities;
    }

    public void assign(Capabilities capabilities) {
        for (Capability capability : Capability.values()) {
            if (capabilities.handles(capability)) {
                this.enable(capability);
            } else {
                this.disable(capability);
            }
            if (capabilities.hasDependency(capability)) {
                this.enableDependency(capability);
                continue;
            }
            this.disableDependency(capability);
        }
        this.setMinimumNumberInstances(capabilities.getMinimumNumberInstances());
    }

    public void and(Capabilities capabilities) {
        for (Capability capability : Capability.values()) {
            if (this.handles(capability) && capabilities.handles(capability)) {
                this.m_Capabilities.add(capability);
            } else {
                this.m_Capabilities.remove((Object)capability);
            }
            if (this.hasDependency(capability) && capabilities.hasDependency(capability)) {
                this.m_Dependencies.add(capability);
                continue;
            }
            this.m_Dependencies.remove((Object)capability);
        }
        if (capabilities.getMinimumNumberInstances() > this.getMinimumNumberInstances()) {
            this.setMinimumNumberInstances(capabilities.getMinimumNumberInstances());
        }
    }

    public void or(Capabilities capabilities) {
        for (Capability capability : Capability.values()) {
            if (this.handles(capability) || capabilities.handles(capability)) {
                this.m_Capabilities.add(capability);
            } else {
                this.m_Capabilities.remove((Object)capability);
            }
            if (this.hasDependency(capability) || capabilities.hasDependency(capability)) {
                this.m_Dependencies.add(capability);
                continue;
            }
            this.m_Dependencies.remove((Object)capability);
        }
        if (capabilities.getMinimumNumberInstances() < this.getMinimumNumberInstances()) {
            this.setMinimumNumberInstances(capabilities.getMinimumNumberInstances());
        }
    }

    public boolean supports(Capabilities capabilities) {
        boolean bl = true;
        for (Capability capability : Capability.values()) {
            if (!capabilities.handles(capability) || this.handles(capability)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean supportsMaybe(Capabilities capabilities) {
        boolean bl = true;
        for (Capability capability : Capability.values()) {
            if (!capabilities.handles(capability) || this.handles(capability) || this.hasDependency(capability)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void setOwner(CapabilitiesHandler capabilitiesHandler) {
        this.m_Owner = capabilitiesHandler;
    }

    public CapabilitiesHandler getOwner() {
        return this.m_Owner;
    }

    public void setMinimumNumberInstances(int n) {
        if (n >= 0) {
            this.m_MinimumNumberInstances = n;
        }
    }

    public int getMinimumNumberInstances() {
        return this.m_MinimumNumberInstances;
    }

    public Iterator capabilities() {
        return this.m_Capabilities.iterator();
    }

    public Iterator dependencies() {
        return this.m_Dependencies.iterator();
    }

    public void enable(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.enable(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.enable(Capability.BINARY_CLASS);
        }
        this.m_Capabilities.add(capability);
    }

    public void enableDependency(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.enableDependency(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.enableDependency(Capability.BINARY_CLASS);
        }
        this.m_Dependencies.add(capability);
    }

    public void enableAllClasses() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.enable(capability);
        }
    }

    public void enableAllClassDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.enableDependency(capability);
        }
    }

    public void enableAllAttributes() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.enable(capability);
        }
    }

    public void enableAllAttributeDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.enableDependency(capability);
        }
    }

    public void disable(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.disable(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.disable(Capability.BINARY_CLASS);
        }
        this.m_Capabilities.remove((Object)capability);
    }

    public void disableDependency(Capability capability) {
        if (capability == Capability.NOMINAL_ATTRIBUTES) {
            this.disableDependency(Capability.BINARY_ATTRIBUTES);
        } else if (capability == Capability.NOMINAL_CLASS) {
            this.disableDependency(Capability.BINARY_CLASS);
        }
        this.m_Dependencies.remove((Object)capability);
    }

    public void disableAllClasses() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.disable(capability);
        }
    }

    public void disableAllClassDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isClass()) continue;
            this.disableDependency(capability);
        }
    }

    public void disableAllAttributes() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.disable(capability);
        }
    }

    public void disableAllAttributeDependencies() {
        for (Capability capability : Capability.values()) {
            if (!capability.isAttribute()) continue;
            this.disableDependency(capability);
        }
    }

    public Capabilities getClassCapabilities() {
        Capabilities capabilities = new Capabilities(this.getOwner());
        for (Capability capability : Capability.values()) {
            if (!capability.isClassCapability() || !this.handles(capability)) continue;
            capabilities.enable(capability);
        }
        return capabilities;
    }

    public Capabilities getAttributeCapabilities() {
        Capabilities capabilities = new Capabilities(this.getOwner());
        for (Capability capability : Capability.values()) {
            if (!capability.isAttributeCapability() || !this.handles(capability)) continue;
            capabilities.enable(capability);
        }
        return capabilities;
    }

    public Capabilities getOtherCapabilities() {
        Capabilities capabilities = new Capabilities(this.getOwner());
        for (Capability capability : Capability.values()) {
            if (!capability.isOtherCapability() || !this.handles(capability)) continue;
            capabilities.enable(capability);
        }
        return capabilities;
    }

    public boolean handles(Capability capability) {
        return this.m_Capabilities.contains((Object)capability);
    }

    public boolean hasDependency(Capability capability) {
        return this.m_Dependencies.contains((Object)capability);
    }

    public boolean hasDependencies() {
        return this.m_Dependencies.size() > 0;
    }

    protected String createMessage(String string) {
        String string2 = "";
        string2 = this.getOwner() != null ? this.getOwner().getClass().getName() : "<anonymous>";
        string2 = string2 + ": " + string;
        return string2;
    }

    public boolean test(Attribute attribute) {
        return this.test(attribute, false);
    }

    public boolean test(Attribute attribute, boolean bl) {
        boolean bl2 = true;
        String string = bl ? "class" : "attributes";
        switch (attribute.type()) {
            case 1: {
                Capability capability;
                Capability capability2;
                if (bl) {
                    capability2 = Capability.NOMINAL_CLASS;
                    capability = Capability.BINARY_CLASS;
                } else {
                    capability2 = Capability.NOMINAL_ATTRIBUTES;
                    capability = Capability.BINARY_ATTRIBUTES;
                }
                if (this.handles(capability2)) break;
                if (!this.handles(capability2) && !this.handles(capability)) {
                    this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle nominal " + string + "!"));
                    bl2 = false;
                }
                if (!this.handles(capability) || this.handles(capability2) || attribute.numValues() == 2) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle non-binary " + string + "!"));
                bl2 = false;
                break;
            }
            case 0: {
                Capability capability = bl ? Capability.NUMERIC_CLASS : Capability.NUMERIC_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle numeric " + string + "!"));
                bl2 = false;
                break;
            }
            case 3: {
                Capability capability = bl ? Capability.DATE_CLASS : Capability.DATE_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle date " + string + "!"));
                bl2 = false;
                break;
            }
            case 2: {
                Capability capability = bl ? Capability.STRING_CLASS : Capability.STRING_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle string " + string + "!"));
                bl2 = false;
                break;
            }
            case 4: {
                Capability capability = bl ? Capability.RELATIONAL_CLASS : Capability.RELATIONAL_ATTRIBUTES;
                if (this.handles(capability)) break;
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle relational " + string + "!"));
                bl2 = false;
                break;
            }
            default: {
                this.m_FailReason = new UnsupportedAttributeTypeException(this.createMessage("Cannot handle unknown attribute type '" + attribute.type() + "'!"));
                bl2 = false;
            }
        }
        return bl2;
    }

    public boolean test(Instances instances) {
        return this.test(instances, 0, instances.numAttributes() - 1);
    }

    public boolean test(Instances instances, int n, int n2) {
        Attribute attribute;
        int n3;
        if (this.m_Capabilities.size() == 0 || this.m_Capabilities.size() == 1 && this.handles(Capability.NO_CLASS)) {
            System.err.println(this.createMessage("No capabilities set!"));
        }
        if (n2 - n < 0) {
            this.m_FailReason = new WekaException(this.createMessage("No attributes!"));
            return false;
        }
        boolean bl = instances.classIndex() > -1 && instances.classIndex() >= n && instances.classIndex() <= n2;
        for (n3 = n; n3 <= n2; ++n3) {
            attribute = instances.attribute(n3);
            if (n3 == instances.classIndex() || this.test(attribute)) continue;
            return false;
        }
        if (bl && !this.handles(Capability.NO_CLASS)) {
            if (instances.classIndex() == -1) {
                this.m_FailReason = new UnassignedClassException(this.createMessage("Class attribute not set!"));
                return false;
            }
            attribute = instances.classAttribute();
            if (!this.test(attribute, true)) {
                return false;
            }
            if (attribute.type() == 4) {
                boolean bl2 = this.handles(Capability.NO_CLASS);
                if (!bl2) {
                    this.enable(Capability.NO_CLASS);
                }
                boolean bl3 = this.test(attribute.relation());
                if (!bl2) {
                    this.disable(Capability.NO_CLASS);
                }
                if (!bl3) {
                    return false;
                }
            }
            if (!this.handles(Capability.MISSING_CLASS_VALUES)) {
                for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                    if (!instances.instance(n3).classIsMissing()) continue;
                    this.m_FailReason = new WekaException(this.createMessage("Cannot handle missing class values!"));
                    return false;
                }
            } else {
                int n4 = 0;
                for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                    if (instances.instance(n3).classIsMissing()) continue;
                    ++n4;
                }
                if (n4 < this.getMinimumNumberInstances()) {
                    this.m_FailReason = new WekaException(this.createMessage("Not enough training instances with class labels (required: " + this.getMinimumNumberInstances() + ", provided: " + n4 + ")!"));
                    return false;
                }
            }
        }
        if (!this.handles(Capability.MISSING_VALUES)) {
            for (n3 = 0; n3 < instances.numInstances(); ++n3) {
                Instance instance = instances.instance(n3);
                for (int i = n; i <= n2; ++i) {
                    if (i == instance.classIndex() || !instance.isMissing(i)) continue;
                    this.m_FailReason = new NoSupportForMissingValuesException(this.createMessage("Cannot handle missing values!"));
                    return false;
                }
            }
        }
        if (instances.numInstances() < this.getMinimumNumberInstances()) {
            this.m_FailReason = new WekaException(this.createMessage("Not enough training instances (required: " + this.getMinimumNumberInstances() + ", provided: " + instances.numInstances() + ")!"));
            return false;
        }
        if (this.handles(Capability.ONLY_MULTIINSTANCE)) {
            if (instances.numAttributes() != 3) {
                this.m_FailReason = new WekaException(this.createMessage("Incorrect Multi-Instance format, must be 'bag-id, bag, class'!"));
                return false;
            }
            if (!instances.attribute(0).isNominal() || !instances.attribute(1).isRelationValued() || instances.classIndex() != instances.numAttributes() - 1) {
                this.m_FailReason = new WekaException(this.createMessage("Incorrect Multi-Instance format, must be 'NOMINAL att, RELATIONAL att, CLASS att'!"));
                return false;
            }
            if (this.getOwner() instanceof MultiInstanceCapabilitiesHandler) {
                MultiInstanceCapabilitiesHandler multiInstanceCapabilitiesHandler = (MultiInstanceCapabilitiesHandler)this.getOwner();
                Capabilities capabilities = multiInstanceCapabilitiesHandler.getMultiInstanceCapabilities();
                boolean bl4 = instances.numInstances() > 0 ? capabilities.test(instances.attribute(1).relation(1)) : capabilities.test(instances.attribute(1).relation());
                if (!bl4) {
                    this.m_FailReason = capabilities.m_FailReason;
                    return false;
                }
            }
        }
        return true;
    }

    public void testWithFail(Attribute attribute) throws Exception {
        this.test(attribute, false);
    }

    public void testWithFail(Attribute attribute, boolean bl) throws Exception {
        if (!this.test(attribute, bl)) {
            throw this.m_FailReason;
        }
    }

    public void testWithFail(Instances instances, int n, int n2) throws Exception {
        if (!this.test(instances, n, n2)) {
            throw this.m_FailReason;
        }
    }

    public void testWithFail(Instances instances) throws Exception {
        if (!this.test(instances)) {
            throw this.m_FailReason;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = new Vector(this.m_Capabilities);
        Collections.sort(vector);
        stringBuffer.append("Capabilities: " + vector.toString() + "\n");
        vector = new Vector(this.m_Dependencies);
        Collections.sort(vector);
        stringBuffer.append("Dependencies: " + vector.toString() + "\n");
        stringBuffer.append("min # Instance: " + this.getMinimumNumberInstances() + "\n");
        return stringBuffer.toString();
    }

    public static Capabilities forInstances(Instances instances) throws Exception {
        return Capabilities.forInstances(instances, false);
    }

    public static Capabilities forInstances(Instances instances, boolean bl) throws Exception {
        int n;
        Capabilities capabilities = new Capabilities(null);
        if (instances.classIndex() == -1) {
            capabilities.enable(Capability.NO_CLASS);
        } else {
            switch (instances.classAttribute().type()) {
                case 1: {
                    if (instances.classAttribute().numValues() == 2) {
                        capabilities.enable(Capability.BINARY_CLASS);
                        break;
                    }
                    capabilities.enable(Capability.NOMINAL_CLASS);
                    break;
                }
                case 0: {
                    capabilities.enable(Capability.NUMERIC_CLASS);
                    break;
                }
                case 2: {
                    capabilities.enable(Capability.STRING_CLASS);
                    break;
                }
                case 3: {
                    capabilities.enable(Capability.DATE_CLASS);
                    break;
                }
                case 4: {
                    capabilities.enable(Capability.RELATIONAL_CLASS);
                    break;
                }
                default: {
                    throw new UnsupportedAttributeTypeException("Unknown class attribute type '" + instances.classAttribute() + "'!");
                }
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                if (!instances.instance(n).classIsMissing()) continue;
                capabilities.enable(Capability.MISSING_CLASS_VALUES);
                break;
            }
        }
        if (instances.checkForAttributeType(1)) {
            capabilities.enable(Capability.BINARY_ATTRIBUTES);
            for (n = 0; n < instances.numAttributes(); ++n) {
                if (n == instances.classIndex() || !instances.attribute(n).isNominal() || instances.attribute(n).numValues() == 2) continue;
                capabilities.enable(Capability.NOMINAL_ATTRIBUTES);
                break;
            }
        }
        if (instances.checkForAttributeType(0)) {
            capabilities.enable(Capability.NUMERIC_ATTRIBUTES);
        }
        if (instances.checkForAttributeType(2)) {
            capabilities.enable(Capability.STRING_ATTRIBUTES);
        }
        if (instances.checkForAttributeType(3)) {
            capabilities.enable(Capability.DATE_ATTRIBUTES);
        }
        if (instances.checkForAttributeType(4)) {
            capabilities.enable(Capability.RELATIONAL_ATTRIBUTES);
        }
        block9: for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) continue;
            for (n = 0; n < instances.numInstances(); ++n) {
                if (!instances.instance(n).isMissing(i)) continue;
                capabilities.enable(Capability.MISSING_VALUES);
                continue block9;
            }
        }
        if (bl && instances.numAttributes() == 3 && instances.attribute(0).isNominal() && instances.attribute(1).isRelationValued() && instances.classIndex() == instances.numAttributes() - 1) {
            Capabilities capabilities2 = new Capabilities(null);
            capabilities2.or(capabilities.getClassCapabilities());
            capabilities2.enable(Capability.NOMINAL_ATTRIBUTES);
            capabilities2.enable(Capability.RELATIONAL_ATTRIBUTES);
            capabilities2.enable(Capability.ONLY_MULTIINSTANCE);
            capabilities.assign(capabilities2);
        }
        return capabilities;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Capability {
        NOMINAL_ATTRIBUTES(5, "Nominal attributes"),
        BINARY_ATTRIBUTES(5, "Binary attributes"),
        NUMERIC_ATTRIBUTES(5, "Numeric attributes"),
        DATE_ATTRIBUTES(5, "Date attributes"),
        STRING_ATTRIBUTES(5, "String attributes"),
        RELATIONAL_ATTRIBUTES(5, "Relational attributes"),
        MISSING_VALUES(4, "Missing values"),
        NO_CLASS(8, "No class"),
        NOMINAL_CLASS(10, "Nominal class"),
        BINARY_CLASS(10, "Binary class"),
        NUMERIC_CLASS(10, "Numeric class"),
        DATE_CLASS(10, "Date class"),
        STRING_CLASS(10, "String class"),
        RELATIONAL_CLASS(10, "Relational class"),
        MISSING_CLASS_VALUES(8, "Missing class values"),
        ONLY_MULTIINSTANCE(16, "Only multi-Instance data");

        private int m_Flags = 0;
        private String m_Display;

        private Capability(int n2, String string2) {
            this.m_Flags = n2;
            this.m_Display = string2;
        }

        public boolean isAttribute() {
            return (this.m_Flags & 1) == 1;
        }

        public boolean isClass() {
            return (this.m_Flags & 2) == 2;
        }

        public boolean isAttributeCapability() {
            return (this.m_Flags & 4) == 4;
        }

        public boolean isOtherCapability() {
            return (this.m_Flags & 0x10) == 16;
        }

        public boolean isClassCapability() {
            return (this.m_Flags & 8) == 8;
        }

        public String toString() {
            return this.m_Display;
        }
    }
}

