/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.AdditionalMeasureProducer;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class FLR
extends Classifier
implements Serializable,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 3337906540579569626L;
    public static final float EPSILON = 1.0E-6f;
    private Vector learnedCode;
    private double m_Rhoa = 0.5;
    private FuzzyLattice bounds;
    private File m_BoundsFile = new File("");
    private boolean m_showRules = true;
    private int[] index;
    private String[] classNames;

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        Object object;
        int n;
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) continue;
            object = instances.attributeStats(n);
            if (instances.numInstances() != ((AttributeStats)object).missingCount && !Double.isNaN(((AttributeStats)object).numericStats.min) && !Double.isInfinite(((AttributeStats)object).numericStats.min)) continue;
            throw new Exception("All values are missing!" + instances.attribute(n).toString());
        }
        if (!this.m_BoundsFile.canRead()) {
            this.setBounds(instances);
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.m_BoundsFile));
                object = bufferedReader.readLine();
                this.bounds = new FuzzyLattice((String)object);
            }
            catch (Exception exception) {
                throw new Exception("Boundaries File structure error");
            }
        }
        if (this.bounds.length() != instances.numAttributes() - 1) {
            throw new Exception("Incompatible bounds file!");
        }
        this.checkBounds();
        this.index = new int[instances.numClasses()];
        this.classNames = new String[instances.numClasses()];
        for (n = 0; n < instances.numClasses(); ++n) {
            this.index[n] = 0;
            this.classNames[n] = "missing Class Name";
        }
        double d = this.m_Rhoa;
        this.learnedCode = new Vector();
        if (instances.firstInstance().classIsMissing()) {
            throw new Exception("In first instance, class is missing!");
        }
        FuzzyLattice fuzzyLattice = new FuzzyLattice(instances.firstInstance(), this.bounds);
        this.learnedCode.addElement(fuzzyLattice);
        int n2 = fuzzyLattice.getCateg();
        this.index[n2] = this.index[n2] + 1;
        this.classNames[fuzzyLattice.getCateg()] = instances.firstInstance().stringValue(instances.firstInstance().classIndex());
        for (int i = 1; i < instances.numInstances(); ++i) {
            boolean bl;
            int n3;
            Instance instance = instances.instance(i);
            int n4 = 0;
            for (int j = 0; j < instance.numAttributes() - 1; ++j) {
                if (j == instance.classIndex() || !instance.isMissing(j)) continue;
                ++n4;
            }
            if (instance.classIsMissing() || n4 == instance.numAttributes() - 1) continue;
            FuzzyLattice fuzzyLattice2 = new FuzzyLattice(instances.instance(i), this.bounds);
            double[] dArray = new double[this.learnedCode.size()];
            for (n3 = 0; n3 < this.learnedCode.size(); ++n3) {
                double d2;
                FuzzyLattice fuzzyLattice3 = (FuzzyLattice)this.learnedCode.get(n3);
                FuzzyLattice fuzzyLattice4 = fuzzyLattice2.join(fuzzyLattice3);
                dArray[n3] = d2 = fuzzyLattice3.valuation(this.bounds) / fuzzyLattice4.valuation(this.bounds);
            }
            do {
                n3 = 0;
                double d3 = dArray[0];
                for (int j = 1; j < this.learnedCode.size(); ++j) {
                    if (!(d3 < dArray[j])) continue;
                    n3 = j;
                    d3 = dArray[j];
                }
                FuzzyLattice fuzzyLattice5 = fuzzyLattice2;
                FuzzyLattice fuzzyLattice6 = (FuzzyLattice)this.learnedCode.get(n3);
                FuzzyLattice fuzzyLattice7 = fuzzyLattice6.join(fuzzyLattice5);
                double d4 = fuzzyLattice5.valuation(this.bounds) / fuzzyLattice7.valuation(this.bounds);
                if (fuzzyLattice2.getCateg() == fuzzyLattice6.getCateg() && d < d4) {
                    this.learnedCode.setElementAt(fuzzyLattice6.join(fuzzyLattice2), n3);
                    bl = false;
                    continue;
                }
                dArray[n3] = 0.0;
                d += (double)1.0E-6f;
                bl = false;
                for (int j = 0; j < this.learnedCode.size(); ++j) {
                    if (dArray[j] == 0.0) continue;
                    bl = true;
                }
                if (bl) continue;
                this.learnedCode.addElement(fuzzyLattice2);
                int n5 = fuzzyLattice2.getCateg();
                this.index[n5] = this.index[n5] + 1;
                this.classNames[fuzzyLattice2.getCateg()] = instances.instance(i).stringValue(instances.instance(i).classIndex());
            } while (bl);
        }
    }

    public double classifyInstance(Instance instance) {
        int n;
        FuzzyLattice fuzzyLattice = new FuzzyLattice(instance, this.bounds);
        double[] dArray = new double[this.learnedCode.size()];
        for (n = 0; n < this.learnedCode.size(); ++n) {
            FuzzyLattice fuzzyLattice2 = (FuzzyLattice)this.learnedCode.get(n);
            FuzzyLattice fuzzyLattice3 = fuzzyLattice.join(fuzzyLattice2);
            dArray[n] = fuzzyLattice2.valuation(this.bounds) / fuzzyLattice3.valuation(this.bounds);
        }
        n = 0;
        double d = dArray[0];
        for (int i = 1; i < this.learnedCode.size(); ++i) {
            if (!(d < dArray[i])) continue;
            n = i;
            d = dArray[i];
        }
        FuzzyLattice fuzzyLattice4 = (FuzzyLattice)this.learnedCode.get(n);
        return fuzzyLattice4.getCateg();
    }

    public String toString() {
        if (this.learnedCode != null) {
            String string = "";
            string = "FLR classifier\n=======================\n Rhoa = " + this.m_Rhoa;
            if (this.m_showRules) {
                string = string + "\n Extracted Rules (Fuzzy Lattices):\n\n";
                string = string + this.showRules();
                string = string + "\n\n Metric Space:\n" + this.bounds.toString();
            }
            string = string + "\n Total Number of Rules:    " + this.learnedCode.size() + "\n";
            for (int i = 0; i < this.index.length; ++i) {
                string = string + " Rules pointing in Class " + this.classNames[i] + " :" + this.index[i] + "\n";
            }
            return string;
        }
        String string = "FLR classifier\n=======================\n Rhoa = " + this.m_Rhoa;
        string = string + "No model built";
        return string;
    }

    public String toSummaryString() {
        String string = "";
        string = this.learnedCode == null ? string + "No model built" : string + "Total Number of Rules: " + this.learnedCode.size();
        return string;
    }

    public String showRules() {
        String string = "";
        for (int i = 0; i < this.learnedCode.size(); ++i) {
            FuzzyLattice fuzzyLattice = (FuzzyLattice)this.learnedCode.get(i);
            string = string + "Rule: " + i + " " + fuzzyLattice.toString();
        }
        return string;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(3);
        vector.addElement(new Option("\tSet vigilance parameter rhoa.\n\t(a float in range [0,1])", "R", 1, "-R"));
        vector.addElement(new Option("\tSet boundaries File\n\tNote:  The boundaries file is a simple text file containing \n\ta row with a Fuzzy Lattice defining the metric space.\n\tFor example, the boundaries file could contain the following \n\tthe metric space for the iris dataset:\n\t[ 4.3  7.9 ]  [ 2.0  4.4 ]  [ 1.0  6.9 ]  [ 0.1  2.5 ]  in Class:  -1\n\tThis lattice just contains the min and max value in each \n\tdimension.\n\tIn other kind of problems this may not be just a min-max \n\toperation, but it could contain limits defined by the problem \n\titself.\n\tThus, this option should be set by the user.\n\tIf ommited, the metric space used contains the mins and maxs \n\tof the training split.", "B", 1, "-B"));
        vector.addElement(new Option("\tShow Rules", "Y", 0, "-Y"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        this.m_showRules = Utils.getFlag('Y', stringArray);
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            this.m_Rhoa = Double.parseDouble(string2);
            if (this.m_Rhoa < 0.0 || this.m_Rhoa > 1.0) {
                throw new Exception("Vigilance parameter (rhoa) should be a real number in range [0,1]");
            }
        } else {
            this.m_Rhoa = 0.5;
        }
        if ((string = Utils.getOption('B', stringArray)).length() != 0) {
            this.m_BoundsFile = new File(string);
        }
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getRhoa();
        if (this.m_showRules) {
            stringArray[n++] = "-Y";
        }
        if (this.m_BoundsFile.toString() != "") {
            stringArray[n++] = "-B";
            stringArray[n++] = "" + this.getBoundsFile();
        }
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public double getRhoa() {
        return this.m_Rhoa;
    }

    public String getBoundsFile() {
        return this.m_BoundsFile.toString();
    }

    public boolean getShowRules() {
        return this.m_showRules;
    }

    public void setRhoa(double d) throws Exception {
        if (d < 0.0 || d > 1.0) {
            throw new Exception("Vigilance parameter (rhoa) should be a real number in range [0,1]!!!");
        }
        this.m_Rhoa = d;
    }

    public void setBoundsFile(String string) {
        this.m_BoundsFile = new File(string);
    }

    public void setShowRules(boolean bl) {
        this.m_showRules = bl;
    }

    public void setBounds(Instances instances) {
        this.bounds = new FuzzyLattice(instances.numAttributes() - 1);
        int n = 0;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) continue;
            AttributeStats attributeStats = instances.attributeStats(i);
            this.bounds.setMin(n, attributeStats.numericStats.min);
            this.bounds.setMax(n, attributeStats.numericStats.max);
            ++n;
        }
    }

    public void checkBounds() {
        for (int i = 0; i < this.bounds.length(); ++i) {
            if (this.bounds.getMin(i) != this.bounds.getMax(i)) continue;
            this.bounds.setMax(i, this.bounds.getMax(i) + (double)1.0E-6f);
        }
    }

    public String rhoaTipText() {
        return " The vigilance parameter value (default = 0.75)";
    }

    public String boundsFileTipText() {
        return " Point the filename containing the metric space";
    }

    public String showRulesTipText() {
        return " If true, displays the ruleset.";
    }

    public double getMeasure(String string) {
        if (string.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(string + " not supported (FLR)");
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement("measureNumRules");
        return vector.elements();
    }

    public double measureNumRules() {
        if (this.learnedCode == null) {
            return 0.0;
        }
        return this.learnedCode.size();
    }

    public String globalInfo() {
        return "Fuzzy Lattice Reasoning Classifier (FLR) v5.0\n\nThe Fuzzy Lattice Reasoning Classifier uses the notion of Fuzzy Lattices for creating a Reasoning Environment.\nThe current version can be used for classification using numeric predictors.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "I. N. Athanasiadis and V. G. Kaburlasos and P. A. Mitkas and V. Petridis");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Applying Machine Learning Techniques on Air Quality Data for Real-Time Decision Support");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "1st Intl. NAISO Symposium on Information Technologies in Environmental Engineering (ITEE-2003)");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2003");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "Gdansk, Poland");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ICSC-NAISO Academic Press");
        technicalInformation.setValue(TechnicalInformation.Field.NOTE, "Abstract in ICSC-NAISO Academic Press, Canada (ISBN:3906454339), pg.51");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.UNPUBLISHED);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "V. G. Kaburlasos and I. N. Athanasiadis and P. A. Mitkas and V. Petridis");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Fuzzy Lattice Reasoning (FLR) Classifier and its Application on Improved Estimation of Ambient Ozone Concentration");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2003");
        return technicalInformation;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(Evaluation.evaluateModel(new FLR(), stringArray));
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private class FuzzyLattice
    implements Serializable {
        static final long serialVersionUID = -3568003680327062404L;
        private double[] min;
        private double[] max;
        private int categ;
        private String className;

        public FuzzyLattice(Instance instance, FuzzyLattice fuzzyLattice) {
            this.min = new double[instance.numAttributes() - 1];
            this.max = new double[instance.numAttributes() - 1];
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (i == instance.classIndex()) continue;
                if (!instance.isMissing(i)) {
                    this.min[n] = instance.value(i) > fuzzyLattice.getMin(n) ? instance.value(i) : fuzzyLattice.getMin(n);
                    this.max[n] = instance.value(i) < fuzzyLattice.getMax(n) ? instance.value(i) : fuzzyLattice.getMax(n);
                    ++n;
                    continue;
                }
                this.min[n] = fuzzyLattice.getMax(n);
                this.max[n] = fuzzyLattice.getMin(n);
                ++n;
            }
            this.categ = (int)instance.value(instance.classIndex());
            this.className = instance.stringValue(instance.classIndex());
        }

        public FuzzyLattice(int n) {
            this.min = new double[n];
            this.max = new double[n];
            for (int i = 0; i < n; ++i) {
                this.min[i] = 0.0;
                this.max[i] = 0.0;
            }
            this.categ = -1;
            this.className = "Metric Space";
        }

        public FuzzyLattice(String string) {
            int n;
            int n2 = 0;
            for (n = 0; n < string.length(); ++n) {
                String string2 = string.substring(n, n + 1);
                if (!string2.equalsIgnoreCase("[")) continue;
                ++n2;
            }
            this.min = new double[n2];
            this.max = new double[n2];
            n = 0;
            int n3 = 0;
            String string3 = "";
            int n4 = 0;
            do {
                String string4 = string.substring(n4, n4 + 1);
                string3 = string3 + string4;
                if (string4.equalsIgnoreCase(" ")) {
                    if (!string3.equalsIgnoreCase(" ")) {
                        if (++n3 % 4 == 2) {
                            this.min[n] = Double.parseDouble(string3);
                        } else if (n3 % 4 == 3) {
                            this.max[n] = Double.parseDouble(string3);
                            ++n;
                        }
                    }
                    string3 = "";
                }
                ++n4;
            } while (n < n2);
            this.categ = -1;
            this.className = "Metric Space";
        }

        public double valuation(FuzzyLattice fuzzyLattice) {
            double d = 0.0;
            for (int i = 0; i < this.min.length; ++i) {
                d += 1.0 - (this.min[i] - fuzzyLattice.getMin(i)) / (fuzzyLattice.getMax(i) - fuzzyLattice.getMin(i));
                d += (this.max[i] - fuzzyLattice.getMin(i)) / (fuzzyLattice.getMax(i) - fuzzyLattice.getMin(i));
            }
            return d;
        }

        public int length() {
            return this.min.length;
        }

        public FuzzyLattice join(FuzzyLattice fuzzyLattice) {
            FuzzyLattice fuzzyLattice2 = new FuzzyLattice(fuzzyLattice.length());
            for (int i = 0; i < fuzzyLattice.min.length; ++i) {
                fuzzyLattice2.min[i] = fuzzyLattice.min[i] < this.min[i] ? fuzzyLattice.min[i] : this.min[i];
                fuzzyLattice2.max[i] = fuzzyLattice.max[i] > this.max[i] ? fuzzyLattice.max[i] : this.max[i];
            }
            fuzzyLattice2.categ = this.categ;
            fuzzyLattice2.className = this.className;
            return fuzzyLattice2;
        }

        public int getCateg() {
            return this.categ;
        }

        public void setCateg(int n) {
            this.categ = n;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public double getMin(int n) {
            return this.min[n];
        }

        public double getMax(int n) {
            return this.max[n];
        }

        public void setMin(int n, double d) {
            this.min[n] = d;
        }

        public void setMax(int n, double d) {
            this.max[n] = d;
        }

        public String toString() {
            String string = "";
            for (int i = 0; i < this.min.length; ++i) {
                string = string + "[ " + this.min[i] + "  " + this.max[i] + " ]  ";
            }
            string = string + "in Class:  " + this.className + " \n";
            return string;
        }
    }
}

