% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromThresholds.R
\name{fromThresholds}
\alias{fromThresholds}
\title{Convert credit quality thresholds to probabilities.}
\usage{
fromThresholds(thresh)
}
\arguments{
\item{thresh}{\emph{m-by-m} matrix of credit quality thresholds. In each row, the first element must be \emph{Inf} and the entries must satisfy the following monotonicity condition:}
}
\value{
Returns a \emph{m-by-m} matrix with transition probabilities, in percent.
}
\description{
Use this function to transform credit quality thresholds into transition probabilities.
}
\examples{

rc <- c("AAA", "AA", "A", "BBB", "BB", "B", "CCC", "D")
t<- matrix(c(Inf,-1.3656,-2.1806,-3.0781,-3.5482,-4.1612,-4.2591,-4.8399,
             Inf, 1.5712,-1.5217,-2.3028,-2.6872,-3.5256,-3.7324,-4.1972,
             Inf, 2.6895, 1.3806,-1.2901,-2.3422,-2.8928,-3.0063,-3.7861,
             Inf, 3.1004, 2.5623, 1.4479,-1.5211,-2.1407,-2.434,	-3.2814,
             Inf, 3.4339, 2.6156, 2.4434, 1.4561,-1.4573,-1.9742,-2.4668,
             Inf, 2.5852, 2.5586, 2.4218, 2.268,	 1.6737,-1.6194,-2.252,
             Inf, 3.6953, 3.6362, 3.3406, 2.5019, 2.2394, 1.6263,-1.3853,
             Inf, Inf,	   Inf,	   Inf,	   Inf,	   Inf,	   Inf,	   Inf
), 8,8, dimnames = list(rc,rc), byrow=TRUE)


transmatrix <- fromThresholds(t)


}
\references{
MathWorld.com (2011). Matlab Central \url{http://www.mathworks.com/matlabcentral/}. Mathtools.net \url{http://www.mathtools.net/}.
}
\author{
Abdoulaye (Ab) N'Diaye
}
