% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ris.R
\name{ris}
\alias{ris}
\alias{print.ris}
\title{Calculate required sample and trials size.}
\usage{
ris(
  outcome,
  mc,
  side = 2,
  alpha = 0.05,
  beta = 0.1,
  fixed = TRUE,
  sd_mc = NULL,
  p0 = NULL,
  p1 = NULL,
  ma = NULL,
  tau2 = NULL,
  I2 = NULL,
  D2 = NULL,
  type = "prospective",
  trials = NULL,
  ...
)
}
\arguments{
\item{outcome}{Choose between: "MD" (mean difference), "RR" (relative risk), "OR" (odds ratio) or "RD" (risk difference).}

\item{mc}{Minimum clinical relevant effect. For "OR" or "RR" set to natural scale, not log scale.}

\item{side}{Test type. Set to 1 or 2 depending on the test being 1- or 2-sided.}

\item{alpha}{Level of type-I-error. Default value is 0.05.}

\item{beta}{Level of type-II-error. Default value is 0.2.}

\item{fixed}{Should sample size be based on a fixed- or random-effects model. Defaults to TRUE.}

\item{sd_mc}{Standard deviation of estimated effect. Only needed when outcome = "MD".}

\item{p0}{Probability of event in control group.}

\item{p1}{Probability of event in treatment group.}

\item{ma}{An optional \code{metaanalysis} object.}

\item{tau2}{The value of the heterogeneity. Use when estimating the sample size under a random effects model. If data is provided, the estimated heterogeneity is used instead.}

\item{I2}{Inconsistency.}

\item{D2}{Diversity.}

\item{type}{Prospective or retrospective sample size calculation.}

\item{trials}{optional number of trials for design.}

\item{...}{additional arguments}
}
\value{
A list of up to 6 elements:
\item{settings}{A list containing the arguments provided to the \code{ris} function.}
\item{NF}{The total number of required participants in a fixed-effect meta-analysis if type is prospective. Contains a list if the type is retrospective, where \code{NF} is the additional required number of participants and \code{NF_full} is the total required number of participants.}
\item{NR_tau}{A list containing: \code{minTrial} the minimum number of trials. \code{nPax} a matrix containing four possible number of trials with the number of participants per trial and total number of participants. \code{tau2} the estimate used for the calculation. Might contain \code{NR_tau_ll} and \code{NR_tau_ul} which contain the same three elements. \code{NR_tau_ll} is based on the lower value in the confidence interval of tau2. \code{NR_tau_ul} is based on the upper value in the confidence interval for tau2. If the type is prospective the numbers are the total required. If the type is retrospective the numbers are the additional required.}
\item{NR_D2}{The total number of required participants in a random-effects meta-analysis adjusted by diversity (\code{D2}) if type is prospective. Contains a list if the type is retrospective, where \code{NR_D2} is the additional required number of participants and \code{NR_D2_full} is the total required number of participants.}
\item{NR_I2}{The total number of required participants in a random-effects meta-analysis adjusted by inconsistency (\code{I2}) if type is prospective. Contains a list if the type is retrospective, where \code{NR_I2} is the additional required number of participants and \code{NR_I2_full} is the total required number of participants.}
}
\description{
Calculate required sample and trials size.
}
\examples{
ris(outcome = "RR", mc = 0.8, p0 = 0.12, fixed = TRUE)

data("perioOxy")
ma <- metaanalysis(outcome = "RR", data = perioOxy, mc = 0.8, beta = 0.2)
ma$ris
ma <- metaanalysis(outcome = "RR", data = perioOxy)
ris(outcome = "RR", mc = 0.8, ma = ma, type = "retrospective", fixed = FALSE, beta = 0.2)
}
