% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promptBeta.R
\name{promptBeta}
\alias{promptBeta}
\title{Computes betas of futures contracts with respect to the 1st line contract}
\usage{
promptBeta(x = x, period = "all", betatype = "all", output = "chart")
}
\arguments{
\item{x}{Wide dataframe with date column and multiple series columns (multivariate). \code{tibble}}

\item{period}{"all" or numeric period of time in last n periods as character eg "100". \code{character}}

\item{betatype}{"all" "bull" "bear". \code{character}}

\item{output}{"betas" or "chart". \code{character}}
}
\value{
betas data frame \code{tibble} or plotly chart of betas \code{htmlwidgets}
}
\description{
Returns betas of futures contracts versus front futures contract.
}
\examples{
\dontrun{
 x <- dflong \%>\%
 dplyr::filter(grepl("CL",series)) \%>\%
 dplyr::mutate(series = readr::parse_number(series)) \%>\% dplyr::group_by(series) \%>\%
 RTL::returns(df = ., retType = "abs",period.return = 1,spread = TRUE) \%>\%
 RTL::rolladjust(x = .,commodityname = c("cmewti"),rolltype = c("Last.Trade")) \%>\%
 # removing the day it prices went negative...
 dplyr::filter(!date \%in\% c(as.Date("2020-04-20"),as.Date("2020-04-21")))
promptBeta(x = x, period = "all", betatype = "all", output = "chart")
promptBeta(x = x, period = "all", betatype = "bull", output = "betas")
promptBeta(x = x, period = "100", betatype = "bear", output = "betas")
}
}
\author{
Philippe Cote
}
