% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morningstar.R
\name{getPrice}
\alias{getPrice}
\title{Morningstar Commodities API single call}
\usage{
getPrice(
  feed = "CME_NymexFutures_EOD",
  contract = "@CL21Z",
  from = "2020-09-01",
  iuser = "x@xyz.com",
  ipassword = "pass"
)
}
\arguments{
\item{feed}{Morningstar Feed Table. \code{character}}

\item{contract}{Morningstar key. \code{character}}

\item{from}{From date yyyy-mm-dd. \code{character}}

\item{iuser}{Morningstar user name as character - sourced locally in examples. \code{character}}

\item{ipassword}{Morningstar user password as character - sourced locally in examples. \code{character}}
}
\value{
wide data frame. \code{tibble}
}
\description{
Returns data from Morningstar API. See below for current feeds supported.
You need your own credentials with Morningstar. In examples sourced locally.
}
\section{Current Feeds Supported}{

\itemize{
\item CME_CbotFuturesEOD and CME_CbotFuturesEOD_continuous
\item CME_NymexFutures_EOD and CME_NymexFutures_EOD_continuous
\item CME_NymexOptions_EOD
\item CME_CmeFutures_EOD and CME_CmeFutures_EOD_continuous
\item CME_Comex_FuturesSettlement_EOD and CME_Comex_FuturesSettlement_EOD_continuous
\item LME_AskBidPrices_Delayed
\item SHFE_FuturesSettlement_RT
\item ICE_EuroFutures and ICE_EuroFutures_continuous
\item ICE_NybotCoffeeSugarCocoaFutures and ICE_NybotCoffeeSugarCocoaFutures_continuous
\item CME_STLCPC_Futures
\item CFTC_CommitmentsOfTradersCombined. Requires multiple keys. Separate them by a space e.g. "N10 06765A NYME 01".
\item Morningstar_FX_Forwards. Requires multiple keys. Separate them by a space e.g. "USDCAD 2M".
\item ERCOT_LmpsByResourceNodeAndElectricalBus.
\item PJM_Rt_Hourly_Lmp.
\item AESO_ForecastAndActualPoolPrice.
}
}

\examples{
\dontrun{
getPrice(
  feed = "CME_NymexFutures_EOD", contract = "@CL21Z",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "CME_NymexFutures_EOD_continuous", contract = "CL_006_Month",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "CME_NymexOptions_EOD", contract = "@LO21ZP4000",
  from = "2020-03-15", iuser = username, ipassword = password
)
getPrice(
  feed = "CME_CbotFuturesEOD", contract = "C0Z",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "CME_CbotFuturesEOD_continuous", contract = "ZB_001_Month",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "CME_CmeFutures_EOD_continuous", contract = "HE_006_Month",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "Morningstar_FX_Forwards", contract = "USDCAD 2M",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "CME_CmeFutures_EOD", contract = "LH0N",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "CME_CmeFutures_EOD_continuous", contract = "HE_006_Month",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "ICE_EuroFutures", contract = "BRN0Z",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "ICE_EuroFutures_continuous", contract = "BRN_001_Month",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "ICE_NybotCoffeeSugarCocoaFutures", contract = "SB21H",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "ICE_NybotCoffeeSugarCocoaFutures_continuous", contract = "SF_001_Month",
  from = "2019-08-26", iuser = username, ipassword = password
)
getPrice(
  feed = "AESO_ForecastAndActualPoolPrice", contract = "Forecast_Pool_Price",
  from = "2021-04-01", iuser = username, ipassword = password
)
getPrice(
  feed = "LME_MonthlyDelayed_Derived", contract = "AHD 2021-12-01 2021-12-31",
  from = "2021-04-01", iuser = username, ipassword = password
)
}

}
\author{
Philippe Cote
}
