% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetPolygonLimits.R
\name{SetPolygonLimits}
\alias{SetPolygonLimits}
\title{GUI: Polygon Limits}
\usage{
SetPolygonLimits(poly.names = NULL, poly.data = NULL, poly.crop = NULL,
  parent = NULL)
}
\arguments{
\item{poly.names}{character.
Vector of polygon names}

\item{poly.data}{character.
Name of the polygon that defines the data limits boundary.}

\item{poly.crop}{character.
Name of the polygon that defines the crop region for interpolated data.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Queries and sets the following components of \code{\link{Data}}:
  \item{credit}{mapping credit note}
  \item{explanation}{explanation of gridded-data values.}
  \item{legend.title}{title to be placed at the top of the points legend.}
  \item{legend.subtitle}{subtitle to be placed at the top of the points legend.}
}
\description{
A graphical user interface (\acronym{GUI}) for specifying polygon limits.
}
\examples{
\dontrun{
  SetPolygonLimits(c("Polygon1", "Polygon2", "Polygon3"))
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
