% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExportData.R
\name{ExportData}
\alias{ExportData}
\title{GUI: Export Data}
\usage{
ExportData(file.type = "txt", parent = NULL)
}
\arguments{
\item{file.type}{character.
Output file type: either
  \var{txt} for text files,
  \var{rda} for R-data files, or
  \var{shp} for shapefiles.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Saves the \acronym{GUI} options in the \code{export} component of \code{\link{Data}}.
  List components of \code{export} include:
    \item{processed}{indicates whether exported data are limited to processed records.}
    \item{fmts}{indicates whether a header line of conversion specification format strings is written (text only).}
    \item{cols}{indicates whether a header line of column names is written (text only).}
    \item{rows}{indicates whether the row names are written (text only).}
    \item{comment}{indicates whether to write comments using the comment character, \code{com} (text only).}
    \item{sep}{field separator character (text only).}
    \item{dec}{string used for decimal points (text only).}
    \item{nas}{string interpreted as \code{\link{NA}} value (text only).}
    \item{com}{comment character (text only).}
    \item{qmethod}{a string specifying how to deal with embedded double quote characters when quoting strings (text only).}
    \item{quote}{if true, any character or factor columns will be surrounded by double quotes (text only).}
    \item{encoding}{declares the encoding to be used on the file (text only).}
    \item{eol}{the character to print at the end of each line (text only).}
    \item{zip}{indicate whether the file should be compressed using \href{http://www.gzip.org/}{gzip},
      \href{http://www.bzip.org/}{bzip2}, or \href{http://tukaani.org/xz/format.html}{xz} (text only).}
    \item{changelog}{indicate if a separate text file should be written with the change log (text only).}
    \item{ascii}{if true, an \acronym{ASCII} representation of the data is written (R data only).}
}
\description{
A graphical user interface (\acronym{GUI}) for exporting data to text files, shapefiles, or R data files.
}
\examples{
\dontrun{
  Data(replace.all = obj)
  ExportData(file.type = "txt")
}

}
\seealso{
\code{\link[utils]{write.table}}, \code{\link{save}}, \code{\link[rgdal]{writeOGR}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{IO}
