% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/40_ci_adapter.R
\name{ci_adapter_create_base}
\alias{ci_adapter_create_base}
\title{Creates the base presentation for the CI adapter to use by concrete implementations.}
\usage{
ci_adapter_create_base(name)
}
\arguments{
\item{name}{name under which CI adapter will be registered in RSuite. It
cannot contain whitespaces or comma. (type: character)}
}
\value{
object of type rsuite_ci_adapter
}
\description{
Creates the base presentation for the CI adapter to use by concrete implementations.
}
\examples{
# create you own CI adapter
ci_adapter_create_own <- function() {
  result <- ci_adapter_create_base("Own")
  class(result) <- c("ci_adapter_own", class(result))
  return(result)
}

}
\seealso{
Other in extending RSuite with CI adapter: \code{\link{ci_adapter_get_version}},
  \code{\link{ci_adapter_is_building}}
}
\concept{in extending RSuite with CI adapter}
