% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tva.R
\name{stantva_code}
\alias{stantva_code}
\title{Generate StanTVA code}
\usage{
stantva_code(
  formula = NULL,
  locations,
  task = c("wr", "pr"),
  regions = list(),
  C_mode = c("equal", "locations", "regions"),
  w_mode = c("locations", "regions", "equal"),
  t0_mode = c("constant", "gaussian", "exponential", "shifted_exponential"),
  K_mode = c("bernoulli", "free", "binomial", "betabinomial"),
  max_K = locations,
  allow_guessing = FALSE,
  parallel = isTRUE(rstan_options("threads_per_chain") > 1L),
  save_log_lik = FALSE,
  priors = NULL,
  sanity_checks = TRUE,
  debug_neginf_loglik = FALSE
)
}
\arguments{
\item{formula}{Optional formulas for nested and hierarchical model parameters.}

\item{locations}{The number of display locations (items).}

\item{task}{The task. Currently implemented: \code{wr} (whole report) and \code{pr} (partial report)}

\item{regions}{An optional list of groups of display locations (regions).}

\item{C_mode}{The mode/family for the $C$ parameter.}

\item{w_mode}{The mode/family for the $w$ parameter.}

\item{t0_mode}{The mode/family for the $t_0$ parameter.}

\item{K_mode}{The mode for the $K$ parameter.}

\item{max_K}{The upper bound of $K$.}

\item{allow_guessing}{(logical) Whether to allow guessing.}

\item{parallel}{(logical) Whether to use parallel chains.}

\item{save_log_lik}{(logical) Whether to save the log likelihood (needed for likelihood-based model comparison such as loo).}

\item{priors}{The priors.}

\item{sanity_checks}{(logical) Whether to perform sanity checks.}

\item{debug_neginf_loglik}{(logical) Whether to debug negative infinity log likelihood.}
}
\value{
The StanTVA model code object.
}
\description{
Creates a StanTVA model code object.
}
\examples{
model <- stantva_code(locations = 4, task = "pr")
model
}
