% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSmartlyData.R
\name{getSmartlyData}
\alias{getSmartlyData}
\title{Get Smartly.io Data}
\usage{
getSmartlyData(start, end, date = "date", accountID, accountInfo = F,
  campaignStructure = NULL, billing = NULL, targeting = NULL,
  creative = NULL, facebook = NULL, attribution = "28d", apiToken,
  metrics)
}
\arguments{
\item{start}{Beginning of date range. Format: "2016-05-01"}

\item{end}{End of date range. Format: "2016-05-02"}

\item{date}{Date aggregation level. One out of date, year, month, weekofyear, weekday}

\item{accountID}{Smartly.io Account ID. Input as character: "1234abcdefg5678"}

\item{accountInfo}{Account Information. TRUE/FALSE}

\item{campaignStructure}{Campaign Information Selection. Vector with multiple arguments out of: campaign_name, campaign_fb_id, adgroup_name, adgroup_fb_id, name, id, fb_objective, campaign_start_date}

\item{billing}{Billing Information Selection. Vector with multiple arguments out of: bid.optimization_goal, bid.billing_event}

\item{targeting}{Targeting Settings of Campaigns. Vector with multiple arguments out of: targeting.geo_locations.countries, targeting.geo_locations.cities, targeting.genders, targeting.age_min, targeting.age_max, targeting.interests, targeting.behaviors, targeting.custom_audiences, targeting.excluded_custom_audiences, targeting.connections, targeting.user_os, targeting.user_device, targeting.page_types}

\item{creative}{Creative/Ad Characteristics. Vector with multiple arguments out of: creative_meta.call_to_action, creative_meta, creative_meta.type, creative_meta.post_type, creative_meta.name, creative_meta.picture, creative_meta.post_fb_id, creative_meta.post_fb_link, creative_meta.text, creative_meta.title, creative_meta.link, creative_meta.url_tags}

\item{facebook}{Facebook Settings. One argument out of: age, country, gender, age_gender, placement, cross_device, region, hourly_stats_aggregated_by_advertiser_time_zone, hourly_stats_aggregated_by_audience_time_zone}

\item{attribution}{Attribtuion Time Window, defaults to 28 days. One of: "1d","7d" or "28d".}

\item{apiToken}{API Token. Character. Usually the API token is provided within the Smartly.io web interface or by the account manager.}

\item{metrics}{Metrics. Note: There are more metrics available. See the reporting section in the smartly.io interface. Vector with multiple argumets out of: impressions, ctr, cpm, cpc, spent, conversions, inline_link_clicks, clicks, cpa, reach, frequency, roi, revenue, social_impressions, social_clicks, website_clicks, newsfeed_clicks, deeplink_clicks, app_store_clicks, call_to_action_clicks, inline_post_engagement}
}
\value{
Dataframe
}
\description{
getSmartlyData posts the query and downloads the data.
The data are retrieved from the API as a dataframe.
}

