% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accountMethods.R
\name{getListOfSiblingAccounts}
\alias{getListOfSiblingAccounts}
\title{Get a list of sibling accounts}
\usage{
getListOfSiblingAccounts(account, username = Sys.getenv("SLUSER"),
  page = NULL, per_page = 50L, ...)
}
\arguments{
\item{account}{An object of class "account". An account object see \code{\link{account}}.}

\item{username}{SauceLabs username}

\item{page}{optional defaults to NULL}

\item{per_page}{results per page (max 50L). Defaults to 50L}

\item{...}{Additonal function arguments - Currently unused.}
}
\description{
Get a list of sibling accounts associated with provided account
}
\examples{
\dontrun{
myAcc <- account()
appData <- getUser(myAcc)

createUser(myAcc, newUsername = "superstartester", password = "johndoe"
           , name = "John", email = "superstartester@example.com")
# $errors
# [1] "Subaccount capacity exhausted."
uC <- getUserConcurrency(myAcc)
#> rbindlist(uC$concurrency$self[c("allowed", "current")], fill = TRUE)
#manual mac overall real_device
#1:      5   5       5           0
#2:      0   0       0          NA
users <- getListOfSubAccounts(myAcc)
#> users$users_total
#[1] 1
siblings <- getListOfSiblingAccounts(myAcc)
#> getListOfSiblingAccounts(myAcc)
#list()
subAcc <- getSubAccountInformation(myAcc)

# change accesskey for a user
# changeAccessKey(myAcc, "rsaucelabs")
}
}
\seealso{
Other accountMethods: \code{\link{changeAccessKey}},
  \code{\link{createUser}},
  \code{\link{getListOfSubAccounts}},
  \code{\link{getSubAccountInformation}},
  \code{\link{getUserConcurrency}}, \code{\link{getUser}}
}

