% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.set.R
\name{dist.set}
\alias{dist.set}
\title{Distance for Symbolic Set Variables.}
\usage{
dist.set(sym.data, variables, gamma = 0.5, method = "Minkowski",
  normalize = TRUE, q = 1, pond = rep(1, length(variables)))
}
\arguments{
\item{sym.data}{A symbolic object}

\item{variables}{Numeric vector with the number of the variables to use.}

\item{gamma}{gamma value for the methods ichino and minkowski.}

\item{method}{Method to use (Gowda.Diday, Ichino, Minkowski, Hausdorff)}

\item{normalize}{A logical value indicating whether normalize the data in the ichino or hausdorff method.}

\item{q}{q value for the Minkowski method.}

\item{pond}{A numeric vector}
}
\value{
An object of class "dist"
}
\description{
This function computes and returns the distance matrix by using the specified
distance measure to compute distance between symbolic interval variables.
}
