% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotConv.R
\name{plotConv}
\alias{plotConv}
\title{Graphical representation of search.conv results}
\usage{
plotConv(SC,y,variable,RR=NULL,state=NULL,aceV=NULL)
}
\arguments{
\item{SC}{an object produced by \code{\link{search.conv}}.}

\item{y}{the multivariate phenotype used to perform \code{search.conv}.}

\item{variable}{the index of result to plot. If convergence between clades is
inspected, this is the position within the \code{SC$'average distance from
group centroids'} vector of the clade pair to be plotted. In the case of
convergence between states, this is the number of the line of
\code{SC$state.res} where results for the state pair are returned.}

\item{RR}{the object produced by \code{\link{RRphylo}} used to perform
\code{search.conv}. This is not indicated if convergence between states is
tested.}

\item{state}{the named vector of tip states used to perform \code{search.conv}.
This is not indicated if convergence between clades is tested.}

\item{aceV}{phenotypic values at internal nodes to be provided if used to
perform \code{search.conv}.}
}
\value{
If convergence between clades was tested, \code{plotConv} returns a
 list of four functions:

\strong{\code{$plotHistTips}} shows the mean Euclidean distance
 computed between phenotypic vectors of all the tips belonging to the
 converging clades as compared to the distribution of distances between all
 possible pair of tips across the rest of the tree. The usage is:
 \code{...$plotHistTips(hist.args=NULL,line.args=NULL)}, where
 \code{hist.args} is a list of further arguments passed to the function
 \code{hist}, and \code{line.args} is a list of further arguments passed to
 the function \code{lines}.

\strong{\code{$plotHistAces}} shows the Euclidean distance computed
 between phenotypic vectors of the MRCAs of the converging clades as compared
 to the distribution of distances between all possible pairs of nodes across
 the rest of the tree. The usage is identical to \code{$plotHistTips}.

\strong{\code{$plotPChull}} generates a PC1/PC2 plot obtained by
 performing a PCA of the species phenotypes. Convergent clades are indicated
 by colored convex hulls. Large dots represent the mean phenotypes per clade
 (i.e. their group centroids) and asterisks (customizable) represent the
 ancestral phenotypes of the individual clades. The usage is:
 \code{...$plotPChull(plot.args=NULL,chull.args=NULL,means.args=NULL,}
 \code{ace.args=NULL,legend.args=list()},where \code{plot.args} is a list of
 further arguments passed to the function \code{plot}, \code{chull.args} is a
 list of further arguments passed to the function \code{polygon},
 \code{means.args} and \code{ace.args} are lists of further argument passed
 to the function \code{points} to customize the dots representing the
 centroids and the ancestral phenotypes respectively, and \code{legend.args}
 is a list of additional arguments passed to the function \code{legend} (if
 \code{= NULL} the legend is not plotted).

\strong{\code{$plotTraitgram}} produces a modified traitgram plot (see
 package \pkg{picante}) highlighting the branches of the clades found to
 converge. The usage is:
 \code{plotTraitgram(colTree=NULL,colNodes=NULL,...)}, where \code{colTree}
 is the color to represent the traitgram lines not pertaining the converging
 clades, \code{colNodes} is the color (or the vector of colors) to represent
 the traitgram lines pertaining the converging clades, and \code{...} are
 further arguments passed to the function \code{plot} to plot lines.

If convergence between states was tested, \code{plotConv} returns a
 list of two functions:

\strong{\code{$plotPChull}} generates a PC1/PC2 plot obtained by
 performing a PCA of the species phenotypes, with colored convex hulls
 enclosing species belonging to different states. The usage is:
 \code{...$plotPChull(plot.args=NULL,chull.args=NULL,points.args=NULL,}
 \code{legend.args=list()}, where \code{plot.args} is a list of further
 arguments passed to the function \code{plot}, \code{chull.args} is a list of
 further arguments passed to the function \code{polygon}, \code{points.args}
 is a list of further argument passed to the function \code{points}, and
 \code{legend.args} is a list of additional arguments passed to the function
 \code{legend} (if \code{= NULL} the legend is not plotted).

\strong{\code{$plotPolar}} produces a polar plot of the mean angle
 within/between state/s as compared to the 95% confidence interval of random
 angles. The usage is:
 \code{...$plotPolar(polar.args=NULL,polygon.args=NULL,line.args=NULL)},
 where \code{polar.args} is a list of further arguments passed to the
 function \code{\link[plotrix]{polar.plot}} to set the plot basics (i.e.
 \code{radial.lim}, \code{start}, and so on), \code{polygon.args} is a list
 of further arguments passed to the function \code{polar.plot} under the
 condition \code{rp.type="p"} (see \code{plotrix::polar.plot} for details) to
 set the angles distribution graphics, and \code{line.args} is a list of
 further arguments passed to the function \code{polar.plot} under the
 condition \code{rp.type="r"} to set the mean angle graphics.
}
\description{
This function generates customized functions to produce plots out of
 \code{\link{search.conv}} results.
}
\examples{
\dontrun{
data("DataFelids")
DataFelids$PCscoresfel->PCscoresfel
DataFelids$treefel->treefel
DataFelids$statefel->statefel->state2
state2[sample(which(statefel=="nostate"),20)]<-"st2"
cc<- 2/parallel::detectCores()

RRphylo(treefel,PCscoresfel,clus=cc)->RRfel

search.conv(RR=RRfel, y=PCscoresfel, min.dim=5, min.dist="node9",clus=cc)->sc_clade
plotConv(sc_clade,PCscoresfel,variable=2,RR=RRfel)->pc

pc$plotHistTips(hist.args = list(col="gray80",yaxt="n",cex.axis=0.8,cex.main=1.5),
                line.args = list(lwd=3,lty=4,col="purple"))
pc$plotHistAces(hist.args = list(col="gray80",cex.axis=0.8,cex.main=1.5),
                line.args = list(lwd=3,lty=4,col="gold"))
pc$plotPChull(chull.args = list(border=c("cyan","magenta"),lty=1),
              means.args = list(pch=c(23,22),cex=3,bg=c("cyan2","magenta2")),
              ace.args=list(pch=9),legend.args = NULL)
pc$plotTraitgram(colTree = "gray70",colNodes = c("cyan","magenta"))


search.conv(tree=treefel, y=PCscoresfel, state=statefel,declust=TRUE,clus=cc)->sc_state
plotConv(sc_state,PCscoresfel,variable=1,state=statefel)->pc
pc$plotPChull(chull.args = list(border=c("gray70","blue"),lty=1),
              points.args = list(pch=c(23,22),bg="gray"),
              legend.args = list(pch=c(23,22),x="top"))

pc$plotPolar(polar.args = list(clockwise=TRUE,start=0,rad.col="black",grid.col="black"),
             polygon.args = list(line.col="green",poly.col=NA,lwd=2),
             line.args = list(line.col="deeppink",lty=2,lwd=3))

    }
}
\references{
Castiglione, S., Serio, C., Tamagnini, D., Melchionna, M.,
 Mondanaro, A., Di Febbraro, M., Profico, A., Piras, P.,Barattolo, F., &
 Raia, P. (2019). A new, fast method to search for morphological convergence
 with shape data. \emph{PLoS ONE}, 14, e0226949.
 https://doi.org/10.1371/journal.pone.0226949
}
\seealso{
\href{../doc/search.conv.html}{\code{search.conv} vignette}

\href{../doc/Plotting-tools.html}{\code{plotConv} vignette}
}
\author{
Silvia Castiglione
}
