% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix.poly.R
\name{fix.poly}
\alias{fix.poly}
\title{Resolving polytomies to non-zero length branches}
\usage{
fix.poly(tree,type=c("collapse","resolve"),node=NULL,tol=1e-10,random=TRUE)
}
\arguments{
\item{tree}{a phylogenetic tree.}

\item{type}{either 'collapse' to create polytomies to one or more specific
nodes or 'resolve' to resolve (fix) all the polytomies within the tree or
to one or more specific nodes.}

\item{node}{the node in the tree where a polytomy should be created or fixed,
either. If \code{type='resolve'} and \code{node=NULL} all the polytomies
present in the tree are resolved.}

\item{tol}{the tolerance to consider a branch length significantly greater
than zero, set at 1e-10 by default. If \code{type='resolve'}, all the
branch lengths smaller than \code{tol} are treated as polytomies.}

\item{random}{a logical value specifying whether to resolve the polytomies
randomly (the default) or in the order they appear in the tree (if
\code{random = FALSE}).}
}
\value{
A phylogenetic tree with randomly fixed (i.e. \code{type='resolve'})
  polytomies or created polytomies (i.e. \code{type='collapse'}).
}
\description{
The function either collapses clades under a polytomy or
  resolves polytomous clades to non-zero length branches, dichotomous clades.
}
\details{
Under \code{type='resolve'} polytomous clades are resolved adding
  non-zero length branches to each new node. The evolutionary time attached
  to the new nodes is partitioned equally below the dichotomized clade.
}
\examples{
\dontrun{
 require(ape)

 data("DataCetaceans")
 DataCetaceans$treecet->treecet

 # Resolve all the polytomies within Cetaceans phylogeny
 fix.poly(treecet,type="resolve")->treecet.fixed
 par(mfrow=c(1,2))
 plot(treecet,no.margin=TRUE,show.tip.label=FALSE)
 plot(treecet.fixed,no.margin=TRUE,show.tip.label=FALSE)

 # Resolve the polytomies pertaining the genus Kentriodon
 fix.poly(treecet,type="resolve",node=221)->treecet.fixed2
 par(mfrow=c(1,2))
 plot(treecet,no.margin=TRUE,show.tip.label=FALSE)
 plot(treecet.fixed2,no.margin=TRUE,show.tip.label=FALSE)

 # Collapse Delphinidae into a polytomous clade
 fix.poly(treecet,type="collapse",node=179)->treecet.collapsed
 par(mfrow=c(1,2))
 plot(treecet,no.margin=TRUE,show.tip.label=FALSE)
 plot(treecet.collapsed,no.margin=TRUE,show.tip.label=FALSE)
}
}
\references{
Castiglione, S., Serio, C., Piccolo, M., Mondanaro, A.,
  Melchionna, M., Di Febbraro, M., Sansalone, G., Wroe, S., & Raia, P.
  (2020). The influence of domestication, insularity and sociality on the
  tempo and mode of brain size evolution in mammals. \emph{Biological Journal
  of the Linnean Society},in press. doi:10.1093/biolinnean/blaa186
}
\seealso{
\href{../doc/Tree-Manipulation.html#fix.poly}{\code{fix.poly}
  vignette};
}
\author{
Silvia Castiglione, Pasquale Raia, Carmela Serio
}
