% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRates.R
\name{plotRates}
\alias{plotRates}
\title{Plot RRphylo rates at a specified node}
\usage{
plotRates(RR,node,export.tiff =FALSE,foldername=NULL,filename=NULL)
}
\arguments{
\item{RR}{an object produced by \code{\link{RRphylo}}.}

\item{node}{the node subtending the clade of interest.}

\item{export.tiff}{if \code{TRUE} the function save a "rate_bars.tiff" file
inside the working directory. It is \code{TRUE} by default.}

\item{foldername}{has been deprecated; please see the argument
\code{filename} instead.}

\item{filename}{a character indicating the name of the tiff file and the path
where it is to be saved. If no path is indicated the file is stored in the
working directory.}
}
\value{
The function produces two barplots. On the left side, the rates (in
 absolute values) computed for the focal clade (blue) are plotted against the
 rates of the rest of the tree (green). On the right side, the absolute rates
 of individual branches of the focal clade are collated in increasing rate
 value (blue bars), and contrasted to the average rate computed over the rest
 of the tree branches (the vertical red line). It also returns the rate
 values for both nodes and species descending from the focal node.
}
\description{
The function \code{plotRates} plots the \code{\link{RRphylo}}
 rates computed for a given clade as compared to the rates computed for the
 rest of the tree.
}
\examples{
\donttest{
data("DataApes")
DataApes$PCstage->PCstage
DataApes$Tstage->Tstage
cc<- 2/parallel::detectCores()

RRphylo(tree=Tstage,y=PCstage,clus=cc)->RR

plotRates(RR,node=72,export.tiff = FALSE)
}
}
\seealso{
\href{../doc/RRphylo.html}{\code{RRphylo} vignette}
}
