% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{EichhornHayreData}
\alias{EichhornHayreData}
\title{Randomized Response Survey on family income}
\format{A data frame containing 150 observations of a sample extracted from a population of families divided into two strata.
The variables are:
\itemize{
 \item ID: Survey ID
 \item ST: Strata ID
 \item z: The randomized response to the question: What is the annual household income?
 \item Pi: first-order inclusion probabilities
}}
\usage{
EichhornHayreData
}
\description{
This data set contains observations from a randomized response survey conducted in a population of families to investigate their income.
The sample is drawn by stratified sampling by house ownership.
The randomized response technique used is the Eichhorn and Hayre model (Eichhorn and Hayre, 1983) with scramble variable \eqn{S=F(20,20)}.
}
\examples{
data(EichhornHayreData)
}
\references{
Eichhorn, B.H., Hayre, L.S. (1983).
\emph{Scrambled randomized response methods for obtaining sensitive quantitative data.}
Journal of Statistical Planning and Inference, 7, 306-316.
}
\seealso{
\code{\link{EichhornHayre}}
}
\keyword{datasets}

