% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.lm.rrpp.r
\name{coef.lm.rrpp}
\alias{coef.lm.rrpp}
\title{coef for lm.rrpp model fits}
\usage{
\method{coef}{lm.rrpp}(object, test = FALSE, confidence = 0.95, ...)
}
\arguments{
\item{object}{Object from \code{\link{lm.rrpp}}}

\item{test}{Logical argument that if TRUE, performs hypothesis tests 
(Null hypothesis is vector distance = 0)
for the observed coefficients.  If FALSE, only the observed coefficients 
are returned.}

\item{confidence}{The desired confidence limit to print with a table of 
summary statistics,
if test = TRUE.  Because distances are directionless, confidence limits 
are one-tailed.}

\item{...}{Other arguments (currently none)}
}
\description{
Computes ordinary or generalized least squares coefficients
over the permutations of an \code{\link{lm.rrpp}} model fit with predefined 
random permutations.
For each coefficient vector, the Euclidean distance is calculated as an 
estimate of
the amount of change in Y, the n x p matrix of dependent variables; larger 
distances mean more change 
in location in the data space associated with a one unit change in the model 
design, for the parameter
described.  Random coefficients are based on either RRPP or FRPP, as defined 
by the 
\code{\link{lm.rrpp}} model fit.  

This function can be used to test the specific coefficients of an 
lm.rrpp fit.  The test
statistics are the distances (d), which are also standardized (Z-scores).  
The Z-scores might be easier to compare,
as the expected values for random distances can vary among coefficient 
vectors.

If RRPP is used, all distributions of coefficient vector distances are 
based on appropriate null models, as defined by SS type.  Please be aware that this 
can result in two seemingly strange but reasonable phenomena.  First, if type II or
type III SS is used, the intercept will not appear in test results (because the function
seeks model parameter differences to know for which coefficients to calculate Euclidean 
distances).  Even if it appears for type I SS, this is merely an artifact of sequential
model building and there really is no meaningful test of intercept = 0.  Second, 
Euclidean distances might not always be logical, especially when viewing univariate
coefficients, in which case the expected d is |b|.  Coefficients without a test are
based on the full model; tests are based on the estimates of coefficients (b), 
given a null model.  For example, for a model, y ~ b1 + b2 + b3, with type I SS,
b2 will be estimated and tested, using a null model, y ~ b1 and a full model, 
y ~ b1 + b2.  The estimate for b2 might not be the same in the test as when estimated 
from the model, y ~ b1 + b2 + b3.  Therefore, the d statistic might not reflect what one
would expect from the full model (like when using type III SS).
}
\examples{
# See examples for lm.rrpp to see how anova.lm.rrpp works in conjunction
# with other functions

data(Pupfish)
names(Pupfish)
Pupfish$logSize <- log(Pupfish$CS)

fit <- lm.rrpp(coords ~ logSize + Sex*Pop, SS.type = "I", data = Pupfish) 

coef(fit)
coef(fit, test = TRUE, confidence = 0.99)
}
\author{
Michael Collyer
}
\keyword{utilities}
