% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{r_test_c}
\alias{r_test_c}
\title{Residual randomization test}
\usage{
r_test_c(y, X, lam, lam0, cluster_eps_r, use_perm, use_sign, num_R)
}
\arguments{
\item{y}{Vector of outcomes (n x 1).}

\item{X}{Matrix of covariates (n x p). First column should be 1's.}

\item{lam}{Vector of coefficients in linear H0 (p x 1).}

\item{lam0}{Scalar value for linear H0.}

\item{cluster_eps_r}{A \code{List} with restricted residuals. See \link{get_clustered_eps}.}

\item{use_perm}{\code{Boolean} flag whether to use permutations within clusters.}

\item{use_sign}{\code{Boolean} flag whether to use sign flips across clusters.}

\item{num_R}{Integer of how many randomization values to calculate.}
}
\value{
A \code{List} with the observed test statistic value (\code{tobs}), and the randomization values (\code{tvals})
}
\description{
Implements the residual randomization test. The hypothesis tested is
}
\details{
H0: lam' beta = lam[1] * beta[1] + ... + lam[p] * beta[p] = lam0.
}
