% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPhosFate.R
\name{erosionPrerequisites,RPhosFate-method}
\alias{erosionPrerequisites,RPhosFate-method}
\alias{erosionPrerequisites}
\title{Erosion prerequisites}
\usage{
\S4method{erosionPrerequisites}{RPhosFate}(x)
}
\arguments{
\item{x}{An S4 \code{\linkS4class{RPhosFate}} river catchment object.}
}
\value{
An S4 \code{\linkS4class{RPhosFate}} river catchment object and side effects in
the form of raster files.
}
\description{
Calculates and writes capped slopes, L- and RUSLE S-factors (equations for
summer conditions and slopes \eqn{\geq}{≥} 15 ft) to disk. Weighted flow
accumulations less than one are set to one for the calculation of the
L-factors.
}
\examples{
\donttest{
# temporary demonstration project copy
cv_dir <- demoProject()
# load temporary demonstration project
x <- RPhosFate(
  cv_dir = cv_dir,
  ls_ini = TRUE
)

x <- erosionPrerequisites(x)}

}
\references{
\cite{Renard, K.G., Foster, G.R., Weesies, G.A., McCool, D.K., Yoder, D.C.,
1997. Predicting soil erosion by water: a guide to conservation planning with
the Revised Universal Soil Loss Equation (RUSLE), Agriculture Handbook. U.S.
Government Printing Office, Washington, DC.}
}
\seealso{
\code{\link{firstRun}}, \code{\link{subsequentRun}}
}
