% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StdDev_SE.R
\name{StdDev.SE}
\alias{StdDev.SE}
\title{Standard Error Estimate for Standard Deviation (StdDev) of Returns}
\usage{
StdDev.SE(data, se.method = c("IFiid", "IFcor", "IFcorAdapt", "IFcorPW",
  "BOOTiid", "BOOTcor")[1:2], cleanOutliers = FALSE,
  fitting.method = c("Exponential", "Gamma")[1], ...)
}
\arguments{
\item{data}{Data of returns for one or multiple assets or portfolios.}

\item{se.method}{A character string indicating which method should be used to compute
the standard error of the estimated standard deviation. One or a combination of:
\code{"IFiid"} (default), \code{"IFcor"} (default), \code{"IFcorPW"}, \code{"IFcorAdapt"} (default),
\code{"BOOTiid"} or \code{"BOOTcor"}.}

\item{cleanOutliers}{Boolean variable to indicate whether the pre-whitenning of the influence functions TS should be done through a robust filter.}

\item{fitting.method}{Distribution used in the standard errors computation. Should be one of "Exponential" (default) or "Gamma".}

\item{...}{Additional parameters.}
}
\value{
A vector or a list depending on \code{se.method}.
}
\description{
\code{StdDev.SE} computes the standard error of the standard deviation of the returns.
}
\examples{
# Loading data from PerformanceAnalytics
data(edhec, package = "PerformanceAnalytics")
class(edhec)
# Changing the data colnames
names(edhec) = c("CA", "CTA", "DIS", "EM", "EMN",
                 "ED", "FIA", "GM", "LS", "MA",
                 "RV", "SS", "FOF")
# Computing the standard errors for
# the two influence functions based approaches
StdDev.SE(edhec, se.method=c("IFiid","IFcor","IFcorAdapt"),
          cleanOutliers=FALSE,
          fitting.method=c("Exponential", "Gamma")[1])

}
\author{
Xin Chen, \email{chenx26@uw.edu}

Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
